/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\f\u0010\f\u001a\u00020\u0004*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AssignBackingFieldFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "removeRedundantWhiteSpace", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSetterBackingFieldAssignmentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetterBackingFieldAssignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/AssignBackingFieldFix\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n381#2,11:111\n1#3:122\n*S KotlinDebug\n*F\n+ 1 SetterBackingFieldAssignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/AssignBackingFieldFix\n*L\n106#1:111,11\n*E\n"})
final class AssignBackingFieldFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message("assign.backing.field.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        KtPropertyAccessor ktPropertyAccessor = psiElement2 instanceof KtPropertyAccessor ? (KtPropertyAccessor)psiElement2 : null;
        if (ktPropertyAccessor == null) {
            return;
        }
        KtPropertyAccessor setter2 = ktPropertyAccessor;
        List list2 = setter2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull((List)list2);
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter2 = ktParameter;
        KtBlockExpression ktBlockExpression = setter2.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        this.removeRedundantWhiteSpace(bodyExpression);
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)setter2, false, 2, null);
        KtExpression assignment2 = psiFactory.createExpression("field = " + parameter2.getName());
        List list3 = bodyExpression.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getStatements(...)");
        KtExpression lastStatement = (KtExpression)CollectionsKt.lastOrNull((List)list3);
        if (lastStatement != null) {
            bodyExpression.addAfter((PsiElement)assignment2, (PsiElement)lastStatement);
            bodyExpression.addAfter(psiFactory.createNewLine(), (PsiElement)lastStatement);
            GenericPsiUtils.reformatted$default((PsiElement)bodyExpression, false, 1, null);
        } else {
            bodyExpression.addBefore((PsiElement)assignment2, bodyExpression.getRBrace());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeRedundantWhiteSpace(KtBlockExpression $this$removeRedundantWhiteSpace) {
        block4: {
            Object v0;
            Sequence sequence2;
            block3: {
                void $this$singleOrNull$iv;
                Sequence sequence3;
                Sequence sequence4;
                PsiElement psiElement2 = $this$removeRedundantWhiteSpace.getLBrace();
                if (psiElement2 == null || (sequence4 = PsiUtilsKt.siblings$default((PsiElement)psiElement2, (boolean)false, (boolean)false, (int)1, null)) == null || (sequence3 = SequencesKt.takeWhile((Sequence)sequence4, (Function1)((Function1)new Function1<PsiElement, Boolean>($this$removeRedundantWhiteSpace){
                    final /* synthetic */ KtBlockExpression $this_removeRedundantWhiteSpace;
                    {
                        this.$this_removeRedundantWhiteSpace = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !Intrinsics.areEqual((Object)it, (Object)this.$this_removeRedundantWhiteSpace.getRBrace());
                    }
                }))) == null) break block4;
                sequence2 = sequence3;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PsiWhiteSpace)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            PsiElement psiElement3 = v0;
            if (psiElement3 != null) {
                Sequence it = sequence2 = psiElement3;
                boolean bl = false;
                it.delete();
            }
        }
    }
}

