/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractRangeInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceUntilWithRangeUntilInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceUntilWithRangeUntilInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeaturesFUSCollector;
import org.jetbrains.kotlin.idea.statistics.NewAndDeprecatedFeaturesInspectionData;
import org.jetbrains.kotlin.idea.util.RangeKtExpressionType;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractRangeInspection;", "()V", "visitRange", "", "range", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "type", "Lorg/jetbrains/kotlin/idea/util/RangeKtExpressionType;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "ReplaceFix", "Util", "kotlin.idea"})
public final class ReplaceUntilWithRangeUntilInspection
extends AbstractRangeInspection {
    public ReplaceUntilWithRangeUntilInspection() {
        super(KotlinLanguageFeaturesFUSCollector.INSTANCE.getRangeUntilCollector(), new NewAndDeprecatedFeaturesInspectionData(false, false, 3, null));
    }

    @Override
    public void visitRange(@NotNull KtExpression range2, @NotNull Lazy<? extends BindingContext> context2, @NotNull RangeKtExpressionType type2, @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (Util.INSTANCE.isPossibleToUseRangeUntil((KtElement)range2, context2)) {
            this.updateDeprecationData(session2, (Function1)new Function1<NewAndDeprecatedFeaturesInspectionData, NewAndDeprecatedFeaturesInspectionData>(type2){
                final /* synthetic */ RangeKtExpressionType $type;
                {
                    this.$type = $type;
                    super(1);
                }

                @NotNull
                public final NewAndDeprecatedFeaturesInspectionData invoke(@NotNull NewAndDeprecatedFeaturesInspectionData it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return switch (visitRange.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                        case 1 -> it.withDeprecatedFeature();
                        case 2 -> it.withNewFeature();
                        default -> it;
                    };
                }
            });
            if (type2 != RangeKtExpressionType.UNTIL) {
                return;
            }
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceFix()};
            holder.registerProblem((PsiElement)range2, KotlinBundle.message("until.can.be.replaced.with.rangeUntil.operator", new Object[0]), localQuickFixArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection$ReplaceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "kotlin.idea"})
    private static final class ReplaceFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{"..<"};
            return KotlinBundle.message("replace.with.0.operator", objectArray);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtExpression ktExpression = psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(element3);
            if (pair == null) {
                return;
            }
            Pair<KtExpression, KtExpression> pair2 = pair;
            KtExpression left = (KtExpression)pair2.component1();
            KtExpression right = (KtExpression)pair2.component2();
            if (left == null || right == null) {
                return;
            }
            KotlinLanguageFeaturesFUSCollector.INSTANCE.getRangeUntilCollector().logQuickFixApplied(element3.getContainingFile());
            Object[] objectArray = new Object[]{left, right};
            element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (String)"$0..<$1", (Object[])objectArray, (boolean)false, (int)4, null));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection$Util;", "", "()V", "isPossibleToUseRangeUntil", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nReplaceUntilWithRangeUntilInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceUntilWithRangeUntilInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplaceUntilWithRangeUntilInspection$Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @ApiStatus.Internal
        public final boolean isPossibleToUseRangeUntil(@NotNull KtElement $this$isPossibleToUseRangeUntil, @Nullable Lazy<? extends BindingContext> context2) {
            Intrinsics.checkNotNullParameter((Object)$this$isPossibleToUseRangeUntil, (String)"<this>");
            FqName annotationFqName = new FqName("kotlin.ExperimentalStdlibApi");
            LanguageVersionSettings languageVersionSettings2 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)$this$isPossibleToUseRangeUntil);
            Module module2 = ProjectStructureUtilKt.getModule((PsiElement)$this$isPossibleToUseRangeUntil);
            if (module2 == null) return false;
            Module it = module2;
            boolean bl = false;
            Project project2 = $this$isPossibleToUseRangeUntil.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!ExpressionsKt.areKotlinVersionsSufficientToUseRangeUntil(languageVersionSettings2, it, project2)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            Lazy<? extends BindingContext> lazy = context2;
            if (lazy == null) return false;
            Lazy<? extends BindingContext> it2 = lazy;
            boolean bl3 = false;
            if (!ReplaceUntilWithRangeUntilInspectionKt.access$isOtpInRequiredForRangeUntil($this$isPossibleToUseRangeUntil, annotationFqName, (BindingContext)it2.getValue())) return true;
            if (!OptInUsageChecker.Companion.isOptInAllowed((PsiElement)$this$isPossibleToUseRangeUntil, annotationFqName, languageVersionSettings2, (BindingContext)it2.getValue())) return false;
            return true;
        }
    }
}

