/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.Replacement;
import org.jetbrains.kotlin.idea.inspections.ReplacementCollection;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\u0018*\u00020\b2\u0006\u0010\u0019\u001a\u0002H\u00182\u001d\u0010\u001a\u001a\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\b0\u001b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u001fR-\u0010\u0005\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplacementCollection;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createParameter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/ExtensionFunctionType;", "getCreateParameter", "()Lkotlin/jvm/functions/Function1;", "setCreateParameter", "(Lkotlin/jvm/functions/Function1;)V", "elementToRename", "getElementToRename", "()Lcom/intellij/psi/PsiElement;", "setElementToRename", "(Lcom/intellij/psi/PsiElement;)V", "replacements", "", "Lorg/jetbrains/kotlin/idea/inspections/Replacement;", "add", "", "T", "element", "replacementFactory", "Lkotlin/Function2;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function2;)V", "apply", "isNotEmpty", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nScopeFunctionConversionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplacementCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,372:1\n1002#2,2:373\n*S KotlinDebug\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplacementCollection\n*L\n134#1:373,2\n*E\n"})
public final class ReplacementCollection {
    @NotNull
    private final Project project;
    @NotNull
    private final List<Replacement<? extends PsiElement>> replacements;
    @NotNull
    private Function1<? super KtPsiFactory, ? extends PsiElement> createParameter;
    @Nullable
    private PsiElement elementToRename;

    public ReplacementCollection(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.replacements = new ArrayList();
        this.createParameter = createParameter.1.INSTANCE;
    }

    @NotNull
    public final Function1<KtPsiFactory, PsiElement> getCreateParameter() {
        return this.createParameter;
    }

    public final void setCreateParameter(@NotNull Function1<? super KtPsiFactory, ? extends PsiElement> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.createParameter = function1;
    }

    @Nullable
    public final PsiElement getElementToRename() {
        return this.elementToRename;
    }

    public final void setElementToRename(@Nullable PsiElement psiElement2) {
        this.elementToRename = psiElement2;
    }

    public final <T extends PsiElement> void add(@NotNull T element3, @NotNull Function2<? super KtPsiFactory, ? super T, ? extends PsiElement> replacementFactory) {
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        Intrinsics.checkNotNullParameter(replacementFactory, (String)"replacementFactory");
        this.replacements.add(Replacement.Companion.create(element3, replacementFactory));
    }

    public final void apply() {
        KtPsiFactory factory2 = new KtPsiFactory(this.project, false, 2, null);
        this.elementToRename = (PsiElement)this.createParameter.invoke((Object)factory2);
        List<Replacement<? extends PsiElement>> $this$sortBy$iv = this.replacements;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    Replacement it = (Replacement)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getEndOffset());
                    it = (Replacement)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getEndOffset()));
                }
            });
        }
        for (Replacement<? extends PsiElement> replacement2 : this.replacements) {
            replacement2.apply(factory2);
        }
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.replacements).isEmpty();
    }
}

