/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.conventionNameCalls;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.ReplaceGetOrSetInspectionUtils;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.ModifierChecksKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionText", "isApplicable", "", "isExplicitOperator", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReplaceGetOrSetInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceGetOrSetInspection.kt\norg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1747#2,3:82\n*S KotlinDebug\n*F\n+ 1 ReplaceGetOrSetInspection.kt\norg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection\n*L\n35#1:82,3\n*E\n"})
public final class ReplaceGetOrSetInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    public ReplaceGetOrSetInspection() {
        super(KtDotQualifiedExpression.class);
    }

    private final boolean isExplicitOperator(FunctionDescriptor $this$isExplicitOperator) {
        boolean bl;
        block5: {
            if ($this$isExplicitOperator.getOverriddenDescriptors().isEmpty()) {
                bl = !($this$isExplicitOperator.getContainingDeclaration() instanceof JavaClassDescriptor) && $this$isExplicitOperator.isOperator();
            } else {
                Collection collection = $this$isExplicitOperator.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FunctionDescriptor it = (FunctionDescriptor)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.isExplicitOperator(it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element3) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!ReplaceGetOrSetInspectionUtils.INSTANCE.looksLikeGetOrSetOperatorCall(element3)) {
            return false;
        }
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)element3);
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)callExpression2, BodyResolveMode.PARTIAL_WITH_CFA);
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)callExpression2), (BindingContext)bindingContext2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall3)) {
            return false;
        }
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        FunctionDescriptor functionDescriptor2 = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor target2 = functionDescriptor2;
        if (!ModifierChecksKt.isValidOperator((FunctionDescriptor)target2) || !SetsKt.setOf((Object[])(objectArray = new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET})).contains(target2.getName())) {
            return false;
        }
        if (!UtilsKt.isReceiverExpressionWithValue((KtQualifiedExpression)element3)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)target2.getName(), (Object)OperatorNameConventions.SET) || !BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)element3), (BindingContext)bindingContext2);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("should.be.replaced.with.indexing", new Object[0]);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall((KtQualifiedExpression)element3, BodyResolveMode.PARTIAL);
        CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        FunctionDescriptor functionDescriptor2 = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        return (functionDescriptor2 != null ? this.isExplicitOperator(functionDescriptor2) : false) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.get.or.set.call.with.indexing.operator", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)element3);
        if (ktCallExpression == null) {
            return this.getDefaultFixText();
        }
        KtCallExpression callExpression2 = ktCallExpression;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)callExpression2, null, 1, null);
        if (resolvedCall2 == null) {
            return this.getDefaultFixText();
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)resolvedCall3.getResultingDescriptor().getName().asString(), (String)"asString(...)");
        return KotlinBundle.message("replace.0.call.with.indexing.operator", objectArray);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return ExpressionExtKt.calleeTextRangeInThis(element3);
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ReplaceGetOrSetInspectionUtils.INSTANCE.replaceGetOrSetWithPropertyAccessor(element3, Intrinsics.areEqual((Object)UtilsKt.getCalleeName((KtQualifiedExpression)element3), (Object)OperatorNameConventions.SET.getIdentifier()), editor2);
    }
}

