/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.suppress;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinBaseCodeInsightBundle;
import org.jetbrains.kotlin.idea.inspections.suppress.AnnotationHostKind;
import org.jetbrains.kotlin.idea.inspections.suppress.DeclarationKindDetector;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressIntentionAction;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"createSuppressWarningActions", "", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "element", "Lcom/intellij/psi/PsiElement;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressionKey", "", "kotlin.base.code-insight"})
public final class KotlinSuppressableWarningProblemGroupKt {
    @NotNull
    public static final List<SuppressIntentionAction> createSuppressWarningActions(@NotNull PsiElement element3, @NotNull Severity severity, @NotNull String suppressionKey) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
        if (severity != Severity.WARNING) {
            return CollectionsKt.emptyList();
        }
        ArrayList<KotlinSuppressIntentionAction> actions = new ArrayList<KotlinSuppressIntentionAction>();
        boolean suppressAtStatementAllowed = true;
        for (PsiElement current = element3; current != null; current = current.getParent()) {
            if (current instanceof KtDeclaration && !(current instanceof KtDestructuringDeclaration)) {
                PsiElement declaration2 = current;
                AnnotationHostKind kind2 = DeclarationKindDetector.INSTANCE.detect((KtDeclaration)declaration2);
                if (kind2 != null) {
                    actions.add(new KotlinSuppressIntentionAction((KtElement)declaration2, suppressionKey, kind2));
                }
                suppressAtStatementAllowed = false;
                continue;
            }
            if (current instanceof KtExpression && suppressAtStatementAllowed) {
                if (!(((KtExpression)current).getParent() instanceof KtBlockExpression) && !(((KtExpression)current).getParent() instanceof KtDestructuringDeclaration)) continue;
                String kind3 = ((KtExpression)current).getParent() instanceof KtBlockExpression ? KotlinBaseCodeInsightBundle.message("declaration.kind.statement", new Object[0]) : KotlinBaseCodeInsightBundle.message("declaration.kind.initializer", new Object[0]);
                AnnotationHostKind hostKind = new AnnotationHostKind(kind3, null, true);
                actions.add(new KotlinSuppressIntentionAction((KtElement)current, suppressionKey, hostKind));
                suppressAtStatementAllowed = false;
                continue;
            }
            if (!(current instanceof KtFile)) continue;
            AnnotationHostKind hostKind = new AnnotationHostKind(KotlinBaseCodeInsightBundle.message("declaration.kind.file", new Object[0]), ((KtFile)current).getName(), true);
            actions.add(new KotlinSuppressIntentionAction((KtElement)current, suppressionKey, hostKind));
            suppressAtStatementAllowed = false;
        }
        return actions;
    }
}

