/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightReceiverUsagesHandler;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfo;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfoSearcher;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/HighlightReceiverUsagesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "findReceiverInfo", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "isApplicableTo", "", "startInWriteAction", "kotlin.idea"})
public final class HighlightReceiverUsagesIntention
extends SelfTargetingOffsetIndependentIntention<KtElement>
implements LowPriorityAction {
    public HighlightReceiverUsagesIntention() {
        super(KtElement.class, KotlinBundle.lazyMessage("highlight.usages.of.receiver", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return this.findReceiverInfo(element3) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ReceiverInfo findReceiverInfo(KtElement element3) {
        ReceiverInfo receiverInfo;
        if (element3 instanceof KtReferenceExpression) {
            PsiElement psiElement2 = ((KtReferenceExpression)element3).getFirstChild();
            if (Intrinsics.areEqual((Object)(psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null), (Object)KtTokens.THIS_KEYWORD)) {
                PsiElement psiElement3 = ((KtReferenceExpression)element3).getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                receiverInfo = ReceiverInfoSearcher.INSTANCE.findReceiverInfoForUsageHighlighting(psiElement3);
                return receiverInfo;
            }
        }
        receiverInfo = ReceiverInfoSearcher.INSTANCE.findReceiverInfoForUsageHighlighting((PsiElement)element3);
        return receiverInfo;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtElement element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (editor2 == null) {
            return;
        }
        ApplicationKt.getApplication().executeOnPooledThread(() -> HighlightReceiverUsagesIntention.applyTo$lambda$1(this, element3, editor2));
    }

    private static final Unit applyTo$lambda$1$lambda$0(HighlightReceiverUsagesIntention this$0, KtElement $element, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        ReceiverInfo receiverInfo = this$0.findReceiverInfo($element);
        if (receiverInfo == null) {
            return Unit.INSTANCE;
        }
        ReceiverInfo info2 = receiverInfo;
        new KotlinHighlightReceiverUsagesHandler(info2, $editor, false).highlightUsages();
        return Unit.INSTANCE;
    }

    private static final void applyTo$lambda$1(HighlightReceiverUsagesIntention this$0, KtElement $element, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        ReadAction.computeCancellable(() -> HighlightReceiverUsagesIntention.applyTo$lambda$1$lambda$0(this$0, $element, $editor));
    }
}

