/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.j2k.post.processing.FileBasedPostProcessing;
import org.jetbrains.kotlin.idea.j2k.post.processing.InspectionLikeProcessing;
import org.jetbrains.kotlin.idea.j2k.post.processing.UtilsKt;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002 !B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B'\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0004J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingGroup;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/FileBasedPostProcessing;", "processings", "", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessing;", "([Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessing;)V", "runSingleTime", "", "acceptNonKtElements", "", "(ZZLjava/util/List;)V", "processingsToPriorityMap", "", "", "collectAvailableActions", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingGroup$ProcessingData;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "priority", "processing", "rangeFilter", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingGroup$RangeFilterResult;", "element", "Lcom/intellij/psi/PsiElement;", "runProcessing", "", "allFiles", "converterContext", "ProcessingData", "RangeFilterResult", "kotlin.j2k.post-processing"})
@SourceDebugExtension(value={"SMAP\ninspectionLikePostProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inspectionLikePostProcessing.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1002#2,2:188\n*S KotlinDebug\n*F\n+ 1 inspectionLikePostProcessing.kt\norg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingGroup\n*L\n98#1:188,2\n*E\n"})
public final class InspectionLikeProcessingGroup
extends FileBasedPostProcessing {
    private final boolean runSingleTime;
    private final boolean acceptNonKtElements;
    @NotNull
    private final List<InspectionLikeProcessing> processings;
    @NotNull
    private final Map<InspectionLikeProcessing, Integer> processingsToPriorityMap;

    public InspectionLikeProcessingGroup(boolean runSingleTime, boolean acceptNonKtElements, @NotNull List<? extends InspectionLikeProcessing> processings) {
        Intrinsics.checkNotNullParameter(processings, (String)"processings");
        this.runSingleTime = runSingleTime;
        this.acceptNonKtElements = acceptNonKtElements;
        this.processings = processings;
        this.processingsToPriorityMap = CollectionsKt.mapToIndex((Iterable)this.processings);
    }

    public /* synthetic */ InspectionLikeProcessingGroup(boolean bl, boolean bl2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2, list2);
    }

    public InspectionLikeProcessingGroup(InspectionLikeProcessing ... processings) {
        Intrinsics.checkNotNullParameter((Object)processings, (String)"processings");
        this(false, false, ArraysKt.toList((Object[])processings));
    }

    public final int priority(@NotNull InspectionLikeProcessing processing) {
        Intrinsics.checkNotNullParameter((Object)processing, (String)"processing");
        return ((Number)MapsKt.getValue(this.processingsToPriorityMap, (Object)processing)).intValue();
    }

    @Override
    public void runProcessing(@NotNull KtFile file2, @NotNull List<? extends KtFile> allFiles, @Nullable RangeMarker rangeMarker2, @NotNull NewJ2kConverterContext converterContext) {
        List elementToActions2;
        long l;
        Long l2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)converterContext, (String)"converterContext");
        do {
            Long modificationStamp2 = (Long)ActionsKt.runReadAction((Function0)((Function0)new Function0<Long>(file2){
                final /* synthetic */ KtFile $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final Long invoke() {
                    return this.$file.getModificationStamp();
                }
            }));
            elementToActions2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends ProcessingData>>(this, file2, converterContext, rangeMarker2){
                final /* synthetic */ InspectionLikeProcessingGroup this$0;
                final /* synthetic */ KtFile $file;
                final /* synthetic */ NewJ2kConverterContext $converterContext;
                final /* synthetic */ RangeMarker $rangeMarker;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$converterContext = $converterContext;
                    this.$rangeMarker = $rangeMarker;
                    super(0);
                }

                @NotNull
                public final List<ProcessingData> invoke() {
                    return InspectionLikeProcessingGroup.access$collectAvailableActions(this.this$0, this.$file, this.$converterContext, this.$rangeMarker);
                }
            }));
            for (ProcessingData processingData : elementToActions2) {
                InspectionLikeProcessing processing = processingData.component1();
                PsiElement element3 = processingData.component2();
                boolean needRun2 = (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(element3, processing, converterContext){
                    final /* synthetic */ PsiElement $element;
                    final /* synthetic */ InspectionLikeProcessing $processing;
                    final /* synthetic */ NewJ2kConverterContext $converterContext;
                    {
                        this.$element = $element;
                        this.$processing = $processing;
                        this.$converterContext = $converterContext;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.$element.isValid() && this.$processing.isApplicableToElement(this.$element, this.$converterContext.getConverter().getSettings());
                    }
                }));
                if (needRun2) {
                    UtilsKt.runUndoTransparentActionInEdt(processing.getWriteActionNeeded(), (Function0<Unit>)((Function0)new Function0<Unit>(processing, element3){
                        final /* synthetic */ InspectionLikeProcessing $processing;
                        final /* synthetic */ PsiElement $element;
                        {
                            this.$processing = $processing;
                            this.$element = $element;
                            super(0);
                        }

                        public final void invoke() {
                            this.$processing.applyToElement(this.$element);
                        }
                    }));
                    continue;
                }
                modificationStamp2 = null;
            }
            if (this.runSingleTime) break;
            l2 = modificationStamp2;
            l = ((Number)ActionsKt.runReadAction((Function0)((Function0)new Function0<Long>(file2){
                final /* synthetic */ KtFile $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final Long invoke() {
                    return this.$file.getModificationStamp();
                }
            }))).longValue();
        } while ((l2 == null || l2 != l) && !((Collection)elementToActions2).isEmpty());
    }

    private final List<ProcessingData> collectAvailableActions(KtFile file2, NewJ2kConverterContext context2, RangeMarker rangeMarker2) {
        ArrayList<ProcessingData> availableActions = new ArrayList<ProcessingData>();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, rangeMarker2, context2, availableActions){
            final /* synthetic */ InspectionLikeProcessingGroup this$0;
            final /* synthetic */ RangeMarker $rangeMarker;
            final /* synthetic */ NewJ2kConverterContext $context;
            final /* synthetic */ ArrayList<ProcessingData> $availableActions;
            {
                this.this$0 = $receiver;
                this.$rangeMarker = $rangeMarker;
                this.$context = $context;
                this.$availableActions = $availableActions;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtElement || InspectionLikeProcessingGroup.access$getAcceptNonKtElements$p(this.this$0)) {
                    RangeFilterResult rangeResult = InspectionLikeProcessingGroup.access$rangeFilter(this.this$0, element3, this.$rangeMarker);
                    if (rangeResult == RangeFilterResult.SKIP) {
                        return;
                    }
                    super.visitElement(element3);
                    if (rangeResult == RangeFilterResult.PROCESS) {
                        for (InspectionLikeProcessing processing : InspectionLikeProcessingGroup.access$getProcessings$p(this.this$0)) {
                            if (!processing.isApplicableToElement(element3, this.$context.getConverter().getSettings())) continue;
                            this.$availableActions.add(new ProcessingData(processing, element3, this.this$0.priority(processing)));
                        }
                    }
                }
            }
        });
        List $this$sortBy$iv = availableActions;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            kotlin.collections.CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    ProcessingData it = (ProcessingData)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (ProcessingData)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
        }
        return availableActions;
    }

    private final RangeFilterResult rangeFilter(PsiElement element3, RangeMarker rangeMarker2) {
        if (rangeMarker2 == null) {
            return RangeFilterResult.PROCESS;
        }
        if (!rangeMarker2.isValid()) {
            return RangeFilterResult.SKIP;
        }
        TextRange range2 = new TextRange(rangeMarker2.getStartOffset(), rangeMarker2.getEndOffset());
        TextRange elementRange = element3.getTextRange();
        return range2.contains(elementRange) ? RangeFilterResult.PROCESS : (range2.intersects(elementRange) ? RangeFilterResult.GO_INSIDE : RangeFilterResult.SKIP);
    }

    public static final /* synthetic */ List access$collectAvailableActions(InspectionLikeProcessingGroup $this, KtFile file2, NewJ2kConverterContext context2, RangeMarker rangeMarker2) {
        return $this.collectAvailableActions(file2, context2, rangeMarker2);
    }

    public static final /* synthetic */ boolean access$getAcceptNonKtElements$p(InspectionLikeProcessingGroup $this) {
        return $this.acceptNonKtElements;
    }

    public static final /* synthetic */ RangeFilterResult access$rangeFilter(InspectionLikeProcessingGroup $this, PsiElement element3, RangeMarker rangeMarker2) {
        return $this.rangeFilter(element3, rangeMarker2);
    }

    public static final /* synthetic */ List access$getProcessings$p(InspectionLikeProcessingGroup $this) {
        return $this.processings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingGroup$ProcessingData;", "", "processing", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessing;", "element", "Lcom/intellij/psi/PsiElement;", "priority", "", "(Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessing;Lcom/intellij/psi/PsiElement;I)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getPriority", "()I", "getProcessing", "()Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessing;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin.j2k.post-processing"})
    private static final class ProcessingData {
        @NotNull
        private final InspectionLikeProcessing processing;
        @NotNull
        private final PsiElement element;
        private final int priority;

        public ProcessingData(@NotNull InspectionLikeProcessing processing, @NotNull PsiElement element3, int priority) {
            Intrinsics.checkNotNullParameter((Object)processing, (String)"processing");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            this.processing = processing;
            this.element = element3;
            this.priority = priority;
        }

        @NotNull
        public final InspectionLikeProcessing getProcessing() {
            return this.processing;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        public final int getPriority() {
            return this.priority;
        }

        @NotNull
        public final InspectionLikeProcessing component1() {
            return this.processing;
        }

        @NotNull
        public final PsiElement component2() {
            return this.element;
        }

        public final int component3() {
            return this.priority;
        }

        @NotNull
        public final ProcessingData copy(@NotNull InspectionLikeProcessing processing, @NotNull PsiElement element3, int priority) {
            Intrinsics.checkNotNullParameter((Object)processing, (String)"processing");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            return new ProcessingData(processing, element3, priority);
        }

        public static /* synthetic */ ProcessingData copy$default(ProcessingData processingData, InspectionLikeProcessing inspectionLikeProcessing, PsiElement psiElement2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                inspectionLikeProcessing = processingData.processing;
            }
            if ((n2 & 2) != 0) {
                psiElement2 = processingData.element;
            }
            if ((n2 & 4) != 0) {
                n = processingData.priority;
            }
            return processingData.copy(inspectionLikeProcessing, psiElement2, n);
        }

        @NotNull
        public String toString() {
            return "ProcessingData(processing=" + this.processing + ", element=" + this.element + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            int result2 = this.processing.hashCode();
            result2 = result2 * 31 + this.element.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.priority);
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ProcessingData)) {
                return false;
            }
            ProcessingData processingData = (ProcessingData)other2;
            if (!Intrinsics.areEqual((Object)this.processing, (Object)processingData.processing)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.element, (Object)processingData.element)) {
                return false;
            }
            return this.priority == processingData.priority;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/InspectionLikeProcessingGroup$RangeFilterResult;", "", "(Ljava/lang/String;I)V", "SKIP", "GO_INSIDE", "PROCESS", "kotlin.j2k.post-processing"})
    private static final class RangeFilterResult
    extends Enum<RangeFilterResult> {
        public static final /* enum */ RangeFilterResult SKIP = new RangeFilterResult();
        public static final /* enum */ RangeFilterResult GO_INSIDE = new RangeFilterResult();
        public static final /* enum */ RangeFilterResult PROCESS = new RangeFilterResult();
        private static final /* synthetic */ RangeFilterResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RangeFilterResult[] values() {
            return (RangeFilterResult[])$VALUES.clone();
        }

        public static RangeFilterResult valueOf(String value2) {
            return Enum.valueOf(RangeFilterResult.class, value2);
        }

        @NotNull
        public static EnumEntries<RangeFilterResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rangeFilterResultArray = new RangeFilterResult[]{RangeFilterResult.SKIP, RangeFilterResult.GO_INSIDE, RangeFilterResult.PROCESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

