/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtDeclarationSymbol;
import org.jetbrains.kotlin.idea.k2.refactoring.KotlinK2RefactoringsBundle;
import org.jetbrains.kotlin.idea.k2.refactoring.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a,\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u0002\u00a8\u0006\u000b"}, d2={"checkSuperMethods", "", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "ignore", "", "actionString", "", "canDeleteElement", "", "kotlin.refactorings.k2"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/k2/refactoring/UtilsKt\n+ 2 analyzeUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/AnalyzeUtilsKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,83:1\n25#2,7:84\n77#3:91\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/k2/refactoring/UtilsKt\n*L\n43#1:84,7\n73#1:91\n*E\n"})
public final class UtilsKt {
    public static final boolean canDeleteElement(@Nullable PsiElement $this$canDeleteElement) {
        if ($this$canDeleteElement instanceof KtObjectDeclaration && ((KtObjectDeclaration)$this$canDeleteElement).isObjectLiteral()) {
            return false;
        }
        if ($this$canDeleteElement instanceof KtParameter) {
            PsiElement psiElement2 = ((KtParameter)$this$canDeleteElement).getParent();
            KtParameterList ktParameterList = psiElement2 instanceof KtParameterList ? (KtParameterList)psiElement2 : null;
            if (ktParameterList == null) {
                return false;
            }
            KtParameterList parameterList2 = ktParameterList;
            PsiElement psiElement3 = parameterList2.getParent();
            KtDeclaration ktDeclaration2 = psiElement3 instanceof KtDeclaration ? (KtDeclaration)psiElement3 : null;
            if (ktDeclaration2 == null) {
                return false;
            }
            KtDeclaration declaration2 = ktDeclaration2;
            return !(declaration2 instanceof KtPropertyAccessor);
        }
        return $this$canDeleteElement instanceof KtClassOrObject || $this$canDeleteElement instanceof KtSecondaryConstructor || $this$canDeleteElement instanceof KtNamedFunction || $this$canDeleteElement instanceof KtProperty || $this$canDeleteElement instanceof KtTypeParameter || $this$canDeleteElement instanceof KtTypeAlias;
    }

    @NotNull
    public static final List<PsiElement> checkSuperMethods(@NotNull KtDeclaration declaration2, @NotNull Collection<? extends PsiElement> ignore, @Nls @NotNull String actionString) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        Intrinsics.checkNotNullParameter((Object)actionString, (String)"actionString");
        if (!declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return CollectionsKt.listOf((Object)declaration2);
        }
        Object[] windowTitle$iv = KotlinK2RefactoringsBundle.INSTANCE.message("resolving.super.methods.progress.title", new Object[0]);
        boolean $i$f$analyzeInModalWindow = false;
        ThreadingAssertions.assertEventDispatchThread();
        Project project2 = ((KtElement)declaration2).getProject();
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"org/jetbrains/kotlin/idea/k2/refactoring/UtilsKt$checkSuperMethods$AnalyzedModel", "", "declaredClassRender", "", "overriddenDeclarationsAndRenders", "", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Ljava/util/Map;)V", "getDeclaredClassRender", "()Ljava/lang/String;", "getOverriddenDeclarationsAndRenders", "()Ljava/util/Map;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/util/Map;)Lorg/jetbrains/kotlin/idea/k2/refactoring/UtilsKt$checkSuperMethods$AnalyzedModel;", "equals", "", "other", "hashCode", "", "toString", "kotlin.refactorings.k2"})
        public final class AnalyzedModel {
            @NotNull
            private final String declaredClassRender;
            @NotNull
            private final Map<PsiElement, String> overriddenDeclarationsAndRenders;

            public AnalyzedModel(@NotNull String declaredClassRender, @NotNull Map<PsiElement, String> overriddenDeclarationsAndRenders) {
                Intrinsics.checkNotNullParameter((Object)declaredClassRender, (String)"declaredClassRender");
                Intrinsics.checkNotNullParameter(overriddenDeclarationsAndRenders, (String)"overriddenDeclarationsAndRenders");
                this.declaredClassRender = declaredClassRender;
                this.overriddenDeclarationsAndRenders = overriddenDeclarationsAndRenders;
            }

            @NotNull
            public final String getDeclaredClassRender() {
                return this.declaredClassRender;
            }

            @NotNull
            public final Map<PsiElement, String> getOverriddenDeclarationsAndRenders() {
                return this.overriddenDeclarationsAndRenders;
            }

            @NotNull
            public final String component1() {
                return this.declaredClassRender;
            }

            @NotNull
            public final Map<PsiElement, String> component2() {
                return this.overriddenDeclarationsAndRenders;
            }

            @NotNull
            public final AnalyzedModel copy(@NotNull String declaredClassRender, @NotNull Map<PsiElement, String> overriddenDeclarationsAndRenders) {
                Intrinsics.checkNotNullParameter((Object)declaredClassRender, (String)"declaredClassRender");
                Intrinsics.checkNotNullParameter(overriddenDeclarationsAndRenders, (String)"overriddenDeclarationsAndRenders");
                return new AnalyzedModel(declaredClassRender, overriddenDeclarationsAndRenders);
            }

            public static /* synthetic */ AnalyzedModel copy$default(AnalyzedModel analyzedModel, String string, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = analyzedModel.declaredClassRender;
                }
                if ((n & 2) != 0) {
                    map2 = analyzedModel.overriddenDeclarationsAndRenders;
                }
                return analyzedModel.copy(string, map2);
            }

            @NotNull
            public String toString() {
                return "AnalyzedModel(declaredClassRender=" + this.declaredClassRender + ", overriddenDeclarationsAndRenders=" + this.overriddenDeclarationsAndRenders + ")";
            }

            public int hashCode() {
                int result2 = this.declaredClassRender.hashCode();
                result2 = result2 * 31 + ((Object)this.overriddenDeclarationsAndRenders).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof AnalyzedModel)) {
                    return false;
                }
                AnalyzedModel analyzedModel = (AnalyzedModel)other2;
                if (!Intrinsics.areEqual((Object)this.declaredClassRender, (Object)analyzedModel.declaredClassRender)) {
                    return false;
                }
                return Intrinsics.areEqual(this.overriddenDeclarationsAndRenders, analyzedModel.overriddenDeclarationsAndRenders);
            }
        }
        Task.WithResult<AnalyzedModel, Exception> task$iv = new Task.WithResult<AnalyzedModel, Exception>((String)windowTitle$iv, (KtElement)declaration2, project2, declaration2, ignore){
            final /* synthetic */ KtElement $contextElement;
            final /* synthetic */ KtDeclaration $declaration$inlined;
            final /* synthetic */ Collection $ignore$inlined;
            {
                this.$contextElement = $contextElement;
                this.$declaration$inlined = ktDeclaration2;
                this.$ignore$inlined = collection;
                super($super_call_param$1, $windowTitle, true);
            }

            protected AnalyzedModel compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return ActionsKt.runReadAction((Function0)((Function0)new Function0<AnalyzedModel>(this.$contextElement, this.$declaration$inlined, this.$ignore$inlined){
                    final /* synthetic */ KtElement $contextElement;
                    final /* synthetic */ KtDeclaration $declaration$inlined;
                    final /* synthetic */ Collection $ignore$inlined;
                    {
                        this.$contextElement = $contextElement;
                        this.$declaration$inlined = ktDeclaration2;
                        this.$ignore$inlined = collection;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final AnalyzedModel invoke() {
                        AnalyzedModel analyzedModel;
                        void this_$iv$iv$iv;
                        KtElement useSiteKtElement$iv = this.$contextElement;
                        boolean $i$f$analyze = false;
                        Project project2 = useSiteKtElement$iv.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project2);
                        boolean $i$f$analyse = false;
                        KtAnalysisSessionProvider ktAnalysisSessionProvider = this_$iv$iv;
                        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(useSiteKtElement$iv);
                        boolean $i$f$analyse2 = false;
                        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                        try {
                            AnalyzedModel analyzedModel2;
                            KtAnalysisSession $this$checkSuperMethods_u24lambda_u245 = analysisSession$iv$iv$iv;
                            boolean bl = false;
                            KtDeclarationSymbol ktDeclarationSymbol = $this$checkSuperMethods_u24lambda_u245.getSymbol(this.$declaration$inlined);
                            KtCallableSymbol ktCallableSymbol = ktDeclarationSymbol instanceof KtCallableSymbol ? (KtCallableSymbol)ktDeclarationSymbol : null;
                            if (ktCallableSymbol != null) {
                                KtCallableSymbol callableSymbol = ktCallableSymbol;
                                boolean bl2 = false;
                                KtClassOrObjectSymbol ktClassOrObjectSymbol = $this$checkSuperMethods_u24lambda_u245.getOriginalContainingClassForOverride(callableSymbol);
                                if (ktClassOrObjectSymbol != null) {
                                    void $this$filterTo$iv$iv;
                                    void $this$mapNotNullTo$iv$iv;
                                    KtClassOrObjectSymbol containingClass = ktClassOrObjectSymbol;
                                    boolean bl3 = false;
                                    List<KtCallableSymbol> overriddenSymbols2 = $this$checkSuperMethods_u24lambda_u245.getAllOverriddenSymbols(callableSymbol);
                                    Iterable $this$mapNotNull$iv = overriddenSymbols2;
                                    boolean $i$f$mapNotNull = false;
                                    Iterable iterable = $this$mapNotNull$iv;
                                    Iterable<Pair> destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$mapNotNullTo = false;
                                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                    boolean $i$f$forEach = false;
                                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                                    while (iterator2.hasNext()) {
                                        Pair pair;
                                        T element$iv$iv$iv;
                                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                                        boolean bl4 = false;
                                        KtCallableSymbol it = (KtCallableSymbol)element$iv$iv;
                                        boolean bl5 = false;
                                        if (it.getPsi() != null) {
                                            PsiElement psi2;
                                            boolean bl6 = false;
                                            pair = TuplesKt.to((Object)psi2, (Object)ElementDescriptionUtil.getElementDescription((PsiElement)psi2, (ElementDescriptionLocation)((ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)));
                                        } else {
                                            pair = null;
                                        }
                                        if (pair == null) continue;
                                        Pair it$iv$iv = pair;
                                        boolean bl7 = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    List renderToPsi = (List)destination$iv$iv;
                                    Iterable $this$filter$iv = renderToPsi;
                                    boolean $i$f$filter = false;
                                    destination$iv$iv = $this$filter$iv;
                                    Collection destination$iv$iv2 = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        Pair it = (Pair)element$iv$iv;
                                        boolean bl8 = false;
                                        if (!(!this.$ignore$inlined.contains(it.getFirst()))) continue;
                                        destination$iv$iv2.add(element$iv$iv);
                                    }
                                    List filteredDeclarations = (List)destination$iv$iv2;
                                    Object object = containingClass.getName();
                                    if (object == null || (object = object.asString()) == null) {
                                        object = "<anonymous>";
                                    }
                                    Object object2 = object;
                                    Intrinsics.checkNotNull((Object)object2);
                                    Object renderedClass = object2;
                                    analyzedModel2 = new AnalyzedModel((String)renderedClass, MapsKt.toMap((Iterable)filteredDeclarations));
                                } else {
                                    analyzedModel2 = null;
                                }
                            } else {
                                analyzedModel2 = null;
                            }
                            analyzedModel = analyzedModel2;
                        }
                        finally {
                            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                        }
                        return analyzedModel;
                    }
                }));
            }
        };
        task$iv.queue();
        AnalyzedModel analyzedModel = (AnalyzedModel)task$iv.getResult();
        if (analyzedModel == null) {
            return CollectionsKt.listOf((Object)declaration2);
        }
        AnalyzedModel analyzeResult = analyzedModel;
        if (analyzeResult.getOverriddenDeclarationsAndRenders().isEmpty()) {
            return CollectionsKt.listOf((Object)declaration2);
        }
        windowTitle$iv = new Object[]{analyzeResult.getDeclaredClassRender(), "\n" + CollectionsKt.joinToString$default((Iterable)analyzeResult.getOverriddenDeclarationsAndRenders().values(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), actionString};
        String message2 = KotlinK2RefactoringsBundle.INSTANCE.message("override.declaration.x.overrides.y.in.class.list", windowTitle$iv);
        boolean $i$f$isUnitTestMode = false;
        int exitCode = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)declaration2.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        return switch (exitCode) {
            case 0 -> CollectionsKt.toList((Iterable)analyzeResult.getOverriddenDeclarationsAndRenders().keySet());
            case 1 -> CollectionsKt.listOf((Object)declaration2);
            default -> CollectionsKt.emptyList();
        };
    }
}

