/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.migration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettingsListener;
import org.jetbrains.kotlin.idea.configuration.notifications.MigrationNotificationKt;
import org.jetbrains.kotlin.idea.migration.CodeMigrationToggleAction;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProfileKt;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProjectServiceKt;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;
import org.jetbrains.kotlin.idea.migration.MigrationState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentState", "Lorg/jetbrains/kotlin/idea/migration/MigrationState;", "getProject", "()Lcom/intellij/openapi/project/Project;", "dispose", "", "updateState", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "CommonCompilerSettingsChangeListener", "kotlin.migration"})
@SourceDebugExtension(value={"SMAP\nKotlinMigrationProjectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMigrationProjectService.kt\norg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,71:1\n1#2:72\n77#3:73\n*S KotlinDebug\n*F\n+ 1 KotlinMigrationProjectService.kt\norg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService\n*L\n28#1:73\n*E\n"})
public final class KotlinMigrationProjectService
implements Disposable {
    @NotNull
    private final Project project;
    @Nullable
    private MigrationState currentState;

    public KotlinMigrationProjectService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateState(LanguageVersion languageVersion, ApiVersion apiVersion2) {
        MigrationState migrationState;
        MigrationState newState = languageVersion != null && apiVersion2 != null ? new MigrationState(languageVersion, apiVersion2) : null;
        KotlinMigrationProjectService kotlinMigrationProjectService = this;
        synchronized (kotlinMigrationProjectService) {
            MigrationState migrationState2;
            boolean bl = false;
            MigrationState it = migrationState2 = this.currentState;
            boolean bl2 = false;
            this.currentState = newState;
            migrationState = migrationState2;
        }
        MigrationState oldState = migrationState;
        MigrationInfo migrationInfo = KotlinMigrationProjectServiceKt.access$prepareMigrationInfo(oldState, newState);
        if (migrationInfo == null) {
            return;
        }
        MigrationInfo migrationInfo2 = migrationInfo;
        ReadAction.nonBlocking(() -> KotlinMigrationProjectService.updateState$lambda$2(migrationInfo2)).expireWith((Disposable)this).inSmartMode(this.project).finishOnUiThread(ModalityState.any(), arg_0 -> KotlinMigrationProjectService.updateState$lambda$3((Function1)new Function1<Boolean, Unit>(this, migrationInfo2){
            final /* synthetic */ KotlinMigrationProjectService this$0;
            final /* synthetic */ MigrationInfo $migrationInfo;
            {
                this.this$0 = $receiver;
                this.$migrationInfo = $migrationInfo;
                super(1);
            }

            public final void invoke(Boolean toolExists) {
                Intrinsics.checkNotNull((Object)toolExists);
                if (toolExists.booleanValue()) {
                    MigrationNotificationKt.showMigrationNotification(this.this$0.getProject(), this.$migrationInfo);
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean updateState$lambda$2(MigrationInfo $migrationInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$migrationInfo, (String)"$migrationInfo");
        if (!KotlinMigrationProfileKt.applicableMigrationToolExists($migrationInfo)) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                bl = false;
                return bl;
            }
        }
        bl = true;
        return bl;
    }

    private static final void updateState$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\b\u0010\b\u001a\u0004\u0018\u0001H\u00072\b\u0010\t\u001a\u0004\u0018\u0001H\u0007H\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService$CommonCompilerSettingsChangeListener;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerSettingsListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "settingsChanged", "", "T", "oldSettings", "newSettings", "(Ljava/lang/Object;Ljava/lang/Object;)V", "kotlin.migration"})
    @SourceDebugExtension(value={"SMAP\nKotlinMigrationProjectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMigrationProjectService.kt\norg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService$CommonCompilerSettingsChangeListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n30#2,3:72\n1#3:75\n*S KotlinDebug\n*F\n+ 1 KotlinMigrationProjectService.kt\norg/jetbrains/kotlin/idea/migration/KotlinMigrationProjectService$CommonCompilerSettingsChangeListener\n*L\n45#1:72,3\n*E\n"})
    public static final class CommonCompilerSettingsChangeListener
    implements KotlinCompilerSettingsListener {
        @NotNull
        private final Project project;

        public CommonCompilerSettingsChangeListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        @Override
        public <T> void settingsChanged(@Nullable T oldSettings, @Nullable T newSettings) {
            ApiVersion apiVersion2;
            LanguageVersion languageVersion;
            String it;
            KotlinMigrationProjectService kotlinMigrationProjectService;
            CommonCompilerArguments.DummyImpl dummyImpl = newSettings instanceof CommonCompilerArguments.DummyImpl ? (CommonCompilerArguments.DummyImpl)newSettings : null;
            if (dummyImpl == null) {
                return;
            }
            CommonCompilerArguments.DummyImpl newCommonSettings = dummyImpl;
            if (!CodeMigrationToggleAction.Manager.INSTANCE.isEnabled(this.project)) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<KotlinMigrationProjectService> serviceClass$iv = KotlinMigrationProjectService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            KotlinMigrationProjectService kotlinMigrationProjectService2 = (KotlinMigrationProjectService)object;
            String string = newCommonSettings.getLanguageVersion();
            if (string != null) {
                serviceClass$iv = string;
                kotlinMigrationProjectService = kotlinMigrationProjectService2;
                boolean bl = false;
                languageVersion = LanguageVersion.Companion.fromVersionString(it);
                kotlinMigrationProjectService2 = kotlinMigrationProjectService;
            } else {
                languageVersion = null;
            }
            String string2 = newCommonSettings.getApiVersion();
            if (string2 != null) {
                it = string2;
                LanguageVersion languageVersion2 = languageVersion;
                kotlinMigrationProjectService = kotlinMigrationProjectService2;
                boolean bl = false;
                ApiVersion apiVersion3 = ApiVersion.Companion.parse(it);
                kotlinMigrationProjectService2 = kotlinMigrationProjectService;
                languageVersion = languageVersion2;
                apiVersion2 = apiVersion3;
            } else {
                apiVersion2 = null;
            }
            kotlinMigrationProjectService2.updateState(languageVersion, apiVersion2);
        }
    }
}

