/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AddStarProjectionsFixKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "element", "argumentCount", "", "(Lorg/jetbrains/kotlin/psi/KtUserType;I)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddStarProjectionsFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddStarProjectionsFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,106:1\n19#2:107\n*S KotlinDebug\n*F\n+ 1 AddStarProjectionsFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix\n*L\n56#1:107\n*E\n"})
public final class AddStarProjectionsFix
extends KotlinQuickFixAction<KtUserType> {
    private final int argumentCount;

    public AddStarProjectionsFix(@NotNull KtUserType element3, int argumentCount) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.argumentCount = argumentCount;
    }

    @NotNull
    public String getFamilyName() {
        return AddStarProjectionsFixKt.access$getStarProjectionFixFamilyName$p();
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)TypeReconstructionUtil.getTypeNameAndStarProjectionsString((String)"", (int)this.argumentCount), (String)"getTypeNameAndStarProjectionsString(...)");
        return KotlinBundle.message("fix.add.star.projection.text", objectArray);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtUserType ktUserType2 = (KtUserType)this.getElement();
        if (ktUserType2 == null) {
            return;
        }
        KtUserType element3 = ktUserType2;
        boolean bl = element3.getTypeArguments().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = TypeReconstructionUtil.getTypeNameAndStarProjectionsString((String)element3.getText(), (int)this.argumentCount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeNameAndStarProjectionsString(...)");
        String typeString = string;
        KtTypeElement $this$sure$iv = new KtPsiFactory(project2, false, 2, null).createType(typeString).getTypeElement();
        boolean $i$f$sure = false;
        KtTypeElement ktTypeElement = $this$sure$iv;
        if (ktTypeElement == null) {
            boolean bl2 = false;
            String string2 = "No type element after parsing " + typeString;
            throw new AssertionError((Object)string2);
        }
        KtTypeElement replacement2 = ktTypeElement;
        element3.replace((PsiElement)replacement2);
    }
}

