/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "type", "", "(Lorg/jetbrains/kotlin/psi/KtProperty;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class ChangeToMutableCollectionFix
extends KotlinQuickFixAction<KtProperty> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private static final String COLLECTIONS = "kotlin.collections";
    @NotNull
    private static final Map<String, String> mutableConversionMap;

    public ChangeToMutableCollectionFix(@NotNull KtProperty property2, @NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)property2);
        this.type = type2;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{"Mutable" + this.type};
        return KotlinBundle.message("fix.change.to.mutable.type", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtProperty ktProperty = (KtProperty)this.getElement();
            if (ktProperty == null) {
                return;
            }
            KtProperty property2 = ktProperty;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)property2, BodyResolveMode.PARTIAL);
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2)) == null) {
                return;
            }
            KtExpression type2 = ktExpression;
            Companion.applyFix(property2, (KotlinType)type2);
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block2;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)property2)));
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kotlin.collections.listOf", (Object)"mutableListOf"), TuplesKt.to((Object)"kotlin.collections.setOf", (Object)"mutableSetOf"), TuplesKt.to((Object)"kotlin.collections.mapOf", (Object)"mutableMapOf")};
        mutableConversionMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "COLLECTIONS", "", "mutableConversionMap", "", "applyFix", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isApplicable", "", "isReadOnlyListOrMap", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeToMutableCollectionFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeToMutableCollectionFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$Companion\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n24#2,7:94\n24#2,7:101\n1#3:108\n*S KotlinDebug\n*F\n+ 1 ChangeToMutableCollectionFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeToMutableCollectionFix$Companion\n*L\n65#1:94,7\n74#1:101,7\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = ((SimpleDiagnostic)Errors.NO_SET_METHOD.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            KtArrayAccessExpression ktArrayAccessExpression = psiElement2 instanceof KtArrayAccessExpression ? (KtArrayAccessExpression)psiElement2 : null;
            if (ktArrayAccessExpression == null) {
                return null;
            }
            KtArrayAccessExpression element3 = ktArrayAccessExpression;
            KtExpression ktExpression = element3.getArrayExpression();
            if (ktExpression == null) {
                return null;
            }
            KtExpression arrayExpr = ktExpression;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)arrayExpr, BodyResolveMode.PARTIAL);
            KotlinType kotlinType = CallUtilKt.getType((KtExpression)arrayExpr, (BindingContext)context2);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            if (!this.isReadOnlyListOrMap(type2, PlatformKt.getBuiltIns((KtElement)element3))) {
                return null;
            }
            KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)arrayExpr));
            PsiElement psiElement3 = ktReference != null ? ktReference.resolve() : null;
            KtProperty ktProperty = psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            if (!this.isApplicable(property2)) {
                return null;
            }
            Object object = type2.getConstructor().getDeclarationDescriptor();
            if (object == null || (object = object.getName()) == null || (object = object.asString()) == null) {
                return null;
            }
            Object typeName = object;
            return new ChangeToMutableCollectionFix(property2, (String)typeName);
        }

        private final boolean isReadOnlyListOrMap(KotlinType $this$isReadOnlyListOrMap, KotlinBuiltIns builtIns) {
            ClassifierDescriptor classifierDescriptor = $this$isReadOnlyListOrMap.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null || (classifierDescriptor = classifierDescriptor.getDefaultType()) == null) {
                return false;
            }
            ClassifierDescriptor leftDefaultType = classifierDescriptor;
            Object[] objectArray = new SimpleType[]{builtIns.getList().getDefaultType(), builtIns.getMap().getDefaultType()};
            return CollectionsKt.listOf((Object[])objectArray).contains(leftDefaultType);
        }

        public final boolean isApplicable(@NotNull KtProperty property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            return property2.isLocal() && property2.getInitializer() != null;
        }

        /*
         * WARNING - void declaration
         */
        public final void applyFix(@NotNull KtProperty property2, @NotNull KotlinType type2) {
            block18: {
                KtTypeReference ktTypeReference;
                KtPsiFactory psiFactory;
                block17: {
                    PsiElement psiElement2;
                    void newElement$iv;
                    void $this$replaced$iv;
                    KtExpression initializer2;
                    block15: {
                        block16: {
                            PsiElement psiElement3;
                            void $this$replaced$iv2;
                            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                            KtExpression ktExpression = property2.getInitializer();
                            if (ktExpression == null) {
                                return;
                            }
                            initializer2 = ktExpression;
                            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)initializer2, null, 1, null);
                            String fqName2 = resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null && (resolvedCall2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2))) != null ? resolvedCall2.asString() : null;
                            Project project2 = property2.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                            psiFactory = new KtPsiFactory(project2, false, 2, null);
                            String mutableOf = (String)mutableConversionMap.get(fqName2);
                            if (mutableOf == null) break block15;
                            KtCallExpression ktCallExpression = initializer2 instanceof KtCallExpression ? (KtCallExpression)initializer2 : null;
                            if (ktCallExpression == null || (ktCallExpression = ktCallExpression.getCalleeExpression()) == null) break block16;
                            PsiElement psiElement4 = (PsiElement)ktCallExpression;
                            PsiElement newElement$iv2 = (PsiElement)psiFactory.createExpression(mutableOf);
                            boolean $i$f$replaced = false;
                            if (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)newElement$iv2)) {
                                psiElement3 = newElement$iv2;
                            } else {
                                PsiElement result$iv = $this$replaced$iv2.replace(newElement$iv2);
                                if (result$iv instanceof KtExpression) {
                                    psiElement3 = result$iv;
                                } else {
                                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                    KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                                    if (ktExpression2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                    }
                                    psiElement3 = (PsiElement)ktExpression2;
                                }
                            }
                            if ((ktCallExpression = (KtExpression)psiElement3) != null) break block17;
                        }
                        return;
                    }
                    KotlinBuiltIns builtIns = PlatformKt.getBuiltIns((KtElement)property2);
                    TypeConstructor $this$replaced$iv2 = type2.getConstructor();
                    String string = Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)builtIns.getList().getDefaultType().getConstructor()) ? "toMutableList" : (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)builtIns.getSet().getDefaultType().getConstructor()) ? "toMutableSet" : (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)builtIns.getMap().getDefaultType().getConstructor()) ? "toMutableMap" : null));
                    if (string == null) {
                        return;
                    }
                    String toMutable2 = string;
                    PsiElement newElement$iv2 = (PsiElement)initializer2;
                    Object[] $i$f$replaced = new Object[]{initializer2, toMutable2};
                    $i$f$replaced = (Object[])CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"($0).$1()", (Object[])$i$f$replaced, (boolean)false, (int)4, null);
                    boolean $i$f$replaced2 = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement2 = newElement$iv;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newElement$iv);
                        if (result$iv instanceof KtExpression) {
                            psiElement2 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement2 = (PsiElement)ktExpression;
                        }
                    }
                    Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
                    KtDotQualifiedExpression dotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
                    KtExpression receiver2 = dotQualifiedExpression.getReceiverExpression();
                    KtExpression deparenthesize = KtPsiUtil.deparenthesize((KtExpression)dotQualifiedExpression.getReceiverExpression());
                    if (deparenthesize != null && !Intrinsics.areEqual((Object)receiver2, (Object)deparenthesize)) {
                        receiver2.replace((PsiElement)deparenthesize);
                    }
                }
                KtTypeReference ktTypeReference2 = property2.getTypeReference();
                if (ktTypeReference2 == null) break block18;
                KtTypeReference it = ktTypeReference = ktTypeReference2;
                boolean bl = false;
                it.replace((PsiElement)psiFactory.createType("Mutable" + it.getText()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

