/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertToIsArrayOfCallFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "element", "lhsType", "Lorg/jetbrains/kotlin/types/KotlinType;", "arrayArgumentType", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)V", "arrayArgumentTypeText", "", "lhsIsArray", "", "lhsIsNullable", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertToIsArrayOfCallFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToIsArrayOfCallFix.kt\norg/jetbrains/kotlin/idea/quickfix/ConvertToIsArrayOfCallFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,70:1\n24#2,7:71\n*S KotlinDebug\n*F\n+ 1 ConvertToIsArrayOfCallFix.kt\norg/jetbrains/kotlin/idea/quickfix/ConvertToIsArrayOfCallFix\n*L\n52#1:71,7\n*E\n"})
public final class ConvertToIsArrayOfCallFix
extends KotlinQuickFixAction<KtIsExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean lhsIsNullable;
    private final boolean lhsIsArray;
    @NotNull
    private final String arrayArgumentTypeText;

    public ConvertToIsArrayOfCallFix(@NotNull KtIsExpression element3, @NotNull KotlinType lhsType, @NotNull KotlinType arrayArgumentType) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
        Intrinsics.checkNotNullParameter((Object)arrayArgumentType, (String)"arrayArgumentType");
        super((PsiElement)element3);
        this.lhsIsNullable = KotlinTypeKt.isNullable((KotlinType)lhsType);
        this.lhsIsArray = SimpleClassicTypeSystemContext.INSTANCE.isArrayOrNullableArray((KotlinTypeMarker)lhsType);
        this.arrayArgumentTypeText = IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(arrayArgumentType);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.convert.to.is.array.of.call", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        PsiElement psiElement2;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtIsExpression ktIsExpression = (KtIsExpression)this.getElement();
        if (ktIsExpression == null) {
            return;
        }
        KtIsExpression isExpression = ktIsExpression;
        boolean isNegated = isExpression.isNegated();
        String isArrayOfCall = "isArrayOf<" + this.arrayArgumentTypeText + ">()";
        String newPattern = this.lhsIsArray && !this.lhsIsNullable ? (isNegated ? "!$0." + isArrayOfCall : "$0." + isArrayOfCall) : (this.lhsIsArray && this.lhsIsNullable ? (isNegated ? "$0?." + isArrayOfCall + " != true" : "$0?." + isArrayOfCall + " == true") : (isNegated ? "!($0 is Array<*> && $0." + isArrayOfCall + ")" : "$0 is Array<*> && $0." + isArrayOfCall));
        PsiElement psiElement3 = (PsiElement)isExpression;
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, 2, null);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)isExpression.getLeftHandSide(), (String)"getLeftHandSide(...)");
        PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)newPattern, (Object[])objectArray, (boolean)false, (int)4, null);
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement2 = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                psiElement2 = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression;
            }
        }
        KtExpression replaced2 = (KtExpression)psiElement2;
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)replaced2, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertToIsArrayOfCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 casted = (DiagnosticWithParameters1)Errors.CANNOT_CHECK_FOR_ERASED.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement2 = casted.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"<get-psiElement>(...)");
            KtElement element3 = (KtElement)psiElement2;
            if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform(element3))) {
                return null;
            }
            PsiElement psiElement3 = element3.getParent();
            KtIsExpression ktIsExpression = psiElement3 instanceof KtIsExpression ? (KtIsExpression)psiElement3 : null;
            if (ktIsExpression == null) {
                return null;
            }
            KtIsExpression parentIsExpression = ktIsExpression;
            Object object = casted.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
            KotlinType type2 = (KotlinType)object;
            if (!SimpleClassicTypeSystemContext.INSTANCE.isArrayOrNullableArray((KotlinTypeMarker)type2)) {
                return null;
            }
            TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)type2.getArguments());
            if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
                return null;
            }
            TypeProjection arrayArgumentType = typeProjection;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)parentIsExpression, BodyResolveMode.PARTIAL);
            KtExpression ktExpression = parentIsExpression.getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"getLeftHandSide(...)");
            KotlinType kotlinType = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2);
            if (kotlinType == null) {
                return null;
            }
            KotlinType lhsType = kotlinType;
            return new ConvertToIsArrayOfCallFix(parentIsExpression, lhsType, (KotlinType)arrayArgumentType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

