/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.OptInFixesUtils;
import org.jetbrains.kotlin.idea.quickfix.OptInGeneralUtils;
import org.jetbrains.kotlin.idea.quickfix.OptInGeneralUtilsBase;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004*\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\t*\u00020\fH\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\t*\u00020\nH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "collectScriptCandidates", "Lorg/jetbrains/kotlin/idea/quickfix/OptInGeneralUtilsBase$CandidateData;", "Lorg/jetbrains/kotlin/psi/KtElement;", "findSamConstructorCallCandidate", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "findStatementCandidate", "isLambda", "", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nOptInFixesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInFixesFactory.kt\norg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n53#2:162\n22#2,12:163\n53#2:177\n22#2,12:178\n1855#3,2:175\n1045#3:190\n1747#3,3:191\n*S KotlinDebug\n*F\n+ 1 OptInFixesFactory.kt\norg/jetbrains/kotlin/idea/quickfix/OptInFixesFactory\n*L\n45#1:162\n45#1:163,12\n94#1:177\n94#1:178,12\n77#1:175,2\n113#1:190\n90#1:191,3\n*E\n"})
public final class OptInFixesFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final OptInFixesFactory INSTANCE = new OptInFixesFactory();

    private OptInFixesFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Object v1;
        Object v0;
        block8: {
            void $this$findParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            boolean strict$iv = false;
            boolean $i$f$findParentOfType = false;
            void var7_7 = $this$findParentOfType$iv;
            boolean withSelf$iv$iv = true;
            boolean $i$f$findParentInFile = false;
            for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv; current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                void it$iv = current$iv$iv;
                boolean bl = false;
                if (it$iv instanceof KtElement) {
                    v0 = current$iv$iv;
                    break block8;
                }
                if (current$iv$iv instanceof PsiFile) break;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof KtElement)) {
            v1 = null;
        }
        KtElement ktElement = (KtElement)((PsiElement)((KtElement)v1));
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement element3 = ktElement;
        FqName fqName2 = OptInFixesUtils.INSTANCE.annotationFqName(diagnostic);
        if (fqName2 == null) {
            return CollectionsKt.emptyList();
        }
        FqName annotationFqName = fqName2;
        ModuleDescriptor moduleDescriptor = ResolutionUtils.getResolutionFacade(element3).getModuleDescriptor();
        ClassDescriptor classDescriptor = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)moduleDescriptor, (FqName)annotationFqName, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor annotationClassDescriptor = classDescriptor;
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)annotationClassDescriptor));
        if (classId == null) {
            return CollectionsKt.emptyList();
        }
        ClassId annotationClassId = classId;
        Set applicableTargets = AnnotationChecker.Companion.applicableTargetSet(annotationClassDescriptor);
        BindingContext context2 = ResolutionUtils.analyze$default(element3, null, 1, null);
        boolean isOverrideError = Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_OVERRIDE_ERROR) || Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.OPT_IN_OVERRIDE);
        ClassId optInClassId = ClassId.Companion.topLevel(OptInFixesUtils.INSTANCE.optInFqName(moduleDescriptor));
        List result2 = new ArrayList();
        PsiFile psiFile2 = element3.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        List<OptInGeneralUtilsBase.CandidateData> candidates2 = DefinitionsKt.isScript(psiFile2) ? this.collectScriptCandidates(element3) : OptInGeneralUtils.INSTANCE.collectCandidates((PsiElement)element3);
        Iterable $this$forEach$iv = candidates2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OptInGeneralUtilsBase.CandidateData candidateData = (OptInGeneralUtilsBase.CandidateData)element$iv;
            boolean bl = false;
            KtElement targetElement = candidateData.component1();
            AddAnnotationFix.Kind kind2 = candidateData.component2();
            UtilKt.addIfNotNull((List)result2, OptInFixesFactory.doCreateActions$collectPropagateOptInAnnotationFix(context2, applicableTargets, annotationFqName, annotationClassId, isOverrideError, targetElement, kind2));
            result2.add(OptInGeneralUtils.INSTANCE.collectUseOptInAnnotationFix(targetElement, kind2, optInClassId, annotationFqName, isOverrideError));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OptInGeneralUtilsBase.CandidateData> collectScriptCandidates(KtElement $this$collectScriptCandidates) {
        Object v1;
        Object v0;
        PsiElement current;
        List result2;
        block12: {
            void $this$findParentOfType$iv;
            result2 = new ArrayList();
            current = (PsiElement)$this$collectScriptCandidates;
            PsiElement psiElement2 = (PsiElement)$this$collectScriptCandidates;
            boolean strict$iv = false;
            boolean $i$f$findParentOfType = false;
            void var8_7 = $this$findParentOfType$iv;
            boolean withSelf$iv$iv = true;
            boolean $i$f$findParentInFile = false;
            for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv; current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                void it$iv = current$iv$iv;
                boolean bl = false;
                if (it$iv instanceof KtDeclaration) {
                    v0 = current$iv$iv;
                    break block12;
                }
                if (current$iv$iv instanceof PsiFile) break;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof KtDeclaration)) {
            v1 = null;
        }
        KtDeclaration closestDeclaration = (KtDeclaration)((PsiElement)((KtDeclaration)v1));
        while (current != null) {
            if (current instanceof KtClassOrObject && !Intrinsics.areEqual((Object)closestDeclaration, (Object)current)) {
                OptInGeneralUtilsBase.CandidateData candidateData = OptInGeneralUtils.INSTANCE.findContainingClassOrObjectCandidate((KtDeclaration)current);
                if (candidateData != null) {
                    OptInFixesFactory.collectScriptCandidates$addToResult(candidateData, result2);
                }
            } else if (current instanceof KtCallExpression) {
                OptInGeneralUtilsBase.CandidateData candidateData = this.findSamConstructorCallCandidate((KtCallExpression)current);
                if (candidateData != null) {
                    OptInFixesFactory.collectScriptCandidates$addToResult(candidateData, result2);
                }
            } else if (current instanceof KtDeclaration && (current instanceof KtDeclarationWithBody && !this.isLambda((KtDeclarationWithBody)current) || current instanceof KtTypeAlias || current instanceof KtProperty || current instanceof KtClassOrObject)) {
                OptInFixesFactory.collectScriptCandidates$addToResult(OptInGeneralUtils.INSTANCE.findContainingDeclarationCandidate((KtDeclaration)current), result2);
            }
            current = current.getParent();
        }
        OptInGeneralUtilsBase.CandidateData candidateData = this.findStatementCandidate($this$collectScriptCandidates);
        if (candidateData != null) {
            OptInFixesFactory.collectScriptCandidates$addToResult(candidateData, result2);
        }
        Iterable $this$sortedBy$iv = result2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b2) {
                OptInGeneralUtilsBase.CandidateData it = (OptInGeneralUtilsBase.CandidateData)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it.getKind(), (Object)AddAnnotationFix.Kind.Self.INSTANCE));
                it = (OptInGeneralUtilsBase.CandidateData)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)it.getKind(), (Object)AddAnnotationFix.Kind.Self.INSTANCE)));
            }
        });
    }

    private final boolean isLambda(KtDeclarationWithBody $this$isLambda) {
        DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)$this$isLambda);
        return Intrinsics.areEqual((Object)(declarationDescriptor != null && (declarationDescriptor = declarationDescriptor.getName()) != null ? declarationDescriptor.asString() : null), (Object)"<anonymous>");
    }

    private final OptInGeneralUtilsBase.CandidateData findStatementCandidate(KtElement $this$findStatementCandidate) {
        PsiFile psiFile2 = $this$findStatementCandidate.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        if (!DefinitionsKt.isScript(psiFile2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KtElement statementElement = $this$findStatementCandidate;
        while (!(statementElement.getParent() instanceof KtBlockExpression) && !(statementElement.getParent() instanceof KtClassBody)) {
            PsiElement psiElement2 = statementElement.getParent();
            if ((psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null) == null) {
                return null;
            }
            statementElement = statementElement;
        }
        return new OptInGeneralUtilsBase.CandidateData(statementElement, AddAnnotationFix.Kind.Self.INSTANCE);
    }

    private final OptInGeneralUtilsBase.CandidateData findSamConstructorCallCandidate(KtCallExpression $this$findSamConstructorCallCandidate) {
        PsiElement parent2 = $this$findSamConstructorCallCandidate.getParent();
        if (!(parent2 instanceof KtBlockExpression || parent2 instanceof KtScriptInitializer || parent2 instanceof KtAnnotatedExpression)) {
            return null;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)$this$findSamConstructorCallCandidate, null, 1, null);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        if (!(resolvedCall3.getResultingDescriptor() instanceof SamConstructorDescriptor)) {
            return null;
        }
        PsiElement element3 = parent2 instanceof KtScriptInitializer ? parent2 : (parent2 instanceof KtAnnotatedExpression && ((KtAnnotatedExpression)parent2).getParent() instanceof KtScriptInitializer ? ((KtAnnotatedExpression)parent2).getParent() : (PsiElement)$this$findSamConstructorCallCandidate);
        String string = resolvedCall3.getResultingDescriptor().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String name2 = string;
        Intrinsics.checkNotNull((Object)element3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        return new OptInGeneralUtilsBase.CandidateData((KtElement)element3, new AddAnnotationFix.Kind.Declaration(name2));
    }

    private static final KotlinQuickFixAction<KtElement> doCreateActions$collectPropagateOptInAnnotationFix(BindingContext context2, Set<? extends KotlinTarget> applicableTargets, FqName annotationFqName, ClassId annotationClassId, boolean isOverrideError, KtElement targetElement, AddAnnotationFix.Kind kind2) {
        if (!(targetElement instanceof KtDeclaration)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)targetElement);
        ClassDescriptor elementDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        List actualTargetList = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(targetElement, elementDescriptor, context2);
        return OptInGeneralUtils.INSTANCE.collectPropagateOptInAnnotationFix((KtDeclaration)targetElement, kind2, applicableTargets, actualTargetList, annotationFqName, annotationClassId, isOverrideError);
    }

    private static final void collectScriptCandidates$addToResult(OptInGeneralUtilsBase.CandidateData $this$collectScriptCandidates_u24addToResult, List<OptInGeneralUtilsBase.CandidateData> result2) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = result2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OptInGeneralUtilsBase.CandidateData it = (OptInGeneralUtilsBase.CandidateData)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)$this$collectScriptCandidates_u24addToResult.getElement(), (Object)it.getElement())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        result2.add($this$collectScriptCandidates_u24addToResult);
    }
}

