/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.AddFullQualifierIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureProcessor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptorKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfoKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallableParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallerChooser;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinFunctionParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinPrimaryConstructorParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinSecondaryConstructorParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.introduce.ui.KotlinSignatureComponent;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 A2,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001:\u0001AB3\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0016\u001a\u00020\u000fH\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J2\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00030 0\u001fH\u0014J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0005H\u0014J6\u0010#\u001a00$R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001H\u0014J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020*H\u0014J\u0016\u0010+\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010\u00040\u00040,H\u0014J$\u0010.\u001a\u00020/2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000f01H\u0002J\b\u00102\u001a\u00020/H\u0002J\b\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u00020\u0005H\u0002J\b\u00106\u001a\u00020\u000fH\u0014J\b\u00107\u001a\u00020/H\u0002J\u0016\u00108\u001a\u00020\u000f2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002J\b\u0010:\u001a\u00020/H\u0014J\b\u0010;\u001a\u00020/H\u0002J\b\u0010<\u001a\u00020=H\u0014J\b\u0010>\u001a\u00020=H\u0014J\b\u0010?\u001a\u00020\u0018H\u0014J\n\u0010@\u001a\u0004\u0018\u00010\u000fH\u0014R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureDialogBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelItemBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "methodDescriptor", "context", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "parametersTableModel", "getParametersTableModel", "()Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "calculateSignature", "canRun", "", "createCallerChooser", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallerChooser;", "title", "treeToReuse", "Lcom/intellij/ui/treeStructure/Tree;", "callback", "Lcom/intellij/util/Consumer;", "", "createParametersInfoModel", "descriptor", "createParametersListTable", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$ParametersListTable;", "createRefactoringProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "createReturnTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "createSignaturePreviewComponent", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/ui/KotlinSignatureComponent;", "createVisibilityControl", "Lcom/intellij/refactoring/ui/ComboBoxVisibilityPanel;", "kotlin.jvm.PlatformType", "getColumnTextMaxLength", "", "nameFunction", "Lkotlin/Function1;", "getDefaultValuesMaxLength", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "getMethodDescriptor", "getMethodName", "getParamNamesMaxLength", "getPresentationName", "item", "getSelectedIdx", "getTypesMaxLength", "isListTableViewSupported", "", "mayPropagateParameters", "updateSignatureAlarmFired", "validateAndCommitData", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinChangeSignatureDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChangeSignatureDialog.kt\norg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 renameUtil.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameUtilKt\n*L\n1#1,533:1\n1#2:534\n1747#3,3:535\n288#3,2:538\n10#4,2:540\n*S KotlinDebug\n*F\n+ 1 KotlinChangeSignatureDialog.kt\norg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog\n*L\n306#1:535,3\n408#1:538,2\n412#1:540,2\n*E\n"})
public final class KotlinChangeSignatureDialog
extends ChangeSignatureDialogBase<KotlinParameterInfo, PsiElement, DescriptorVisibility, KotlinMethodDescriptor, ParameterTableModelItemBase<KotlinParameterInfo>, KotlinCallableParameterTableModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Editor editor;
    @Nullable
    private final String commandName;

    public KotlinChangeSignatureDialog(@NotNull Project project2, @Nullable Editor editor2, @NotNull KotlinMethodDescriptor methodDescriptor, @NotNull PsiElement context2, @NlsContexts.Command @Nullable String commandName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(project2, (MethodDescriptor)methodDescriptor, false, context2);
        this.editor = editor2;
        this.commandName = commandName;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    protected KotlinFileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        return kotlinFileType;
    }

    @NotNull
    protected KotlinCallableParameterTableModel createParametersInfoModel(@NotNull KotlinMethodDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myDefaultValueContext");
        return KotlinChangeSignatureDialog.Companion.createParametersInfoModel(descriptor2, psiElement2);
    }

    @NotNull
    protected KtTypeCodeFragment createReturnTypeCodeFragment() {
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"myMethod");
        return KotlinChangeSignatureDialog.Companion.createReturnTypeCodeFragment(project2, (KotlinMethodDescriptor)methodDescriptor);
    }

    private final KotlinCallableParameterTableModel getParametersTableModel() {
        ParameterTableModelBase parameterTableModelBase = this.myParametersTableModel;
        Intrinsics.checkNotNullExpressionValue((Object)parameterTableModelBase, (String)"myParametersTableModel");
        return (KotlinCallableParameterTableModel)parameterTableModelBase;
    }

    @NotNull
    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        return new ChangeSignatureDialogBase.ParametersListTable(this){
            @NotNull
            private final createParametersListTable.rowRenderer.1 rowRenderer;
            final /* synthetic */ KotlinChangeSignatureDialog this$0;
            {
                this.this$0 = $receiver;
                super((ChangeSignatureDialogBase)$receiver);
                Project project2 = KotlinChangeSignatureDialog.access$getProject($receiver);
                KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
                Disposable disposable = $receiver.getDisposable();
                this.rowRenderer = new EditorTextFieldJBTableRowRenderer(this, $receiver, project2, kotlinLanguage, disposable){
                    final /* synthetic */ createParametersListTable.1 this$0;
                    final /* synthetic */ KotlinChangeSignatureDialog this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super($super_call_param$1, (Language)$super_call_param$2, $super_call_param$3);
                    }

                    @NotNull
                    protected String getText(@Nullable JTable table, int row) {
                        String string;
                        String string2;
                        ParameterTableModelItemBase item;
                        block8: {
                            block7: {
                                item = createParametersListTable.1.access$getRowItem(this.this$0, row);
                                if (((KotlinMethodDescriptor)KotlinChangeSignatureDialog.access$getMyMethod$p$s-860463185(this.this$1)).getKind() != KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR) break block7;
                                switch (createParametersListTable.rowRenderer.WhenMappings.$EnumSwitchMapping$0[((KotlinParameterInfo)item.parameter).getValOrVar().ordinal()]) {
                                    case 1: {
                                        string2 = "    ";
                                        break block8;
                                    }
                                    case 2: {
                                        string2 = "val ";
                                        break block8;
                                    }
                                    case 3: {
                                        string2 = "var ";
                                        break block8;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                            }
                            string2 = "";
                        }
                        String valOrVar = string2;
                        Intrinsics.checkNotNull((Object)item);
                        String parameterName2 = KotlinChangeSignatureDialog.access$getPresentationName(this.this$1, item);
                        String typeText = item.typeCodeFragment.getText();
                        String defaultValue = org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$Companion.access$isReceiverIn(KotlinChangeSignatureDialog.Companion, item, KotlinChangeSignatureDialog.access$getParametersTableModel(this.this$1)) || !((KotlinParameterInfo)item.parameter).getDefaultValueAsDefaultParameter() ? item.defaultValueCodeFragment.getText() : "";
                        String string3 = StringUtil.repeatSymbol((char)' ', (int)(KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$1) - parameterName2.length() + 1));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"repeatSymbol(...)");
                        String separator = string3;
                        if (StringUtil.isNotEmpty((String)defaultValue)) {
                            Object[] objectArray = new Object[1];
                            Intrinsics.checkNotNull((Object)defaultValue);
                            objectArray[0] = defaultValue;
                            string = KotlinBundle.message("text.default.value", objectArray);
                        } else {
                            string = "";
                        }
                        String text2 = valOrVar + parameterName2 + ":" + separator + typeText + string;
                        return " " + text2;
                    }
                };
            }

            @NotNull
            protected JBTableRowRenderer getRowRenderer(int row) {
                return (JBTableRowRenderer)this.rowRenderer;
            }

            @NotNull
            protected JBTableRowEditor getRowEditor(@NotNull ParameterTableModelItemBase<KotlinParameterInfo> item) {
                Intrinsics.checkNotNullParameter(item, (String)"item");
                return new JBTableRowEditor(item, this.this$0){
                    @NotNull
                    private final ArrayList<JComponent> components;
                    @NotNull
                    private final EditorTextField nameEditor;
                    @NotNull
                    private final JCheckBox defaultParameterCheckbox;
                    final /* synthetic */ ParameterTableModelItemBase<KotlinParameterInfo> $item;
                    final /* synthetic */ KotlinChangeSignatureDialog this$0;
                    {
                        this.$item = $item;
                        this.this$0 = $receiver;
                        this.components = new ArrayList<E>();
                        this.nameEditor = new EditorTextField(((KotlinParameterInfo)$item.parameter).getName(), KotlinChangeSignatureDialog.access$getProject($receiver), (FileType)$receiver.getFileType());
                        this.defaultParameterCheckbox = new JCheckBox();
                    }

                    private final void notifyReceiverListeners() {
                        boolean isNotReceiver = !org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$Companion.access$isReceiverIn(KotlinChangeSignatureDialog.Companion, this.$item, KotlinChangeSignatureDialog.access$getParametersTableModel(this.this$0));
                        this.nameEditor.setEnabled(isNotReceiver);
                        this.defaultParameterCheckbox.setEnabled(isNotReceiver);
                    }

                    private final boolean isDefaultColumnEnabled() {
                        return ((KotlinParameterInfo)this.$item.parameter).isNewParameter() && !Intrinsics.areEqual((Object)this.$item.parameter, (Object)((KotlinMethodDescriptor)KotlinChangeSignatureDialog.access$getMyMethod$p$s-860463185(this.this$0)).getReceiver());
                    }

                    public void prepareEditor(@NotNull JTable table, int row) {
                        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                        this.setLayout(new BoxLayout((Container)((Object)this), 0));
                        int column = 0;
                        ColumnInfo[] columnInfoArray = KotlinChangeSignatureDialog.access$getParametersTableModel(this.this$0).getColumnInfos();
                        Intrinsics.checkNotNullExpressionValue((Object)columnInfoArray, (String)"getColumnInfos(...)");
                        for (ColumnInfo columnInfo : columnInfoArray) {
                            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                            EditorTextField editor2 = null;
                            JComponent component2 = null;
                            int columnFinal = column;
                            if (KotlinCallableParameterTableModel.Companion.isTypeColumn(columnInfo)) {
                                document = PsiDocumentManager.getInstance((Project)KotlinChangeSignatureDialog.access$getProject(this.this$0)).getDocument((PsiFile)this.$item.typeCodeFragment);
                                editor2 = new EditorTextField(document, KotlinChangeSignatureDialog.access$getProject(this.this$0), (FileType)this.this$0.getFileType());
                                component2 = (JComponent)editor2;
                            } else if (KotlinCallableParameterTableModel.Companion.isNameColumn(columnInfo)) {
                                editor2 = this.nameEditor;
                                component2 = (JComponent)editor2;
                                this.notifyReceiverListeners();
                            } else if (KotlinCallableParameterTableModel.Companion.isDefaultValueColumn(columnInfo) && this.isDefaultColumnEnabled()) {
                                document = PsiDocumentManager.getInstance((Project)KotlinChangeSignatureDialog.access$getProject(this.this$0)).getDocument((PsiFile)this.$item.defaultValueCodeFragment);
                                editor2 = new EditorTextField(document, KotlinChangeSignatureDialog.access$getProject(this.this$0), (FileType)this.this$0.getFileType());
                                component2 = (JComponent)editor2;
                            } else if (KotlinCallableParameterTableModel.Companion.isDefaultParameterColumn(columnInfo) && this.isDefaultColumnEnabled()) {
                                this.defaultParameterCheckbox.setSelected(((KotlinParameterInfo)this.$item.parameter).getDefaultValue() != null);
                                RevertOnDisposeUtilKt.addItemListener((ItemSelectable)this.defaultParameterCheckbox, (Disposable)this.this$0.getDisposable(), arg_0 -> createParametersListTable.getRowEditor.1.prepareEditor$lambda$0(this.this$0, row, columnFinal, arg_0));
                                component2 = this.defaultParameterCheckbox;
                                editor2 = null;
                                this.notifyReceiverListeners();
                            } else if (KotlinPrimaryConstructorParameterTableModel.Companion.isValVarColumn(columnInfo)) {
                                ComboBox comboBox2 = new ComboBox((Object[])KotlinValVar.values());
                                comboBox2.setSelectedItem((Object)((Object)((KotlinParameterInfo)this.$item.parameter).getValOrVar()));
                                RevertOnDisposeUtilKt.addItemListener((ItemSelectable)((ItemSelectable)comboBox2), (Disposable)this.this$0.getDisposable(), arg_0 -> createParametersListTable.getRowEditor.1.prepareEditor$lambda$1(this.this$0, row, columnFinal, arg_0));
                                component2 = (JComponent)comboBox2;
                                editor2 = null;
                            } else {
                                if (!KotlinFunctionParameterTableModel.Companion.isReceiverColumn(columnInfo)) continue;
                                JCheckBox checkBox = new JCheckBox();
                                checkBox.setSelected(Intrinsics.areEqual((Object)KotlinChangeSignatureDialog.access$getParametersTableModel(this.this$0).getReceiver(), (Object)this.$item.parameter));
                                RevertOnDisposeUtilKt.addItemListener((ItemSelectable)checkBox, (Disposable)this.this$0.getDisposable(), arg_0 -> createParametersListTable.getRowEditor.1.prepareEditor$lambda$2(this.$item, this.this$0, this, arg_0));
                                component2 = checkBox;
                                editor2 = null;
                            }
                            JBLabel label2 = new JBLabel(columnInfo.getName(), UIUtil.ComponentStyle.SMALL);
                            panel2.add((Component)label2);
                            if (editor2 != null) {
                                JBTableRowEditor.RowEditorChangeListener listener2 = new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, columnFinal);
                                editor2.addDocumentListener((DocumentListener)listener2);
                                Disposer.register((Disposable)this.this$0.getDisposable(), () -> createParametersListTable.getRowEditor.1.prepareEditor$lambda$3(editor2, listener2));
                                editor2.setPreferredWidth(table.getWidth() / KotlinChangeSignatureDialog.access$getParametersTableModel(this.this$0).getColumnCount());
                            }
                            this.components.add(component2);
                            panel2.add(component2);
                            this.add(panel2);
                            ++column;
                        }
                    }

                    @NotNull
                    public JBTableRow getValue() {
                        return arg_0 -> createParametersListTable.getRowEditor.1.getValue$lambda$4(this.this$0, this, this.$item, arg_0);
                    }

                    private final int getColumnWidth(int letters) {
                        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
                        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
                        Font font2 = font;
                        font2 = new Font(font2.getFontName(), font2.getStyle(), 12);
                        return letters * Toolkit.getDefaultToolkit().getFontMetrics(font2).stringWidth("W");
                    }

                    private final int getEditorIndex(int x) {
                        int[] nArray;
                        int x2 = x;
                        if (this.isDefaultColumnEnabled()) {
                            var4_3 = new int[]{4, KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$0), KotlinChangeSignatureDialog.access$getTypesMaxLength(this.this$0), KotlinChangeSignatureDialog.access$getDefaultValuesMaxLength(this.this$0)};
                            nArray = var4_3;
                        } else {
                            var4_3 = new int[]{4, KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$0), KotlinChangeSignatureDialog.access$getTypesMaxLength(this.this$0)};
                            nArray = var4_3;
                        }
                        int[] columnLetters = nArray;
                        int columnIndex = 0;
                        int n = columnLetters.length;
                        for (int i2 = ((KotlinMethodDescriptor)KotlinChangeSignatureDialog.access$getMyMethod$p$s-860463185(this.this$0)).getKind() == KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 0 : 1; i2 < n; ++i2) {
                            int width = this.getColumnWidth(columnLetters[i2]);
                            if (x2 <= width) {
                                return columnIndex;
                            }
                            ++columnIndex;
                            x2 -= width;
                        }
                        return columnIndex - 1;
                    }

                    @NotNull
                    public JComponent getPreferredFocusedComponent() {
                        JComponent jComponent;
                        MouseEvent me = this.getMouseEvent();
                        MouseEvent mouseEvent = me;
                        int index = mouseEvent != null ? this.getEditorIndex((int)mouseEvent.getPoint().getX()) : (((KotlinMethodDescriptor)KotlinChangeSignatureDialog.access$getMyMethod$p$s-860463185(this.this$0)).getKind() == KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 1 : 0);
                        JComponent jComponent2 = this.components.get(index);
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"get(...)");
                        JComponent component2 = jComponent2;
                        if (component2 instanceof EditorTextField) {
                            JComponent jComponent3 = ((EditorTextField)component2).getFocusTarget();
                            jComponent = jComponent3;
                            Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"getFocusTarget(...)");
                        } else {
                            jComponent = component2;
                        }
                        return jComponent;
                    }

                    @NotNull
                    public JComponent[] getFocusableComponents() {
                        int n = this.components.size();
                        JComponent[] jComponentArray = new JComponent[n];
                        for (int j = 0; j < n; ++j) {
                            JComponent component2;
                            int n2 = j;
                            Intrinsics.checkNotNullExpressionValue((Object)this.components.get(n2), (String)"get(...)");
                            Object object = component2 instanceof EditorTextField ? (EditorTextField)component2 : null;
                            if (object == null || (object = object.getFocusTarget()) == null) {
                                object = component2;
                            }
                            jComponentArray[n2] = object;
                        }
                        return jComponentArray;
                    }

                    private static final void prepareEditor$lambda$0(KotlinChangeSignatureDialog this$0, int $row, int $columnFinal, ItemEvent it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        KotlinChangeSignatureDialog.access$getParametersTableModel(this$0).setValueAtWithoutUpdate(it.getStateChange() == 1, $row, $columnFinal);
                        KotlinChangeSignatureDialog.access$updateSignature(this$0);
                    }

                    private static final void prepareEditor$lambda$1(KotlinChangeSignatureDialog this$0, int $row, int $columnFinal, ItemEvent it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        KotlinChangeSignatureDialog.access$getParametersTableModel(this$0).setValueAtWithoutUpdate(it.getItem(), $row, $columnFinal);
                        KotlinChangeSignatureDialog.access$updateSignature(this$0);
                    }

                    private static final void prepareEditor$lambda$2(ParameterTableModelItemBase $item, KotlinChangeSignatureDialog this$0, createParametersListTable.getRowEditor.1 this$1, ItemEvent it) {
                        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
                        KotlinParameterInfo newReceiver = it.getStateChange() == 1 ? (KotlinParameterInfo)$item.parameter : null;
                        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = KotlinChangeSignatureDialog.access$getParametersTableModel(this$0);
                        Intrinsics.checkNotNull((Object)((Object)kotlinCallableParameterTableModel), (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinFunctionParameterTableModel");
                        ((KotlinFunctionParameterTableModel)kotlinCallableParameterTableModel).setReceiver(newReceiver);
                        KotlinChangeSignatureDialog.access$updateSignature(this$0);
                        this$1.notifyReceiverListeners();
                    }

                    private static final void prepareEditor$lambda$3(EditorTextField $editor, JBTableRowEditor.RowEditorChangeListener $listener) {
                        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
                        $editor.removeDocumentListener((DocumentListener)$listener);
                    }

                    private static final Object getValue$lambda$4(KotlinChangeSignatureDialog this$0, createParametersListTable.getRowEditor.1 this$1, ParameterTableModelItemBase $item, int column) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
                        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
                        ColumnInfo columnInfo = KotlinChangeSignatureDialog.access$getParametersTableModel(this$0).getColumnInfos()[column];
                        if (KotlinPrimaryConstructorParameterTableModel.Companion.isValVarColumn(columnInfo)) {
                            JComponent jComponent = this$1.components.get(column);
                            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JComboBox<*>");
                            object = ((JComboBox)jComponent).getSelectedItem();
                        } else if (KotlinCallableParameterTableModel.Companion.isTypeColumn(columnInfo)) {
                            object = $item.typeCodeFragment;
                        } else if (KotlinCallableParameterTableModel.Companion.isNameColumn(columnInfo)) {
                            JComponent jComponent = this$1.components.get(column);
                            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.ui.EditorTextField");
                            object = ((EditorTextField)jComponent).getText();
                        } else {
                            object = KotlinCallableParameterTableModel.Companion.isDefaultValueColumn(columnInfo) ? $item.defaultValueCodeFragment : (KotlinCallableParameterTableModel.Companion.isDefaultParameterColumn(columnInfo) ? Boolean.valueOf(((KotlinParameterInfo)$item.parameter).getDefaultValue() != null) : null);
                        }
                        return object;
                    }
                };
            }

            protected boolean isRowEmpty(int row) {
                ParameterTableModelItemBase rowItem = this.getRowItem(row);
                if (((CharSequence)((KotlinParameterInfo)rowItem.parameter).getName()).length() > 0) {
                    return false;
                }
                return !(((CharSequence)((KotlinParameterInfo)rowItem.parameter).getTypeText()).length() > 0);
            }

            public static final /* synthetic */ ParameterTableModelItemBase access$getRowItem(createParametersListTable.1 $this, int p0) {
                return $this.getRowItem(p0);
            }
        };
    }

    private final String getPresentationName(ParameterTableModelItemBase<KotlinParameterInfo> item) {
        KotlinParameterInfo parameter2 = (KotlinParameterInfo)item.parameter;
        return Intrinsics.areEqual((Object)parameter2, (Object)this.getParametersTableModel().getReceiver()) ? "<receiver>" : parameter2.getName();
    }

    private final int getColumnTextMaxLength(Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String> nameFunction) {
        Comparable comparable;
        List list2 = this.getParametersTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        Iterator iterator2 = ((Iterable)list2).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            ParameterTableModelItemBase it = (ParameterTableModelItemBase)iterator2.next();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string = (String)nameFunction.invoke((Object)it);
            Comparable comparable2 = Integer.valueOf(string != null ? string.length() : 0);
            while (iterator2.hasNext()) {
                ParameterTableModelItemBase it2 = (ParameterTableModelItemBase)iterator2.next();
                $i$a$-maxOfOrNull-KotlinChangeSignatureDialog$getColumnTextMaxLength$1 = false;
                Intrinsics.checkNotNull((Object)it2);
                String string2 = (String)nameFunction.invoke((Object)it2);
                Comparable comparable3 = Integer.valueOf(string2 != null ? string2.length() : 0);
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    private final int getParamNamesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)new Function1<ParameterTableModelItemBase<KotlinParameterInfo>, String>(this){
            final /* synthetic */ KotlinChangeSignatureDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull ParameterTableModelItemBase<KotlinParameterInfo> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return KotlinChangeSignatureDialog.access$getPresentationName(this.this$0, it);
            }
        }));
    }

    private final int getTypesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)getTypesMaxLength.1.INSTANCE));
    }

    private final int getDefaultValuesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)getDefaultValuesMaxLength.1.INSTANCE));
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    @NotNull
    protected KotlinCallerChooser createCallerChooser(@NlsContexts.DialogTitle @NotNull String title, @Nullable Tree treeToReuse, @NotNull Consumer<? super Set<? extends PsiElement>> callback2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        PsiElement psiElement2 = ((KotlinMethodDescriptor)this.myMethod).getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getMethod(...)");
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        return new KotlinCallerChooser(psiElement2, project2, title, treeToReuse, callback2);
    }

    protected boolean mayPropagateParameters() {
        boolean bl;
        block3: {
            List list2 = this.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinParameterInfo it = (KotlinParameterInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.isNewParameter() && !Intrinsics.areEqual((Object)it, (Object)this.getParametersTableModel().getReceiver()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    protected String calculateSignature() {
        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = this.getParametersTableModel();
        KotlinMethodDescriptor kotlinMethodDescriptor = this.getMethodDescriptor();
        DescriptorVisibility descriptorVisibility = (DescriptorVisibility)this.getVisibility();
        String string = this.getMethodName();
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myDefaultValueContext");
        return KotlinChangeSignatureDialog.Companion.evaluateChangeInfo(kotlinCallableParameterTableModel, this.myReturnTypeCodeFragment, kotlinMethodDescriptor, descriptorVisibility, string, psiElement2, true).getNewSignature(this.getMethodDescriptor().getOriginalPrimaryCallable());
    }

    @NotNull
    protected ComboBoxVisibilityPanel<DescriptorVisibility> createVisibilityControl() {
        Object[] objectArray = new DescriptorVisibility[]{DescriptorVisibilities.INTERNAL, DescriptorVisibilities.PRIVATE, DescriptorVisibilities.PROTECTED, DescriptorVisibilities.PUBLIC};
        return new ComboBoxVisibilityPanel(objectArray);
    }

    protected void updateSignatureAlarmFired() {
        super.updateSignatureAlarmFired();
        this.validateButtons();
    }

    @NotNull
    protected KotlinSignatureComponent createSignaturePreviewComponent() {
        String string = this.calculateSignature();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return new KotlinSignatureComponent(string, project2);
    }

    @Nullable
    protected String validateAndCommitData() {
        if (((KotlinMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && Companion.getTypeInfo(this.myReturnTypeCodeFragment, true, false).getType() == null) {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            Object[] objectArray = new Object[1];
            PsiCodeFragment psiCodeFragment = this.myReturnTypeCodeFragment;
            objectArray[0] = String.valueOf(psiCodeFragment != null ? psiCodeFragment.getText() : null);
            if (!Companion.showWarningMessage(project2, KotlinBundle.message("message.text.return.type.cannot.be.resolved", objectArray))) {
                return "";
            }
        }
        for (ParameterTableModelItemBase item : this.getParametersTableModel().getItems()) {
            if (Companion.getTypeInfo(item.typeCodeFragment, true, false).getType() != null) continue;
            Project project3 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)item.typeCodeFragment.getText(), (String)"getText(...)");
            if (!Intrinsics.areEqual((Object)item.parameter, (Object)this.getParametersTableModel().getReceiver())) {
                Object[] objectArray2 = new Object[]{((KotlinParameterInfo)item.parameter).getName()};
                v3 = KotlinBundle.message("text.parameter.0", objectArray2);
            } else {
                v3 = objectArray[1] = KotlinBundle.message("text.receiver", new Object[0]);
            }
            if (Companion.showWarningMessage(project3, KotlinBundle.message("message.type.for.cannot.be.resolved", objectArray))) continue;
            return "";
        }
        return null;
    }

    @NotNull
    protected String getMethodName() {
        String string = super.getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodName(...)");
        return KtPsiUtilKt.quoteIfNeeded((String)string);
    }

    protected void canRun() {
        if (this.myNamePanel.isVisible() && ((KotlinMethodDescriptor)this.myMethod).canChangeName() && !KtPsiUtilKt.isIdentifier((String)this.getMethodName())) {
            throw new ConfigurationException(KotlinBundle.message("function.name.is.invalid", new Object[0]));
        }
        if (((KotlinMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
            PsiCodeFragment psiCodeFragment = this.myReturnTypeCodeFragment;
            KtTypeCodeFragment ktTypeCodeFragment = psiCodeFragment instanceof KtTypeCodeFragment ? (KtTypeCodeFragment)psiCodeFragment : null;
            if (ktTypeCodeFragment != null) {
                KotlinRefactoringUtilKt.validateElement((KtElement)ktTypeCodeFragment, KotlinBundle.message("return.type.is.invalid", new Object[0]));
            }
        }
        for (ParameterTableModelItemBase item : this.getParametersTableModel().getItems()) {
            String parameterName2 = KtPsiUtilKt.quoteIfNeeded((String)((KotlinParameterInfo)item.parameter).getName());
            if (!Intrinsics.areEqual((Object)item.parameter, (Object)this.getParametersTableModel().getReceiver()) && !KtPsiUtilKt.isIdentifier((String)parameterName2)) {
                Object[] objectArray = new Object[]{parameterName2};
                throw new ConfigurationException(KotlinBundle.message("parameter.name.is.invalid", objectArray));
            }
            Object[] objectArray = item.typeCodeFragment;
            KtTypeCodeFragment ktTypeCodeFragment = objectArray instanceof KtTypeCodeFragment ? (KtTypeCodeFragment)objectArray : null;
            if (ktTypeCodeFragment == null) continue;
            KtElement ktElement = (KtElement)ktTypeCodeFragment;
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)item.typeCodeFragment.getText(), (String)"getText(...)");
            KotlinRefactoringUtilKt.validateElement(ktElement, KotlinBundle.message("parameter.type.is.invalid", objectArray));
        }
    }

    @NotNull
    protected BaseRefactoringProcessor createRefactoringProcessor() {
        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = this.getParametersTableModel();
        KotlinMethodDescriptor kotlinMethodDescriptor = this.getMethodDescriptor();
        DescriptorVisibility descriptorVisibility = (DescriptorVisibility)this.getVisibility();
        String string = this.getMethodName();
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myDefaultValueContext");
        KotlinChangeInfo changeInfo = KotlinChangeSignatureDialog.Companion.evaluateChangeInfo(kotlinCallableParameterTableModel, this.myReturnTypeCodeFragment, kotlinMethodDescriptor, descriptorVisibility, string, psiElement2, false);
        Set set2 = this.myMethodsToPropagateParameters;
        changeInfo.setPrimaryPropagationTargets(set2 == null ? (Collection)CollectionsKt.emptyList() : (Collection)set2);
        changeInfo.setCheckUsedParameters(true);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        String string2 = this.commandName;
        if (string2 == null) {
            string2 = this.getTitle();
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        return (BaseRefactoringProcessor)new KotlinChangeSignatureProcessor(project2, changeInfo, string3);
    }

    private final KotlinMethodDescriptor getMethodDescriptor() {
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"myMethod");
        return (KotlinMethodDescriptor)methodDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    protected int getSelectedIdx() {
        int n;
        Object v1;
        block8: {
            List list2 = ((KotlinMethodDescriptor)this.myMethod).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
            Iterable $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)list2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IndexedValue it = (IndexedValue)element$iv;
                boolean bl = false;
                if (!((KotlinParameterInfo)it.getValue()).isNewParameter()) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        IndexedValue indexedValue = v1;
        if (indexedValue != null) {
            n = indexedValue.getIndex();
        } else {
            Integer n2;
            Editor editor2 = this.editor;
            if (editor2 != null) {
                KtParameter ktParameter;
                void $this$findElementForRename$iv;
                Editor editor3 = editor2;
                boolean bl = false;
                PsiFile psiFile2 = this.myDefaultValueContext.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                PsiFile psiFile3 = psiFile2;
                int offset$iv = editor3.getCaretModel().getOffset();
                boolean $i$f$findElementForRename = false;
                PsiElement psiElement2 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$this$findElementForRename$iv, (int)offset$iv, KtParameter.class, (boolean)false);
                if (psiElement2 == null) {
                    psiElement2 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$this$findElementForRename$iv, (int)RangesKt.coerceAtLeast((int)(offset$iv - 1), (int)0), KtParameter.class, (boolean)false);
                }
                if ((ktParameter = (KtParameter)psiElement2) != null) {
                    Integer n3 = KtPsiUtilKt.parameterIndex((PsiElement)((PsiElement)ktParameter));
                    int offset2 = ((Number)n3).intValue();
                    boolean bl2 = false;
                    n2 = !(offset2 == -1) ? n3 : null;
                } else {
                    n2 = null;
                }
            } else {
                n2 = null;
            }
            n = n2 != null ? n2.intValue() : super.getSelectedIdx();
        }
        return n;
    }

    public static final /* synthetic */ Project access$getProject(KotlinChangeSignatureDialog $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ KotlinCallableParameterTableModel access$getParametersTableModel(KotlinChangeSignatureDialog $this) {
        return $this.getParametersTableModel();
    }

    public static final /* synthetic */ MethodDescriptor access$getMyMethod$p$s-860463185(KotlinChangeSignatureDialog $this) {
        return $this.myMethod;
    }

    public static final /* synthetic */ int access$getParamNamesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getParamNamesMaxLength();
    }

    public static final /* synthetic */ int access$getTypesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getTypesMaxLength();
    }

    public static final /* synthetic */ int access$getDefaultValuesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getDefaultValuesMaxLength();
    }

    public static final /* synthetic */ void access$updateSignature(KotlinChangeSignatureDialog $this) {
        $this.updateSignature();
    }

    public static final /* synthetic */ String access$getPresentationName(KotlinChangeSignatureDialog $this, ParameterTableModelItemBase item) {
        return $this.getPresentationName((ParameterTableModelItemBase<KotlinParameterInfo>)item);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002JD\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001b\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\u001e\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001fJ\u001c\u0010 \u001a\u00020!*\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010#\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u0004H\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog$Companion;", "", "()V", "createParametersInfoModel", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "descriptor", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;", "defaultValueContext", "Lcom/intellij/psi/PsiElement;", "createRefactoringProcessorForSilentChangeSignature", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "commandName", "", "method", "createReturnTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "evaluateChangeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeInfo;", "parametersModel", "returnTypeCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "methodDescriptor", "visibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "methodName", "forPreview", "", "showWarningMessage", "message", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "getTypeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinTypeInfo;", "isCovariant", "isReceiverIn", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelItemBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "model", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinChangeSignatureDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChangeSignatureDialog.kt\norg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,533:1\n1#2:534\n1549#3:535\n1620#3,3:536\n1054#3:539\n*S KotlinDebug\n*F\n+ 1 KotlinChangeSignatureDialog.kt\norg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog$Companion\n*L\n489#1:535\n489#1:536,3\n517#1:539\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isReceiverIn(ParameterTableModelItemBase<KotlinParameterInfo> $this$isReceiverIn, KotlinCallableParameterTableModel model2) {
            return Intrinsics.areEqual((Object)$this$isReceiverIn.parameter, (Object)model2.getReceiver());
        }

        public final boolean showWarningMessage(@NotNull Project project2, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            String string = RefactoringBundle.message((String)"changeSignature.refactoring.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return ((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(string, message2).asWarning()).ask(project2);
        }

        private final KotlinCallableParameterTableModel createParametersInfoModel(KotlinMethodDescriptor descriptor2, PsiElement defaultValueContext) {
            return switch (WhenMappings.$EnumSwitchMapping$0[descriptor2.getKind().ordinal()]) {
                case 1 -> new KotlinFunctionParameterTableModel(descriptor2, defaultValueContext);
                case 2 -> new KotlinPrimaryConstructorParameterTableModel(descriptor2, defaultValueContext);
                case 3 -> new KotlinSecondaryConstructorParameterTableModel(descriptor2, defaultValueContext);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final KtTypeCodeFragment createReturnTypeCodeFragment(Project project2, KotlinMethodDescriptor method) {
            return new KtPsiFactory(project2, false, 2, null).createTypeCodeFragment(KotlinTypeInfoKt.render(KotlinMethodDescriptorKt.getReturnTypeInfo(method)), (PsiElement)KotlinCallableParameterTableModel.Companion.getTypeCodeFragmentContext(method.getBaseDeclaration()));
        }

        @NotNull
        public final BaseRefactoringProcessor createRefactoringProcessorForSilentChangeSignature(@NotNull Project project2, @NlsContexts.Command @NotNull String commandName, @NotNull KotlinMethodDescriptor method, @NotNull PsiElement defaultValueContext) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)defaultValueContext, (String)"defaultValueContext");
            KotlinCallableParameterTableModel parameterTableModel = this.createParametersInfoModel(method, defaultValueContext);
            parameterTableModel.setParameterInfos(method.getParameters());
            PsiCodeFragment psiCodeFragment = (PsiCodeFragment)this.createReturnTypeCodeFragment(project2, method);
            DescriptorVisibility descriptorVisibility = (DescriptorVisibility)method.getVisibility();
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            KotlinChangeInfo changeInfo = this.evaluateChangeInfo(parameterTableModel, psiCodeFragment, method, descriptorVisibility, string, defaultValueContext, false);
            return (BaseRefactoringProcessor)new KotlinChangeSignatureProcessor(project2, changeInfo, commandName);
        }

        @NotNull
        public final KotlinTypeInfo getTypeInfo(@Nullable PsiCodeFragment $this$getTypeInfo, boolean isCovariant, boolean forPreview) {
            Object object;
            Object object2;
            KtTypeReference typeRef;
            if (!($this$getTypeInfo instanceof KtTypeCodeFragment)) {
                return new KotlinTypeInfo(isCovariant, null, null, 6, null);
            }
            KtTypeReference ktTypeReference = typeRef = ((KtTypeCodeFragment)$this$getTypeInfo).getContentElement();
            String string = ktTypeReference != null ? ktTypeReference.getText() : null;
            if (string == null) {
                return new KotlinTypeInfo(isCovariant, null, null, 6, null);
            }
            String typeRefText = string;
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)typeRef, BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeRef);
            if (kotlinType != null) {
                KotlinType it = object2 = kotlinType;
                boolean bl = false;
                object = !KotlinTypeKt.isError((KotlinType)it) ? object2 : null;
            } else {
                object = null;
            }
            KotlinType type2 = object;
            String string2 = typeRefText;
            object2 = string2;
            KotlinType kotlinType2 = type2;
            boolean bl = isCovariant;
            boolean bl2 = false;
            boolean bl3 = forPreview || type2 == null;
            String string3 = bl3 ? string2 : null;
            KotlinType kotlinType3 = kotlinType2;
            boolean bl4 = bl;
            return new KotlinTypeInfo(bl4, kotlinType3, string3);
        }

        /*
         * WARNING - void declaration
         */
        private final KotlinChangeInfo evaluateChangeInfo(KotlinCallableParameterTableModel parametersModel, PsiCodeFragment returnTypeCodeFragment, KotlinMethodDescriptor methodDescriptor, DescriptorVisibility visibility2, String methodName, PsiElement defaultValueContext, boolean forPreview) {
            List list2;
            void $this$mapTo$iv$iv;
            List list3 = parametersModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getItems(...)");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter2;
                ParameterTableModelItemBase parameterTableModelItemBase = (ParameterTableModelItemBase)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KotlinParameterInfo parameterInfo = (KotlinParameterInfo)parameter2.parameter;
                if (!forPreview) {
                    Intrinsics.checkNotNull((Object)parameter2);
                    if (Companion.isReceiverIn((ParameterTableModelItemBase<KotlinParameterInfo>)parameter2, parametersModel)) {
                        parameterInfo.setDefaultValueAsDefaultParameter(false);
                    }
                }
                KotlinTypeInfo kotlinTypeInfo = Companion.getTypeInfo(parameter2.typeCodeFragment, false, forPreview);
                KotlinType newKotlinType = kotlinTypeInfo.getType();
                KotlinType oldKotlinType = parameterInfo.getCurrentTypeInfo().getType();
                parameterInfo.setCurrentTypeInfo(kotlinTypeInfo);
                PsiCodeFragment psiCodeFragment = parameter2.defaultValueCodeFragment;
                Intrinsics.checkNotNull((Object)psiCodeFragment, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpressionCodeFragment");
                KtExpressionCodeFragment codeFragment = (KtExpressionCodeFragment)psiCodeFragment;
                if (!Intrinsics.areEqual((Object)newKotlinType, (Object)oldKotlinType) && codeFragment.getContentElement() != null) {
                    codeFragment.putUserData(CodeFragmentAnalyzer.Companion.getEXPECTED_TYPE_KEY(), (Object)kotlinTypeInfo.getType());
                    DaemonCodeAnalyzer.getInstance((Project)codeFragment.getProject()).restart((PsiFile)codeFragment);
                }
                if (!forPreview) {
                    AddFullQualifierIntention.Holder.INSTANCE.addQualifiersRecursively((KtElement)codeFragment);
                }
                KtExpression oldDefaultValue = parameterInfo.getDefaultValueForCall();
                KtExpression ktExpression = oldDefaultValue;
                if (!Intrinsics.areEqual((Object)codeFragment.getText(), (Object)(ktExpression != null ? ktExpression.getText() : ""))) {
                    parameterInfo.setDefaultValueForCall(codeFragment.getContentElement());
                }
                collection.add(parameterInfo);
            }
            List parameters2 = (List)destination$iv$iv;
            if (parametersModel.getReceiver() != null) {
                Iterable $this$sortedByDescending$iv = parameters2;
                boolean $i$f$sortedByDescending = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(parametersModel){
                    final /* synthetic */ KotlinCallableParameterTableModel $parametersModel$inlined;
                    {
                        this.$parametersModel$inlined = kotlinCallableParameterTableModel;
                    }

                    public final int compare(T a, T b2) {
                        KotlinParameterInfo it = (KotlinParameterInfo)b2;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)this.$parametersModel$inlined.getReceiver()));
                        it = (KotlinParameterInfo)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)this.$parametersModel$inlined.getReceiver())));
                    }
                });
            } else {
                list2 = parameters2;
            }
            List parametersWithReceiverInFirstPosition = list2;
            KotlinMethodDescriptor kotlinMethodDescriptor = methodDescriptor.getOriginal();
            KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(returnTypeCodeFragment, true, forPreview);
            DescriptorVisibility descriptorVisibility = visibility2;
            if (descriptorVisibility == null) {
                descriptorVisibility = DescriptorVisibilities.DEFAULT_VISIBILITY;
            }
            DescriptorVisibility descriptorVisibility2 = descriptorVisibility;
            Intrinsics.checkNotNull((Object)descriptorVisibility2);
            return new KotlinChangeInfo(kotlinMethodDescriptor, methodName, kotlinTypeInfo, descriptorVisibility2, parametersWithReceiverInFirstPosition, parametersModel.getReceiver(), defaultValueContext, null, false, 384, null);
        }

        public static final /* synthetic */ boolean access$isReceiverIn(Companion $this, ParameterTableModelItemBase $receiver, KotlinCallableParameterTableModel model2) {
            return $this.isReceiverIn((ParameterTableModelItemBase<KotlinParameterInfo>)$receiver, model2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KotlinMethodDescriptor.Kind.values().length];
                try {
                    nArray[KotlinMethodDescriptor.Kind.FUNCTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KotlinMethodDescriptor.Kind.SECONDARY_CONSTRUCTOR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

