/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationDialog;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinDestinationFolderComboBox;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001\f\u0018\u0000 42\u00020\u0001:\u00014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010+\u001a\u0004\u0018\u00010\u0011H\u0003J\b\u0010,\u001a\u00020-H\u0014J\n\u0010.\u001a\u0004\u0018\u00010/H\u0014J\b\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u00020\u0011H\u0014J\b\u00103\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\"\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "defaultTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/openapi/project/Project;)V", "classNameField", "Lcom/intellij/ui/EditorTextField;", "destinationComboBox", "org/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$destinationComboBox$1", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$destinationComboBox$1;", "informationLabel", "Ljavax/swing/JLabel;", "newName", "", "getNewName", "()Ljava/lang/String;", "openInEditor", "", "getOpenInEditor", "()Z", "openInEditorCheckBox", "Ljavax/swing/JCheckBox;", "kotlin.jvm.PlatformType", "originalFile", "Lcom/intellij/psi/PsiFile;", "packageLabel", "packageNameField", "Lcom/intellij/ui/ReferenceEditorComboWithBrowseButton;", "qualifiedName", "getQualifiedName", "<set-?>", "Lcom/intellij/refactoring/MoveDestination;", "targetDirectory", "getTargetDirectory", "()Lcom/intellij/refactoring/MoveDestination;", "targetSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetSourceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "checkForErrors", "createCenterPanel", "Ljavax/swing/JPanel;", "createNorthPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "getHelpId", "getPreferredFocusedComponent", "Companion", "kotlin.idea"})
public final class CopyKotlinDeclarationDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiDirectory defaultTargetDirectory;
    @NotNull
    private final Project project;
    @NotNull
    private final JLabel informationLabel;
    @NotNull
    private final EditorTextField classNameField;
    @NotNull
    private final JLabel packageLabel;
    private ReferenceEditorComboWithBrowseButton packageNameField;
    private final JCheckBox openInEditorCheckBox;
    @NotNull
    private final destinationComboBox.1 destinationComboBox;
    private final PsiFile originalFile;
    @Nullable
    private MoveDestination targetDirectory;
    @NonNls
    @NotNull
    private static final String RECENTS_KEY = "CopyKotlinDeclarationDialog.RECENTS_KEY";

    public CopyKotlinDeclarationDialog(@NotNull KtNamedDeclaration declaration2, @Nullable PsiDirectory defaultTargetDirectory, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, true);
        this.defaultTargetDirectory = defaultTargetDirectory;
        this.project = project2;
        this.informationLabel = new JLabel();
        this.classNameField = new EditorTextField("");
        this.packageLabel = new JLabel();
        this.openInEditorCheckBox = CopyFilesOrDirectoriesDialog.createOpenInEditorCB();
        this.destinationComboBox = new KotlinDestinationFolderComboBox(this){
            final /* synthetic */ CopyKotlinDeclarationDialog this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getTargetPackage() {
                ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = CopyKotlinDeclarationDialog.access$getPackageNameField$p(this.this$0);
                if (referenceEditorComboWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
                    referenceEditorComboWithBrowseButton = null;
                }
                String string = referenceEditorComboWithBrowseButton.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return ((Object)StringsKt.trim((CharSequence)string)).toString();
            }

            protected boolean reportBaseInTestSelectionInSource() {
                return true;
            }
        };
        this.originalFile = declaration2.getContainingFile();
        Object[] objectArray = new Object[]{UsageViewUtil.getType((PsiElement)((PsiElement)declaration2)), UsageViewUtil.getLongName((PsiElement)((PsiElement)declaration2))};
        this.informationLabel.setText(JavaRefactoringBundle.message((String)"copy.class.copy.0.1", (Object[])objectArray));
        this.informationLabel.setFont(this.informationLabel.getFont().deriveFont(1));
        this.init();
        Consumer consumer = (Consumer)Pass.create(arg_0 -> CopyKotlinDeclarationDialog._init_$lambda$0((Function1)new Function1<String, Unit>(){

            public final void invoke(String it) {
                this.setErrorText(it, (JComponent)((Object)destinationComboBox));
            }
        }, arg_0));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        this.destinationComboBox.setData(this.project, this.defaultTargetDirectory, consumer, (EditorComboBox)referenceEditorComboWithBrowseButton.getChildComponent());
        this.classNameField.setText(UsageViewUtil.getShortName((PsiElement)((PsiElement)declaration2)));
        this.classNameField.selectAll();
    }

    @Nullable
    public final MoveDestination getTargetDirectory() {
        return this.targetDirectory;
    }

    @Nullable
    public final VirtualFile getTargetSourceRoot() {
        Object object = this.destinationComboBox.getComboBox().getSelectedItem();
        DirectoryChooser.ItemWrapper itemWrapper = object instanceof DirectoryChooser.ItemWrapper ? (DirectoryChooser.ItemWrapper)object : null;
        PsiFileSystemItem psiFileSystemItem = itemWrapper != null && (itemWrapper = itemWrapper.getDirectory()) != null ? (PsiFileSystemItem)itemWrapper : (PsiFileSystemItem)this.originalFile;
        Intrinsics.checkNotNull((Object)psiFileSystemItem);
        return ProjectRootsUtilKt.getSourceRoot(psiFileSystemItem);
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.classNameField;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    @Nullable
    protected JComponent createNorthPanel() {
        String qualifiedName2 = this.getQualifiedName();
        this.packageNameField = (ReferenceEditorComboWithBrowseButton)new PackageNameReferenceEditorCombo(qualifiedName2, this.project, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        referenceEditorComboWithBrowseButton.setTextFieldPreferredWidth(Math.max(qualifiedName2.length() + 5, 40));
        this.packageLabel.setText(JavaRefactoringBundle.message((String)"destination.package", (Object[])new Object[0]));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.packageNameField;
        if (referenceEditorComboWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton2 = null;
        }
        this.packageLabel.setLabelFor((Component)referenceEditorComboWithBrowseButton2);
        JLabel label2 = new JLabel(RefactoringBundle.message((String)"target.destination.folder"));
        boolean isMultipleSourceRoots = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(this.project).size() > 1;
        this.destinationComboBox.setVisible(isMultipleSourceRoots);
        label2.setVisible(isMultipleSourceRoots);
        label2.setLabelFor((Component)((Object)this.destinationComboBox));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.openInEditorCheckBox, "East");
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.informationLabel).addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)this.classNameField, 12);
        JComponent jComponent = this.packageLabel;
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton3 = this.packageNameField;
        if (referenceEditorComboWithBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton3 = null;
        }
        return formBuilder.addLabeledComponent(jComponent, (JComponent)referenceEditorComboWithBrowseButton3).addLabeledComponent((JComponent)label2, (JComponent)((Object)this.destinationComboBox)).addComponent((JComponent)panel2).getPanel();
    }

    private final String getQualifiedName() {
        String string;
        PsiDirectory psiDirectory = this.defaultTargetDirectory;
        if ((psiDirectory != null && (psiDirectory = PackageUtilsKt.getPackage(psiDirectory)) != null ? psiDirectory.getQualifiedName() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getNewName() {
        String string = this.classNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final boolean getOpenInEditor() {
        return this.openInEditorCheckBox.isSelected();
    }

    @NlsContexts.DialogMessage
    @Nls
    private final String checkForErrors() {
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        String packageName = referenceEditorComboWithBrowseButton.getText();
        String newName2 = this.getNewName();
        PsiManager psiManager2 = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
        PsiManager manager = psiManager2;
        Intrinsics.checkNotNull((Object)packageName);
        if (((CharSequence)packageName).length() > 0 && !KotlinRefactoringUtilKt.hasIdentifiersOnly(new FqNameUnsafe(packageName))) {
            return JavaRefactoringBundle.message((String)"invalid.target.package.name.specified", (Object[])new Object[0]);
        }
        if (((CharSequence)newName2).length() == 0) {
            return JavaRefactoringBundle.message((String)"no.class.name.specified", (Object[])new Object[0]);
        }
        try {
            this.targetDirectory = this.destinationComboBox.selectDirectory(new PackageWrapper(manager, packageName), false);
        }
        catch (IncorrectOperationException e) {
            return e.getMessage();
        }
        MoveDestination moveDestination = this.targetDirectory;
        if (moveDestination != null && (moveDestination = moveDestination.getTargetIfExists(this.defaultTargetDirectory)) != null) {
            MoveDestination it = moveDestination;
            boolean bl = false;
            String targetFileName = newName2 + "." + this.originalFile.getVirtualFile().getExtension();
            if (Intrinsics.areEqual((Object)it.findFile(targetFileName), (Object)this.originalFile)) {
                return KotlinBundle.message("error.text.can.t.copy.class.to.the.containing.file", new Object[0]);
            }
        }
        return null;
    }

    protected void doOKAction() {
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        String packageName = referenceEditorComboWithBrowseButton.getText();
        String checkForErrors2 = this.checkForErrors();
        if (checkForErrors2 != null) {
            if (((CharSequence)checkForErrors2).length() > 0) {
                Messages.showMessageDialog((Project)this.project, (String)checkForErrors2, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
            this.classNameField.requestFocusInWindow();
            return;
        }
        RecentsManager.getInstance((Project)this.project).registerRecentEntry(RECENTS_KEY, packageName);
        CopyFilesOrDirectoriesDialog.saveOpenInEditorState((boolean)this.openInEditorCheckBox.isSelected());
        super.doOKAction();
    }

    @NotNull
    protected String getHelpId() {
        return "refactoring.copyClass";
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ReferenceEditorComboWithBrowseButton access$getPackageNameField$p(CopyKotlinDeclarationDialog $this) {
        return $this.packageNameField;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$Companion;", "", "()V", "RECENTS_KEY", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

