/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.usageView.UsageViewTypeLocation;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010%\u001a\u00020\u0012H\u0014J\b\u0010&\u001a\u00020\u0012H\u0014J\b\u0010'\u001a\u00020(H&J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\u0018H\u0014J\b\u0010,\u001a\u00020\u0018H\u0014J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0018H\u0003J\b\u0010/\u001a\u00020\u0018H\u0014J\n\u00100\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u00101\u001a\u00020\u0018H\u0014J\b\u00102\u001a\u00020\u0012H\u0004J\b\u00103\u001a\u00020\u0012H\u0004J\b\u00104\u001a\u00020*H\u0002R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001aR\u0014\u0010!\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "declaration", "reference", "Lcom/intellij/psi/PsiReference;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiReference;Lcom/intellij/openapi/editor/Editor;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "inlineKeepOption", "Lkotlin/reflect/KMutableProperty1;", "Lorg/jetbrains/kotlin/idea/refactoring/KotlinRefactoringSettings;", "", "getInlineKeepOption", "()Lkotlin/reflect/KMutableProperty1;", "inlineThisOption", "getInlineThisOption", "kind", "", "getKind", "()Ljava/lang/String;", "occurrencesNumber", "", "getOccurrencesNumber", "()I", "occurrencesString", "getOccurrencesString", "refactoringName", "getRefactoringName", "getReference", "()Lcom/intellij/psi/PsiReference;", "allowInlineAll", "canInlineThisOnly", "createProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "doAction", "", "getBorderTitle", "getInlineAllText", "getInlineText", "verb", "getInlineThisText", "getKeepTheDeclarationText", "getNameLabelText", "isInlineThis", "isKeepTheDeclarationByDefault", "saveSettings", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinInlineDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinInlineDialog.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public abstract class AbstractKotlinInlineDialog<TDeclaration extends KtNamedDeclaration>
extends InlineOptionsDialog {
    @NotNull
    private final TDeclaration declaration;
    @Nullable
    private final PsiReference reference;
    @Nullable
    private final Editor editor;
    private final int occurrencesNumber;

    public AbstractKotlinInlineDialog(@NotNull TDeclaration declaration2, @Nullable PsiReference reference2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        super(declaration2.getProject(), true, (PsiElement)declaration2);
        this.declaration = declaration2;
        this.reference = reference2;
        this.editor = editor2;
        this.occurrencesNumber = InlineOptionsDialog.initOccurrencesNumber((PsiNameIdentifierOwner)((PsiNameIdentifierOwner)this.declaration));
        this.myInvokedOnReference = this.reference != null;
        this.setTitle(this.getRefactoringName());
    }

    @NotNull
    protected final TDeclaration getDeclaration() {
        return this.declaration;
    }

    @Nullable
    protected final PsiReference getReference() {
        return this.reference;
    }

    @Nullable
    protected final Editor getEditor() {
        return this.editor;
    }

    protected final boolean isKeepTheDeclarationByDefault() {
        return (Boolean)this.getInlineKeepOption().get((Object)KotlinRefactoringSettings.Companion.getInstance());
    }

    protected final boolean isInlineThis() {
        return (Boolean)this.getInlineThisOption().get((Object)KotlinRefactoringSettings.Companion.getInstance());
    }

    public final void doAction() {
        this.invokeRefactoring(this.createProcessor());
        this.saveSettings();
    }

    private final void saveSettings() {
        KotlinRefactoringSettings settings2 = KotlinRefactoringSettings.Companion.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            this.getInlineThisOption().set((Object)settings2, (Object)this.isInlineThisOnly());
        }
        JRadioButton jRadioButton = this.myKeepTheDeclaration;
        boolean bl = jRadioButton != null ? jRadioButton.isEnabled() : false;
        if (bl) {
            this.getInlineKeepOption().set((Object)settings2, (Object)this.isKeepTheDeclaration());
        }
    }

    @NotNull
    public abstract KMutableProperty1<KotlinRefactoringSettings, Boolean> getInlineThisOption();

    @NotNull
    public abstract KMutableProperty1<KotlinRefactoringSettings, Boolean> getInlineKeepOption();

    @NotNull
    public abstract BaseRefactoringProcessor createProcessor();

    protected final int getOccurrencesNumber() {
        return this.occurrencesNumber;
    }

    private final String getOccurrencesString() {
        return this.occurrencesNumber >= 0 ? this.occurrencesNumber + " " + StringUtil.pluralize((String)"occurrence", (int)this.occurrencesNumber) : null;
    }

    private final String getKind() {
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)this.declaration), (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
        return string;
    }

    private final String getRefactoringName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)StringUtil.capitalizeWords((String)this.getKind(), (boolean)true), (String)"capitalizeWords(...)");
        return KotlinBundle.message("text.inline.0", objectArray);
    }

    protected boolean canInlineThisOnly() {
        return false;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    @NotNull
    protected String getBorderTitle() {
        return this.getRefactoringName();
    }

    @NotNull
    protected String getNameLabelText() {
        Object object;
        block3: {
            block2: {
                object = this.getOccurrencesString();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = " - " + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String occurrencesString = object;
        return StringsKt.capitalize((String)this.getKind()) + " " + this.declaration.getNameAsSafeName() + " " + occurrencesString;
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String getInlineText(String verb) {
        Object object;
        Object[] objectArray;
        String string;
        block3: {
            block2: {
                void it;
                string = "text.inline.all.references.and.verb.0.the.kind.1.occurrences.2";
                objectArray = new Object[3];
                objectArray[0] = verb;
                objectArray[1] = this.getKind();
                Object[] objectArray2 = objectArray;
                int n = 2;
                object = this.getOccurrencesString();
                if (object == null) break block2;
                String string2 = object;
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                String string3 = string;
                boolean bl = false;
                String string4 = "(" + (String)it + ")";
                string = string3;
                objectArray2 = objectArray3;
                n = n2;
                String string5 = string4;
                object = string5;
                if (string5 != null) break block3;
            }
            object = "";
        }
        objectArray2[n] = object;
        return KotlinBundle.message(string, objectArray);
    }

    @NotNull
    protected String getInlineAllText() {
        String string;
        if (this.declaration.isWritable()) {
            string = this.getInlineText(KotlinBundle.message("text.remove", new Object[0]));
        } else {
            String string2 = RefactoringBundle.message((String)"all.invocations.in.project");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return string;
    }

    @Nullable
    protected String getKeepTheDeclarationText() {
        return this.declaration.isWritable() && (this.occurrencesNumber > 1 || !this.myInvokedOnReference) ? this.getInlineText(KotlinBundle.message("text.keep", new Object[0])) : null;
    }

    @NotNull
    protected String getInlineThisText() {
        Object[] objectArray = new Object[]{this.getKind()};
        return KotlinBundle.message("text.inline.this.reference.and.keep.the.0", objectArray);
    }
}

