/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories;

import com.intellij.lang.Language;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveDeclarationDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSource;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSourceKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J6\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J6\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0004J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J,\u0010\u001b\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001dH\u0016J\u001e\u0010\u001b\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J \u0010 \u001a\u0004\u0018\u00010!*\u00020\"2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u0004H\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFileHandler;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiFile;", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "psiFile", "newParent", "Lcom/intellij/psi/PsiDirectory;", "searchInComments", "searchInNonJavaFiles", "withConflicts", "searchInCommentsAndStrings", "initMoveProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "searchInNonCode", "prepareMovedFile", "", "file", "moveDestination", "oldToNewMap", "", "Lcom/intellij/psi/PsiElement;", "retargetUsages", "usageInfos", "", "moveDeclarationsProcessor", "updateMovedFile", "getPackageNameInfo", "Lorg/jetbrains/kotlin/idea/refactoring/move/MoveContainerChangeInfo;", "Lorg/jetbrains/kotlin/psi/KtFile;", "clearUserData", "FileInfo", "MoveContext", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMoveKotlinFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveKotlinFileHandler.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n288#2,2:160\n1#3:162\n*S KotlinDebug\n*F\n+ 1 MoveKotlinFileHandler.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler\n*L\n151#1:160,2\n*E\n"})
public final class MoveKotlinFileHandler
extends MoveFileHandler {
    private final MoveContainerChangeInfo getPackageNameInfo(KtFile $this$getPackageNameInfo, PsiDirectory newParent, boolean clearUserData) {
        Boolean bl = MoveUtilKt.getUpdatePackageDirective($this$getPackageNameInfo);
        boolean shouldUpdatePackageDirective = bl != null ? bl : PackageUtilsKt.packageMatchesDirectoryOrImplicit($this$getPackageNameInfo);
        MoveUtilKt.setUpdatePackageDirective($this$getPackageNameInfo, clearUserData ? null : Boolean.valueOf(shouldUpdatePackageDirective));
        if (!shouldUpdatePackageDirective) {
            return null;
        }
        FqName oldPackageName = $this$getPackageNameInfo.getPackageFqName();
        PsiDirectory psiDirectory = newParent;
        if (psiDirectory == null || (psiDirectory = PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory)) == null) {
            return new MoveContainerChangeInfo(new MoveContainerInfo.Package(oldPackageName), MoveContainerInfo.UnknownPackage.INSTANCE);
        }
        PsiDirectory newPackageName = psiDirectory;
        if (Intrinsics.areEqual((Object)oldPackageName.asString(), (Object)newPackageName.asString()) && Intrinsics.areEqual((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$this$getPackageNameInfo)), (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)newParent)))) {
            return null;
        }
        if (!KotlinRefactoringUtilKt.hasIdentifiersOnly((FqName)newPackageName)) {
            return null;
        }
        return new MoveContainerChangeInfo(new MoveContainerInfo.Package(oldPackageName), new MoveContainerInfo.Package((FqName)newPackageName));
    }

    @Nullable
    public final MoveKotlinDeclarationsProcessor initMoveProcessor(@NotNull PsiFile psiFile2, @Nullable PsiDirectory newParent, boolean withConflicts, boolean searchInCommentsAndStrings, boolean searchInNonCode) {
        KotlinMoveTarget kotlinMoveTarget;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        if (!(psiFile2 instanceof KtFile)) {
            return null;
        }
        MoveContainerChangeInfo moveContainerChangeInfo = this.getPackageNameInfo((KtFile)psiFile2, newParent, false);
        if (moveContainerChangeInfo == null) {
            return null;
        }
        MoveContainerChangeInfo packageNameInfo = moveContainerChangeInfo;
        Project project2 = ((KtFile)psiFile2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        MoveContainerInfo newPackage = packageNameInfo.getNewContainer();
        if (Intrinsics.areEqual((Object)newPackage, (Object)MoveContainerInfo.UnknownPackage.INSTANCE)) {
            kotlinMoveTarget = KotlinMoveTarget.Empty.INSTANCE;
        } else {
            if (newParent == null) {
                return null;
            }
            FqName fqName2 = newPackage.getFqName();
            Intrinsics.checkNotNull((Object)fqName2);
            kotlinMoveTarget = new KotlinMoveTarget.DeferredFile(fqName2, newParent.getVirtualFile(), (Function1<? super KtFile, ? extends KtFile>)((Function1)new Function1<KtFile, KtFile>(psiFile2, newParent){
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ PsiDirectory $newParent;
                {
                    this.$psiFile = $psiFile;
                    this.$newParent = $newParent;
                    super(1);
                }

                @NotNull
                public final KtFile invoke(@NotNull KtFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)this.$psiFile, (PsiDirectory)this.$newParent);
                    PsiFile psiFile2 = this.$newParent.findFile(((KtFile)this.$psiFile).getName());
                    if (psiFile2 == null) {
                        throw new IllegalStateException("Lost file after move".toString());
                    }
                    PsiFile file2 = psiFile2;
                    return (KtFile)file2;
                }
            }));
        }
        KotlinMoveTarget moveTarget2 = kotlinMoveTarget;
        KotlinMoveSource.File file2 = KotlinMoveSourceKt.KotlinMoveSource((KtFile)psiFile2);
        KotlinMoveDeclarationDelegate.TopLevel topLevel = KotlinMoveDeclarationDelegate.TopLevel.INSTANCE;
        List<PsiElement> list2 = MoveUtilKt.getAllElementsToMove((KtFile)psiFile2);
        return new MoveKotlinDeclarationsProcessor(new MoveDeclarationsDescriptor(project3, file2, moveTarget2, topLevel, searchInCommentsAndStrings, searchInNonCode, false, null, false, list2, withConflicts, false, 2496, null), null, false, 6, null);
    }

    public static /* synthetic */ MoveKotlinDeclarationsProcessor initMoveProcessor$default(MoveKotlinFileHandler moveKotlinFileHandler, PsiFile psiFile2, PsiDirectory psiDirectory, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        return moveKotlinFileHandler.initMoveProcessor(psiFile2, psiDirectory, bl, bl2, bl3);
    }

    public boolean canProcessElement(@Nullable PsiFile element3) {
        if (element3 instanceof PsiCompiledElement || !(element3 instanceof KtFile)) {
            return false;
        }
        return !ProjectRootUtilsKt.isOutsideKotlinAwareSourceRoot(element3);
    }

    @NotNull
    public List<UsageInfo> findUsages(@NotNull PsiFile psiFile2, @Nullable PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        return this.findUsages(psiFile2, newParent, true, searchInComments, searchInNonJavaFiles);
    }

    @NotNull
    public final List<UsageInfo> findUsages(@NotNull PsiFile psiFile2, @Nullable PsiDirectory newParent, boolean withConflicts, boolean searchInCommentsAndStrings, boolean searchInNonJavaFiles) {
        ArrayList usages2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
            if (!(psiFile2 instanceof KtFile)) {
                return CollectionsKt.emptyList();
            }
            Object[] objectArray = new UsageInfo[]{new FileInfo((KtFile)psiFile2)};
            usages2 = CollectionsKt.arrayListOf((Object[])objectArray);
            MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor = this.initMoveProcessor(psiFile2, newParent, withConflicts, searchInCommentsAndStrings, searchInNonJavaFiles);
            if (moveKotlinDeclarationsProcessor == null) break block1;
            MoveKotlinDeclarationsProcessor it = moveKotlinDeclarationsProcessor;
            boolean bl = false;
            CollectionsKt.addAll((Collection)usages2, (Object[])it.findUsages());
            CollectionsKt.addAll((Collection)usages2, (Iterable)it.getConflictsAsUsages());
        }
        return usages2;
    }

    public void prepareMovedFile(@NotNull PsiFile file2, @NotNull PsiDirectory moveDestination, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)moveDestination, (String)"moveDestination");
        Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
        if (!(file2 instanceof KtFile)) {
            return;
        }
        MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor = MoveKotlinFileHandler.initMoveProcessor$default(this, file2, moveDestination, false, false, false, 24, null);
        if (moveKotlinDeclarationsProcessor == null) {
            return;
        }
        MoveKotlinDeclarationsProcessor moveProcessor = moveKotlinDeclarationsProcessor;
        MoveContext moveContext = new MoveContext(file2, moveProcessor);
        oldToNewMap.put((PsiElement)moveContext, (PsiElement)moveContext);
        MoveContainerChangeInfo moveContainerChangeInfo = this.getPackageNameInfo((KtFile)file2, moveDestination, true);
        if (moveContainerChangeInfo == null) {
            return;
        }
        MoveContainerChangeInfo packageNameInfo = moveContainerChangeInfo;
        FqName newFqName = packageNameInfo.getNewContainer().getFqName();
        if (newFqName != null) {
            KtPackageDirective ktPackageDirective = ((KtFile)file2).getPackageDirective();
            if (ktPackageDirective != null) {
                ktPackageDirective.setFqName(FqNameUtils.quoteIfNeeded(newFqName));
            }
        }
    }

    public void updateMovedFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
    }

    public void retargetUsages(@Nullable List<? extends UsageInfo> usageInfos, @NotNull Map<PsiElement, ? extends PsiElement> oldToNewMap) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
            List<? extends UsageInfo> list2 = usageInfos;
            UsageInfo usageInfo = list2 != null ? (UsageInfo)CollectionsKt.firstOrNull(list2) : null;
            FileInfo fileInfo = usageInfo instanceof FileInfo ? (FileInfo)usageInfo : null;
            PsiElement currentFile = fileInfo != null ? fileInfo.getElement() : null;
            Iterable $this$firstOrNull$iv = oldToNewMap.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof MoveContext && Intrinsics.areEqual((Object)((MoveContext)it).getFile(), (Object)currentFile))) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        Object var6_11 = v2;
        MoveContext moveContext = var6_11 instanceof MoveContext ? (MoveContext)var6_11 : null;
        if (moveContext == null) {
            return;
        }
        MoveContext moveContext2 = moveContext;
        this.retargetUsages(usageInfos, moveContext2.getDeclarationMoveProcessor());
    }

    public final void retargetUsages(@Nullable List<? extends UsageInfo> usageInfos, @NotNull MoveKotlinDeclarationsProcessor moveDeclarationsProcessor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)moveDeclarationsProcessor), (String)"moveDeclarationsProcessor");
            List<? extends UsageInfo> list2 = usageInfos;
            if (list2 == null) break block0;
            List<? extends UsageInfo> it = list2;
            boolean bl = false;
            moveDeclarationsProcessor.doPerformRefactoring$kotlin_idea(it);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$FileInfo;", "Lcom/intellij/usageView/UsageInfo;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "kotlin.idea"})
    public static final class FileInfo
    extends UsageInfo {
        public FileInfo(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super((PsiFile)file2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$MoveContext;", "Lcom/intellij/psi/impl/light/LightElement;", "file", "Lcom/intellij/psi/PsiFile;", "declarationMoveProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;)V", "getDeclarationMoveProcessor", "()Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "toString", "", "kotlin.idea"})
    private static final class MoveContext
    extends LightElement {
        @NotNull
        private final PsiFile file;
        @NotNull
        private final MoveKotlinDeclarationsProcessor declarationMoveProcessor;

        public MoveContext(@NotNull PsiFile file2, @NotNull MoveKotlinDeclarationsProcessor declarationMoveProcessor) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)declarationMoveProcessor), (String)"declarationMoveProcessor");
            super(file2.getManager(), (Language)KotlinLanguage.INSTANCE);
            this.file = file2;
            this.declarationMoveProcessor = declarationMoveProcessor;
        }

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }

        @NotNull
        public final MoveKotlinDeclarationsProcessor getDeclarationMoveProcessor() {
            return this.declarationMoveProcessor;
        }

        @NotNull
        public String toString() {
            return "";
        }
    }
}

