/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticVariableRenamerKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0012\u0010\u0011\u001a\f0\u0005\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0012\u0010\u0014\u001a\f0\u0005\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0012\u0010\u0015\u001a\f0\u0005\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0002R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lcom/intellij/psi/PsiNamedElement;", "newClassName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiNamedElement;Ljava/lang/String;Ljava/util/Collection;)V", "toUnpluralize", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lkotlin/collections/ArrayList;", "canonicalNameToName", "canonicalName", "element", "entityName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogDescription", "getDialogTitle", "nameToCanonicalName", "name", "variableKind", "Lcom/intellij/psi/codeStyle/VariableKind;", "codeStyleManager", "Lcom/intellij/psi/codeStyle/JavaCodeStyleManager;", "ktElement", "Companion", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAutomaticVariableRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomaticVariableRenamer.kt\norg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,173:1\n20#2,2:174\n*S KotlinDebug\n*F\n+ 1 AutomaticVariableRenamer.kt\norg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer\n*L\n113#1:174,2\n*E\n"})
public final class AutomaticVariableRenamer
extends AutomaticRenamer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<KtNamedDeclaration> toUnpluralize;
    @NotNull
    private static final Logger LOG;

    public AutomaticVariableRenamer(@NotNull PsiNamedElement klass2, @NotNull String newClassName, @NotNull Collection<? extends UsageInfo> usages2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)newClassName, (String)"newClassName");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        this.toUnpluralize = new ArrayList();
        String string = klass2.getName();
        Intrinsics.checkNotNull((Object)string);
        String oldClassName = KotlinPsiModificationUtils.unquoteKotlinIdentifier(string);
        String newClassNameUnquoted = KotlinPsiModificationUtils.unquoteKotlinIdentifier(newClassName);
        for (UsageInfo usageInfo : usages2) {
            String variableName;
            KtCallableDeclaration parameterOrVariable;
            PsiElement usageElement;
            if (usageInfo.getElement() == null) continue;
            Class[] classArray = new Class[]{KtVariableDeclaration.class, KtParameter.class};
            if ((KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])classArray) == null || parameterOrVariable.getName() == null || StringsKt.equals((String)variableName, (String)newClassNameUnquoted, (boolean)true) || !StringUtil.containsIgnoreCase((String)variableName, (String)oldClassName)) continue;
            if (AutomaticVariableRenamerKt.access$isCollectionLikeOf(parameterOrVariable, klass2)) {
                this.toUnpluralize.add((KtNamedDeclaration)parameterOrVariable);
            }
            this.myElements.add(parameterOrVariable);
        }
        this.suggestAllNames(oldClassName, newClassNameUnquoted);
    }

    @NotNull
    public String getDialogTitle() {
        String string = JavaRefactoringBundle.message((String)"rename.variables.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDialogDescription() {
        String string = JavaRefactoringBundle.message((String)"title.rename.variables.with.the.following.names.to", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String entityName() {
        String string = JavaRefactoringBundle.message((String)"entity.name.variable", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String nameToCanonicalName(@NotNull String name2, @NotNull PsiNamedElement element3) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof KtNamedDeclaration)) {
            return name2;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)((KtNamedDeclaration)element3).getProject());
        Intrinsics.checkNotNull((Object)codeStyleManager);
        VariableKind kind2 = this.variableKind(codeStyleManager, (KtNamedDeclaration)element3);
        String string = kind2 != null ? codeStyleManager.variableNameToPropertyName(name2, kind2) : name2;
        Intrinsics.checkNotNull((Object)string);
        String propertyName = string;
        if (this.toUnpluralize.contains(element3)) {
            String singular = StringUtil.unpluralize((String)propertyName);
            if (singular != null) {
                return singular;
            }
            this.toUnpluralize.remove(element3);
        }
        return propertyName;
    }

    @NotNull
    protected String canonicalNameToName(@NotNull String canonicalName, @NotNull PsiNamedElement element3) {
        String string;
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof KtNamedDeclaration)) {
            return canonicalName;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)((KtNamedDeclaration)element3).getProject());
        Intrinsics.checkNotNull((Object)codeStyleManager);
        VariableKind kind2 = this.variableKind(codeStyleManager, (KtNamedDeclaration)element3);
        String string2 = kind2 != null ? codeStyleManager.propertyNameToVariableName(canonicalName, kind2) : canonicalName;
        Intrinsics.checkNotNull((Object)string2);
        String varName = string2;
        if (this.toUnpluralize.contains(element3)) {
            String string3 = StringUtil.pluralize((String)varName);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pluralize(...)");
        } else {
            string = varName;
        }
        return string;
    }

    private final VariableKind variableKind(JavaCodeStyleManager codeStyleManager, KtNamedDeclaration ktElement) {
        PsiVariable psiVariable;
        Object v0;
        block3: {
            if (ktElement instanceof KtProperty && ((KtProperty)ktElement).isTopLevel() && !ktElement.hasModifier(KtTokens.CONST_KEYWORD)) {
                return null;
            }
            if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)ktElement)) instanceof KtObjectDeclaration) {
                return null;
            }
            Iterable $this$firstIsInstanceOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)ktElement));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof PsiVariable)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PsiVariable psiVariable2 = psiVariable = (PsiVariable)v0;
        return psiVariable2 != null ? codeStyleManager.getVariableKind(psiVariable2) : null;
    }

    static {
        Logger logger = Logger.getInstance(AutomaticVariableRenamer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.refactorings.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

