/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinSafeDeleteOverridingUsageInfo;

class KotlinOverridingDialog
extends DialogWrapper {
    private final List<UsageInfo> myOverridingMethods;
    private final String[] myMethodText;
    private final boolean[] myChecked;
    private static final int CHECK_COLUMN = 0;
    private JBTable myTable;
    private final UsagePreviewPanel myUsagePreviewPanel;

    KotlinOverridingDialog(Project project2, List<UsageInfo> overridingMethods) {
        super(project2, true);
        this.myOverridingMethods = overridingMethods;
        this.myChecked = new boolean[this.myOverridingMethods.size()];
        Arrays.fill(this.myChecked, true);
        this.myMethodText = new String[this.myOverridingMethods.size()];
        for (int i2 = 0; i2 < this.myMethodText.length; ++i2) {
            this.myMethodText[i2] = HtmlChunk.html().addRaw(ElementDescriptionUtil.getElementDescription((PsiElement)((KotlinSafeDeleteOverridingUsageInfo)this.myOverridingMethods.get(i2)).getOverridingElement(), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)).toString();
        }
        this.myUsagePreviewPanel = new UsagePreviewPanel(project2, new UsageViewPresentation());
        this.setTitle(KotlinBundle.message("override.declaration.unused.overriding.methods.title", new Object[0]));
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinOverridingDialog";
    }

    @NotNull
    public List<UsageInfo> getSelected() {
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (int i2 = 0; i2 < this.myChecked.length; ++i2) {
            if (!this.myChecked[i2]) continue;
            result2.add(this.myOverridingMethods.get(i2));
        }
        ArrayList<UsageInfo> arrayList = result2;
        if (arrayList == null) {
            KotlinOverridingDialog.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            KotlinOverridingDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.safeDelete.overridingMethods");
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(new JLabel(KotlinBundle.message("override.declaration.unused.overriding.methods.description", new Object[0])));
        panel2.add(new JLabel(KotlinBundle.message("override.declaration.choose.to.delete", new Object[0])));
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 0, 4, 0));
        final MyTableModel tableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setShowGrid(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        int checkBoxWidth = new JCheckBox().getPreferredSize().width;
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        columnModel.getColumn(0).setMaxWidth(checkBoxWidth);
        columnModel.getColumn(0).setMinWidth(checkBoxWidth);
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KotlinOverridingDialog.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = KotlinOverridingDialog.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (KotlinOverridingDialog.this.myChecked[row]) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        KotlinOverridingDialog.this.myChecked[row] = valueToBeSet;
                    }
                    tableModel.updateData();
                }
            }
        });
        panel2.setLayout(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        panel2.add((Component)scrollPane, "Center");
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = KotlinOverridingDialog.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (index != -1) {
                    UsageInfo usageInfo = KotlinOverridingDialog.this.myOverridingMethods.get(index);
                    KotlinOverridingDialog.this.myUsagePreviewPanel.updateLayout(Collections.singletonList(usageInfo));
                } else {
                    KotlinOverridingDialog.this.myUsagePreviewPanel.updateLayout(null);
                }
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
        final Splitter splitter = new Splitter(true, 0.3f);
        splitter.setFirstComponent((JComponent)panel2);
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        this.myUsagePreviewPanel.updateLayout(null);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
        if (tableModel.getRowCount() != 0) {
            this.myTable.getSelectionModel().addSelectionInterval(0, 0);
        }
        return splitter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/idea/refactoring/safeDelete/KotlinOverridingDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return KotlinOverridingDialog.this.myChecked.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return " ";
            }
            return KotlinBundle.message("override.declaration.member", new Object[0]);
        }

        public Class getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return KotlinOverridingDialog.this.myChecked[rowIndex];
            }
            return KotlinOverridingDialog.this.myMethodText[rowIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                KotlinOverridingDialog.this.myChecked[rowIndex] = (Boolean)aValue;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        void updateData() {
            this.fireTableDataChanged();
        }
    }
}

