/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.util.Query;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0006\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0006\u00a8\u0006\u0011"}, d2={"addParameter", "", "method", "Lcom/intellij/psi/PsiMethod;", "result", "", "Lcom/intellij/psi/PsiElement;", "parameter", "Lcom/intellij/psi/PsiParameter;", "checkParametersInMethodHierarchy", "", "collectParametersHierarchy", "", "canDeleteElement", "", "cleanUpOverrides", "removeOverrideModifier", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/refactoring/safeDelete/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1282#2,2:114\n3792#2:119\n4307#2,2:120\n1224#3,2:116\n77#4:118\n1855#5,2:122\n766#5:124\n857#5,2:125\n1855#5,2:127\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/refactoring/safeDelete/UtilsKt\n*L\n47#1:114,2\n93#1:119\n93#1:120,2\n58#1:116,2\n71#1:118\n94#1:122,2\n96#1:124\n96#1:125,2\n97#1:127,2\n*E\n"})
public final class UtilsKt {
    public static final boolean canDeleteElement(@NotNull PsiElement $this$canDeleteElement) {
        Intrinsics.checkNotNullParameter((Object)$this$canDeleteElement, (String)"<this>");
        if ($this$canDeleteElement instanceof KtObjectDeclaration && ((KtObjectDeclaration)$this$canDeleteElement).isObjectLiteral()) {
            return false;
        }
        if ($this$canDeleteElement instanceof KtParameter) {
            PsiElement psiElement2 = ((KtParameter)$this$canDeleteElement).getParent();
            KtParameterList ktParameterList = psiElement2 instanceof KtParameterList ? (KtParameterList)psiElement2 : null;
            if (ktParameterList == null) {
                return false;
            }
            KtParameterList parameterList2 = ktParameterList;
            PsiElement psiElement3 = parameterList2.getParent();
            KtDeclaration ktDeclaration2 = psiElement3 instanceof KtDeclaration ? (KtDeclaration)psiElement3 : null;
            if (ktDeclaration2 == null) {
                return false;
            }
            KtDeclaration declaration2 = ktDeclaration2;
            return !(declaration2 instanceof KtPropertyAccessor);
        }
        return $this$canDeleteElement instanceof KtClassOrObject || $this$canDeleteElement instanceof KtSecondaryConstructor || $this$canDeleteElement instanceof KtNamedFunction || $this$canDeleteElement instanceof PsiMethod || $this$canDeleteElement instanceof PsiClass || $this$canDeleteElement instanceof KtProperty || $this$canDeleteElement instanceof KtTypeParameter || $this$canDeleteElement instanceof KtTypeAlias;
    }

    public static final void removeOverrideModifier(@NotNull PsiElement $this$removeOverrideModifier) {
        Intrinsics.checkNotNullParameter((Object)$this$removeOverrideModifier, (String)"<this>");
        PsiElement psiElement2 = $this$removeOverrideModifier;
        if (psiElement2 instanceof KtNamedFunction ? true : psiElement2 instanceof KtProperty) {
            KtModifierList ktModifierList = ((KtModifierListOwner)$this$removeOverrideModifier).getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) != null) {
                ktModifierList.delete();
            }
        } else if (psiElement2 instanceof PsiMethod) {
            Object object;
            block6: {
                PsiAnnotation[] psiAnnotationArray = ((PsiMethod)$this$removeOverrideModifier).getModifierList().getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                Object[] $this$firstOrNull$iv = psiAnnotationArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiAnnotation annotation = (PsiAnnotation)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    object = element$iv;
                    break block6;
                }
                object = null;
            }
            PsiAnnotation psiAnnotation = (PsiAnnotation)object;
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }
    }

    public static final void cleanUpOverrides(@NotNull PsiMethod $this$cleanUpOverrides) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanUpOverrides, (String)"<this>");
        Object[] objectArray = $this$cleanUpOverrides.findSuperMethods(true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findSuperMethods(...)");
        Object[] superMethods = objectArray;
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)$this$cleanUpOverrides, (boolean)true).findAll()) {
            boolean bl;
            block2: {
                Sequence currentSuperMethods;
                PsiMethod[] psiMethodArray = overridingMethod.findSuperMethods(true);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
                Sequence $this$all$iv = currentSuperMethods = SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])psiMethodArray), (Sequence)ArraysKt.asSequence((Object[])superMethods));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    PsiMethod superMethod = (PsiMethod)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)superMethod);
                    if (Intrinsics.areEqual((Object)LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)superMethod)), (Object)LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$cleanUpOverrides)))) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            Intrinsics.checkNotNull((Object)overridingMethod);
            PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)overridingMethod));
            if (psiElement2 == null) continue;
            UtilsKt.removeOverrideModifier(psiElement2);
        }
    }

    @Nullable
    public static final Collection<PsiElement> checkParametersInMethodHierarchy(@NotNull PsiParameter parameter2) {
        Collection parametersToDelete2;
        PsiMethod method;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
                PsiElement psiElement2 = parameter2.getDeclarationScope();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                method = (PsiMethod)psiElement2;
                ProgressManager progressManager = ProgressManager.getInstance();
                ThrowableComputable throwableComputable = () -> UtilsKt.checkParametersInMethodHierarchy$lambda$2(method, parameter2);
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)parameter2.getName(), (String)"getName(...)");
                parametersToDelete2 = (Collection)progressManager.runProcessWithProgressSynchronously(throwableComputable, KotlinBundle.message("progress.title.collect.hierarchy", objectArray), true, parameter2.getProject());
                if (parametersToDelete2 == null || parametersToDelete2.size() <= 1) break block2;
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block3;
            }
            return parametersToDelete2;
        }
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)method), (ElementDescriptionLocation)((ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT)), (String)"getElementDescription(...)");
        String message2 = KotlinBundle.message("override.declaration.delete.multiple.parameters", objectArray);
        int exitCode = Messages.showOkCancelDialog((Project)parameter2.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? parametersToDelete2 : null;
    }

    private static final Set<PsiElement> collectParametersHierarchy(PsiMethod method, PsiParameter parameter2) {
        ArrayDeque<PsiMethod> queue = new ArrayDeque<PsiMethod>();
        HashSet visited = new HashSet();
        HashSet parametersToDelete2 = new HashSet();
        queue.add(method);
        while (!queue.isEmpty()) {
            Iterable $this$forEach$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            PsiMethod currentMethod = (PsiMethod)queue.poll();
            ((Collection)visited).add(currentMethod);
            Intrinsics.checkNotNull((Object)currentMethod);
            UtilsKt.addParameter(currentMethod, parametersToDelete2, parameter2);
            PsiMethod[] psiMethodArray = currentMethod.findSuperMethods(true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            Object[] objectArray = psiMethodArray;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                queue.offer(it);
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)currentMethod);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
            $this$forEach$iv = (Iterable)query;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object element$iv$iv = bl.next();
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl2 = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl3 = false;
                queue.offer(it);
            }
        }
        return parametersToDelete2;
    }

    private static final void addParameter(PsiMethod method, Set<PsiElement> result2, PsiParameter parameter2) {
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)parameter2));
        Intrinsics.checkNotNull((Object)psiElement2);
        int parameterIndex2 = KtPsiUtilKt.parameterIndex((PsiElement)psiElement2);
        if (method instanceof KtLightMethod) {
            KtDeclaration declaration2 = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
            if (declaration2 instanceof KtFunction) {
                Object e = ((KtFunction)declaration2).getValueParameters().get(parameterIndex2);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                result2.add((PsiElement)e);
            }
        } else {
            PsiParameter psiParameter = method.getParameterList().getParameters()[parameterIndex2];
            Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"get(...)");
            result2.add((PsiElement)psiParameter);
        }
    }

    private static final Collection checkParametersInMethodHierarchy$lambda$2(PsiMethod $method, PsiParameter $parameter) {
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)$parameter, (String)"$parameter");
        return (Collection)ActionsKt.runReadAction((Function0)((Function0)new Function0<Set<? extends PsiElement>>($method, $parameter){
            final /* synthetic */ PsiMethod $method;
            final /* synthetic */ PsiParameter $parameter;
            {
                this.$method = $method;
                this.$parameter = $parameter;
                super(0);
            }

            @NotNull
            public final Set<PsiElement> invoke() {
                return UtilsKt.access$collectParametersHierarchy(this.$method, this.$parameter);
            }
        }));
    }

    public static final /* synthetic */ Set access$collectParametersHierarchy(PsiMethod method, PsiParameter parameter2) {
        return UtilsKt.collectParametersHierarchy(method, parameter2);
    }
}

