/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.BaseGlobalFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/KotlinNonSourceRootIndexFilter;", "Lcom/intellij/util/indexing/hints/BaseGlobalFileTypeInputFilter;", "()V", "enabled", "", "affectsIndex", "indexId", "Lcom/intellij/util/indexing/IndexId;", "getFileTypeHintForAffectedIndex", "Lcom/intellij/util/indexing/hints/BaseFileTypeInputFilter;", "getVersion", "", "kotlin.core"})
public final class KotlinNonSourceRootIndexFilter
extends BaseGlobalFileTypeInputFilter {
    private final boolean enabled = !Boolean.parseBoolean(System.getProperty("kotlin.index.non.source.roots", "false"));

    public KotlinNonSourceRootIndexFilter() {
        super(false, 1, null);
    }

    @NotNull
    protected BaseFileTypeInputFilter getFileTypeHintForAffectedIndex(@NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        FileTypeSubstitutionStrategy fileTypeSubstitutionStrategy = FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION;
        return new BaseFileTypeInputFilter(indexId, fileTypeSubstitutionStrategy){
            final /* synthetic */ IndexId<?, ?> $indexId;
            {
                this.$indexId = $indexId;
                super($super_call_param$1);
            }

            @NotNull
            public ThreeState acceptFileType(@NotNull FileType fileType) {
                Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
                return Intrinsics.areEqual((Object)fileType, (Object)KotlinFileType.INSTANCE) ? ThreeState.UNSURE : ThreeState.YES;
            }

            public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                VirtualFile virtualFile2 = file2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                return !this.isExcludedFromIndex(virtualFile2, this.$indexId, file2.getProject());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isExcludedFromIndex(VirtualFile virtualFile2, IndexId<?, ?> indexId, Project project2) {
                if (project2 == null) return false;
                CharSequence charSequence = virtualFile2.getNameSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
                if (!StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) return false;
                if ((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(project2, virtualFile2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.$project = $project;
                        this.$virtualFile = $virtualFile;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return !ProjectFileIndex.getInstance((Project)this.$project).isInSource(this.$virtualFile);
                    }
                })) == false) return false;
                return true;
            }
        };
    }

    public int getVersion() {
        return 0;
    }

    public boolean affectsIndex(@NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        return this.enabled && indexId != TrigramIndex.INDEX_ID && indexId != FilenameIndex.NAME;
    }
}

