/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j;

import java.io.Serializable;

public final class ValueWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ValueWrapper nullValueWrapper = new ValueWrapper(null);
    private final Serializable value;
    private final Class<?> type;
    private final String stringRepresentation;
    private final int identityHashCode;
    private final transient Object ephemeralValue;

    public static ValueWrapper create(Object value2) {
        if (value2 instanceof ValueWrapper) {
            return (ValueWrapper)value2;
        }
        return value2 == null ? nullValueWrapper : new ValueWrapper(value2);
    }

    public static ValueWrapper create(Object value2, String stringRepresentation) {
        if (value2 instanceof ValueWrapper) {
            ValueWrapper wrapper = (ValueWrapper)value2;
            return wrapper.stringRepresentation.equals(stringRepresentation) ? wrapper : ValueWrapper.create(wrapper.value, stringRepresentation);
        }
        return value2 == null ? nullValueWrapper : new ValueWrapper(value2, stringRepresentation);
    }

    private ValueWrapper(Object value2, String stringRepresentation) {
        this.value = value2 instanceof Serializable ? (Serializable)value2 : null;
        this.type = value2 != null ? value2.getClass() : null;
        this.stringRepresentation = stringRepresentation == null ? ValueWrapper.safeValueToString(value2) : stringRepresentation;
        this.identityHashCode = System.identityHashCode(value2);
        this.ephemeralValue = value2;
    }

    private ValueWrapper(Object value2) {
        this(value2, ValueWrapper.safeValueToString(value2));
    }

    private static String safeValueToString(Object value2) {
        try {
            return String.valueOf(value2);
        }
        catch (Exception e) {
            return "<Exception in toString(): " + e + ">";
        }
    }

    public Serializable getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public Object getEphemeralValue() {
        return this.ephemeralValue;
    }

    public String toString() {
        if (this.type == null) {
            return "null";
        }
        return this.stringRepresentation + " (" + this.type.getName() + "@" + Integer.toHexString(this.identityHashCode) + ")";
    }
}

