/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitUtil {
    @NonNls
    public static final String DOT_GIT = ".git";
    @NonNls
    public static final String COMMENT_CHAR = "\u0001";
    @NonNls
    public static final String ORIGIN_HEAD = "origin/HEAD";
    @NlsSafe
    public static final String HEAD = "HEAD";
    @NonNls
    public static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    @NonNls
    public static final String MERGE_HEAD = "MERGE_HEAD";
    @NonNls
    public static final String REBASE_HEAD = "REBASE_HEAD";
    @NonNls
    private static final String REPO_PATH_LINK_PREFIX = "gitdir:";
    private static final Logger LOG = Logger.getInstance(GitUtil.class);
    @NonNls
    private static final String HEAD_FILE = "HEAD";
    private static final Pattern HASH_STRING_PATTERN = Pattern.compile("[a-fA-F0-9]{40}");

    private GitUtil() {
    }

    @Nullable
    public static VirtualFile findGitDir(@NotNull VirtualFile rootDir) {
        VirtualFile dotGit;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(0);
        }
        if ((dotGit = VfsUtil.refreshAndFindChild((VirtualFile)rootDir, (String)DOT_GIT)) == null) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = VfsUtil.refreshAndFindChild((VirtualFile)dotGit, (String)"HEAD") != null;
            return headExists ? dotGit : null;
        }
        String content = GitUtil.readContent(dotGit);
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        if (pathToDir == null) {
            return null;
        }
        File file2 = GitUtil.findRealRepositoryDir(rootDir.toNioPath(), pathToDir);
        if (file2 == null) {
            return null;
        }
        return VcsUtil.getVirtualFileWithRefresh((File)file2);
    }

    @Nullable
    private static File findRealRepositoryDir(@NotNull @NonNls Path rootPath, @NotNull @NonNls String path) {
        File file2;
        if (rootPath == null) {
            GitUtil.$$$reportNull$$$0(1);
        }
        if (path == null) {
            GitUtil.$$$reportNull$$$0(2);
        }
        if (!FileUtil.isAbsolute((String)path)) {
            String canonicalPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{rootPath.toString(), path}), (boolean)true);
            path = FileUtil.toSystemIndependentName((String)canonicalPath);
        }
        return (file2 = new File(path)).isDirectory() ? file2 : null;
    }

    @Nullable
    private static String parsePathToRepository(@NotNull @NonNls String content) {
        if (content == null) {
            GitUtil.$$$reportNull$$$0(3);
        }
        if ((content = content.trim()).startsWith(REPO_PATH_LINK_PREFIX)) {
            content = content.substring(REPO_PATH_LINK_PREFIX.length()).trim();
        }
        if (content.isEmpty() || content.contains("\n")) {
            return null;
        }
        return content;
    }

    @Nullable
    private static String readContent(@NotNull VirtualFile dotGit) {
        String content;
        if (dotGit == null) {
            GitUtil.$$$reportNull$$$0(4);
        }
        try {
            content = GitUtil.readFile(dotGit);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the content of " + dotGit, (Throwable)e);
            return null;
        }
        return content;
    }

    @NotNull
    private static String readFile(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            GitUtil.$$$reportNull$$$0(5);
        }
        int ATTEMPTS = 3;
        int attempt = 1;
        while (true) {
            try {
                return new String(file2.contentsToByteArray(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.info(String.format("IOException while reading %s (attempt #%s)", file2, attempt));
                if (attempt++ < 3) continue;
                throw e;
            }
            break;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(6);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return GitUtil.sortFilesByGitRoot(project, virtualFiles, false);
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRootIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(8);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        try {
            return GitUtil.sortFilesByGitRoot(project, filePaths, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            Map<VirtualFile, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitUtil.$$$reportNull$$$0(10);
            }
            return map2;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(11);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return GitUtil.sortFilePathsByGitRoot(project, filePaths, false);
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRootIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(13);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        try {
            return GitUtil.sortFilePathsByGitRoot(project, filePaths, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            Map<VirtualFile, List<FilePath>> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitUtil.$$$reportNull$$$0(15);
            }
            return map2;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    private static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(16);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        Map<GitRepository, List<VirtualFile>> map2 = GitUtil.sortFilesByRepository(project, virtualFiles, ignoreNonGit);
        HashMap<VirtualFile, List<VirtualFile>> result2 = new HashMap<VirtualFile, List<VirtualFile>>();
        map2.forEach((repo, files) -> result2.put(repo.getRoot(), (List<VirtualFile>)files));
        HashMap<VirtualFile, List<VirtualFile>> hashMap = result2;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<GitRepository, List<VirtualFile>> sortFilesByRepository(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filePaths) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(19);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return GitUtil.sortFilesByRepository(project, filePaths, false);
    }

    @RequiresBackgroundThread
    @NotNull
    public static Map<GitRepository, List<VirtualFile>> sortFilesByRepositoryIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(21);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        try {
            return GitUtil.sortFilesByRepository(project, virtualFiles, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            Map<GitRepository, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitUtil.$$$reportNull$$$0(23);
            }
            return map2;
        }
    }

    @RequiresBackgroundThread
    @NotNull
    private static Map<GitRepository, List<VirtualFile>> sortFilesByRepository(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(24);
        }
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        GitRepositoryManager manager2 = GitRepositoryManager.getInstance(project);
        HashMap<GitRepository, List<VirtualFile>> result2 = new HashMap<GitRepository, List<VirtualFile>>();
        for (VirtualFile virtualFile : virtualFiles) {
            VirtualFile actualFile = virtualFile.isDirectory() ? virtualFile.getParent() : virtualFile;
            GitRepository repository = (GitRepository)manager2.getRepositoryForFile(actualFile);
            if (repository == null) {
                if (ignoreNonGit) continue;
                throw new GitRepositoryNotFoundException(virtualFile);
            }
            List files = result2.computeIfAbsent(repository, key -> new ArrayList());
            files.add(virtualFile);
        }
        HashMap<GitRepository, List<VirtualFile>> hashMap = result2;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(26);
        }
        return hashMap;
    }

    @NotNull
    private static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths, boolean ignoreNonGit) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(27);
        }
        if (filePaths == null) {
            GitUtil.$$$reportNull$$$0(28);
        }
        ProjectLevelVcsManager manager2 = ProjectLevelVcsManager.getInstance((Project)project);
        GitVcs gitVcs = GitVcs.getInstance(project);
        HashMap<VirtualFile, List<FilePath>> result2 = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath filePath : filePaths) {
            AbstractVcs vcs;
            VcsRoot vcsRoot = manager2.getVcsRootObjectFor(filePath);
            AbstractVcs abstractVcs = vcs = vcsRoot != null ? vcsRoot.getVcs() : null;
            if (vcs == null || !vcs.equals((Object)gitVcs)) {
                if (ignoreNonGit) continue;
                throw new GitRepositoryNotFoundException(filePath);
            }
            List paths = result2.computeIfAbsent(vcsRoot.getPath(), key -> new ArrayList());
            paths.add(filePath);
        }
        HashMap<VirtualFile, List<FilePath>> hashMap = result2;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(29);
        }
        return hashMap;
    }

    public static Date parseTimestamp(@NonNls String value) {
        long parsed = Long.parseLong(value.trim());
        return new Date(parsed * 1000L);
    }

    public static Date parseTimestampWithNFEReport(@NonNls String value, GitHandler handler, String gitOutput) {
        try {
            return GitUtil.parseTimestamp(value);
        }
        catch (NumberFormatException e) {
            LOG.error("annotate(). NFE. Handler: " + handler + ". Output: " + gitOutput, (Throwable)e);
            return new Date();
        }
    }

    @ApiStatus.Obsolete
    @Nullable
    public static VirtualFile findGitRootFor(@NotNull Path path) {
        if (path == null) {
            GitUtil.$$$reportNull$$$0(30);
        }
        try {
            for (Path root = path; root != null; root = root.getParent()) {
                if (!GitUtil.isGitRoot(root)) continue;
                return LocalFileSystem.getInstance().findFileByNioFile(root);
            }
            return null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    @Deprecated
    public static boolean isGitRoot(@NotNull File folder) {
        if (folder == null) {
            GitUtil.$$$reportNull$$$0(31);
        }
        try {
            return GitUtil.isGitRoot(folder.toPath());
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @ApiStatus.Obsolete
    public static boolean isUnderGit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            GitUtil.$$$reportNull$$$0(32);
        }
        try {
            return GitUtil.findGitRootFor(vFile.toNioPath()) != null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @ApiStatus.Obsolete
    public static boolean isUnderGit(@NotNull FilePath path) {
        if (path == null) {
            GitUtil.$$$reportNull$$$0(33);
        }
        try {
            return GitUtil.findGitRootFor(Paths.get(path.getPath(), new String[0])) != null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @NlsSafe
    public static String adjustAuthorName(@NlsSafe String authorName, @NlsSafe String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = GitBundle.message("commit.author.with.committer", authorName, committerName);
        }
        return committerName;
    }

    @RequiresBackgroundThread
    @NotNull
    public static Set<GitRepository> getRepositoriesForFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(34);
        }
        if (files == null) {
            GitUtil.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        HashSet<GitRepository> result2 = new HashSet<GitRepository>();
        for (VirtualFile virtualFile : files) {
            result2.add(GitUtil.getRepositoryForFile(project, virtualFile));
        }
        HashSet<GitRepository> hashSet = result2;
        if (hashSet == null) {
            GitUtil.$$$reportNull$$$0(36);
        }
        return hashSet;
    }

    @NonNls
    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    @NonNls
    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier, Consumer<? super GitCommittedChangeList> consumer2, boolean skipDiffsForMerge) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters("--pretty=format:%x04%x01%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        LOG.debug("getLocalCommittedChanges output: '" + output + "'");
        StringScanner s = new StringScanner(output);
        StringBuilder sb = new StringBuilder();
        boolean firstStep = true;
        while (s.hasMoreData()) {
            String line = s.line();
            boolean lineIsAStart = line.startsWith("\u0004\u0001");
            if (!firstStep && lineIsAStart) {
                StringScanner innerScanner = new StringScanner(sb.toString());
                sb.setLength(0);
                consumer2.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
            }
            sb.append(lineIsAStart ? line.substring(2) : line).append('\n');
            firstStep = false;
        }
        if (sb.length() > 0) {
            StringScanner innerScanner = new StringScanner(sb.toString());
            sb.setLength(0);
            consumer2.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is available: " + s.line());
        }
    }

    public static List<GitCommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier) throws VcsException {
        ArrayList<GitCommittedChangeList> rc = new ArrayList<GitCommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, (Consumer<? super GitCommittedChangeList>)((Consumer)committedChangeList -> rc.add((GitCommittedChangeList)((Object)committedChangeList))), false);
        return rc;
    }

    @NotNull
    public static String unescapePath(@NotNull @NonNls String path) throws VcsException {
        String string;
        if (path == null) {
            GitUtil.$$$reportNull$$$0(37);
        }
        try {
            string = VcsFileUtil.unescapeGitPath((String)path);
        }
        catch (IllegalStateException e) {
            throw new VcsException((Throwable)e);
        }
        if (string == null) {
            GitUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static boolean justOneGitRepository(Project project) {
        if (project.isDisposed()) {
            return true;
        }
        GitRepositoryManager manager2 = GitUtil.getRepositoryManager(project);
        return !manager2.moreThanOneRoot();
    }

    @Nullable
    public static GitRemote findRemoteByName(@NotNull GitRepository repository, @NotNull @NonNls String name) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            GitUtil.$$$reportNull$$$0(40);
        }
        return GitUtil.findRemoteByName(repository.getRemotes(), name);
    }

    @Nullable
    public static GitRemote findRemoteByName(Collection<GitRemote> remotes, @NotNull @NonNls String name) {
        if (name == null) {
            GitUtil.$$$reportNull$$$0(41);
        }
        return (GitRemote)ContainerUtil.find(remotes, remote -> remote.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull @NonNls String nameAtRemote) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(42);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(43);
        }
        if (nameAtRemote == null) {
            GitUtil.$$$reportNull$$$0(44);
        }
        return (GitRemoteBranch)ContainerUtil.find(repository.getBranches().getRemoteBranches(), remoteBranch -> remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote)));
    }

    @NotNull
    public static GitRemoteBranch findOrCreateRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull @NonNls String branchName) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(45);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(46);
        }
        if (branchName == null) {
            GitUtil.$$$reportNull$$$0(47);
        }
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, branchName));
        if (gitRemoteBranch == null) {
            GitUtil.$$$reportNull$$$0(48);
        }
        return gitRemoteBranch;
    }

    @NotNull
    public static Collection<VirtualFile> getRootsFromRepositories(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitUtil.$$$reportNull$$$0(49);
        }
        List list2 = ContainerUtil.map(repositories2, Repository::getRoot);
        if (list2 == null) {
            GitUtil.$$$reportNull$$$0(50);
        }
        return list2;
    }

    @RequiresBackgroundThread
    @NotNull
    public static Collection<GitRepository> getRepositoriesFromRoots(@NotNull GitRepositoryManager repositoryManager, @NotNull Collection<? extends VirtualFile> roots) {
        if (repositoryManager == null) {
            GitUtil.$$$reportNull$$$0(51);
        }
        if (roots == null) {
            GitUtil.$$$reportNull$$$0(52);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ArrayList<GitRepository> repositories2 = new ArrayList<GitRepository>(roots.size());
        for (VirtualFile virtualFile : roots) {
            GitRepository repo = (GitRepository)repositoryManager.getRepositoryForRoot(virtualFile);
            if (repo == null) {
                LOG.error("Repository not found for root " + virtualFile);
                continue;
            }
            repositories2.add(repo);
        }
        ArrayList<GitRepository> arrayList = repositories2;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getPathsDiffBetweenRefs(@NotNull Git git, @NotNull GitRepository repository, @NotNull @NonNls String beforeRef, @NotNull @NonNls String afterRef) throws VcsException {
        String range;
        List<String> parameters;
        GitCommandResult result2;
        if (git == null) {
            GitUtil.$$$reportNull$$$0(54);
        }
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(55);
        }
        if (beforeRef == null) {
            GitUtil.$$$reportNull$$$0(56);
        }
        if (afterRef == null) {
            GitUtil.$$$reportNull$$$0(57);
        }
        if (!(result2 = git.diff(repository, parameters = Arrays.asList("--name-only", "--pretty=format:"), range = beforeRef + ".." + afterRef)).success()) {
            LOG.info(String.format("Couldn't get diff in range [%s] for repository [%s]", range, repository.toLogString()));
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                GitUtil.$$$reportNull$$$0(58);
            }
            return list2;
        }
        HashSet<String> remoteChanges = new HashSet<String>();
        StringScanner s = new StringScanner(result2.getOutputAsJoinedString());
        while (s.hasMoreData()) {
            String relative = s.line();
            if (StringUtil.isEmptyOrSpaces((String)relative)) continue;
            String path = repository.getRoot().getPath() + "/" + GitUtil.unescapePath(relative);
            remoteChanges.add(path);
        }
        HashSet<String> hashSet = remoteChanges;
        if (hashSet == null) {
            GitUtil.$$$reportNull$$$0(59);
        }
        return hashSet;
    }

    @NotNull
    public static GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(60);
        }
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        if (gitRepositoryManager == null) {
            GitUtil.$$$reportNull$$$0(61);
        }
        return gitRepositoryManager;
    }

    @RequiresBackgroundThread
    @NotNull
    public static GitRepository getRepositoryForFile(@NotNull Project project, @NotNull VirtualFile file2) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(62);
        }
        if (file2 == null) {
            GitUtil.$$$reportNull$$$0(63);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file2);
        if (repository == null) {
            throw new GitRepositoryNotFoundException(file2);
        }
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            GitUtil.$$$reportNull$$$0(64);
        }
        return gitRepository;
    }

    @RequiresBackgroundThread
    @NotNull
    public static GitRepository getRepositoryForFile(@NotNull Project project, @NotNull FilePath file2) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(65);
        }
        if (file2 == null) {
            GitUtil.$$$reportNull$$$0(66);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file2);
        if (repository == null) {
            throw new GitRepositoryNotFoundException(file2);
        }
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            GitUtil.$$$reportNull$$$0(67);
        }
        return gitRepository;
    }

    @RequiresBackgroundThread
    @NotNull
    public static GitRepository getRepositoryForRoot(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(68);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(69);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
        if (repository == null) {
            throw new GitRepositoryNotFoundException(root);
        }
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            GitUtil.$$$reportNull$$$0(70);
        }
        return gitRepository;
    }

    @Nullable
    public static GitRepository getRepositoryForRootOrLogError(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(71);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(72);
        }
        if ((repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root)) == null) {
            LOG.error((Throwable)((Object)new GitRepositoryNotFoundException(root)));
        }
        return repository;
    }

    @NotNull
    public static VirtualFile getRootForFile(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        VcsRoot root;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(73);
        }
        if (filePath == null) {
            GitUtil.$$$reportNull$$$0(74);
        }
        if (GitUtil.isGitVcsRoot(root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(filePath))) {
            VirtualFile virtualFile = root.getPath();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(75);
            }
            return virtualFile;
        }
        Repository repository = VcsRepositoryManager.getInstance((Project)project).getExternalRepositoryForFile(filePath);
        if (repository instanceof GitRepository) {
            VirtualFile virtualFile = repository.getRoot();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(76);
            }
            return virtualFile;
        }
        throw new GitRepositoryNotFoundException(filePath);
    }

    @NotNull
    public static VirtualFile getRootForFile(@NotNull Project project, @NotNull VirtualFile file2) throws VcsException {
        VcsRoot root;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(77);
        }
        if (file2 == null) {
            GitUtil.$$$reportNull$$$0(78);
        }
        if (GitUtil.isGitVcsRoot(root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(file2))) {
            VirtualFile virtualFile = root.getPath();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(79);
            }
            return virtualFile;
        }
        Repository repository = VcsRepositoryManager.getInstance((Project)project).getExternalRepositoryForFile(file2);
        if (repository instanceof GitRepository) {
            VirtualFile virtualFile = repository.getRoot();
            if (virtualFile == null) {
                GitUtil.$$$reportNull$$$0(80);
            }
            return virtualFile;
        }
        throw new GitRepositoryNotFoundException(file2);
    }

    private static boolean isGitVcsRoot(@Nullable VcsRoot root) {
        if (root == null) {
            return false;
        }
        AbstractVcs vcs = root.getVcs();
        if (vcs == null) {
            return false;
        }
        return GitVcs.getKey().equals((Object)vcs.getKeyInstanceMethod());
    }

    public static void showSubmittedFiles(final Project project, final @NonNls String revision, final VirtualFile file2, final boolean local, final boolean revertable) {
        new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getRootForFile(project, file2);
                    GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision, true, local, revertable);
                    UIUtil.invokeLaterIfNeeded(() -> 1.lambda$run$0(project, (CommittedChangeList)changeList, revision));
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationError(project, e, GitBundle.message("operation.name.loading.revision", new Object[0])));
                }
            }

            private static /* synthetic */ void lambda$run$0(Project project2, CommittedChangeList changeList, String revision2) {
                AbstractVcsHelper.getInstance((Project)project2).showChangesListBrowser(changeList, GitBundle.message("paths.affected.title", revision2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/GitUtil$1", "run"));
            }
        }.queue();
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForCurrentBranch(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch;
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(81);
        }
        if ((currentBranch = repository.getCurrentBranch()) == null) {
            return null;
        }
        return GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
    }

    public static boolean hasLocalChanges(boolean staged, Project project, VirtualFile root) throws VcsException {
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-only");
        diff.addParameters("--no-renames");
        if (staged) {
            diff.addParameters("--cached");
        }
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        String output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        return !output.trim().isEmpty();
    }

    @Nullable
    public static VirtualFile findRefreshFileOrLog(@NotNull @NonNls String absolutePath) {
        VirtualFile file2;
        if (absolutePath == null) {
            GitUtil.$$$reportNull$$$0(82);
        }
        if ((file2 = LocalFileSystem.getInstance().findFileByPath(absolutePath)) == null) {
            file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(absolutePath);
        }
        if (file2 == null) {
            LOG.debug("VirtualFile not found for " + absolutePath);
        }
        return file2;
    }

    @NotNull
    public static String toAbsolute(@NotNull VirtualFile root, @NotNull @NonNls String relativePath) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(83);
        }
        if (relativePath == null) {
            GitUtil.$$$reportNull$$$0(84);
        }
        String string = StringUtil.trimEnd((String)root.getPath(), (String)"/") + "/" + StringUtil.trimStart((String)relativePath, (String)"/");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    @NotNull
    public static Collection<String> toAbsolute(@NotNull VirtualFile root, @NotNull Collection<@NonNls String> relativePaths) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(86);
        }
        if (relativePaths == null) {
            GitUtil.$$$reportNull$$$0(87);
        }
        List list2 = ContainerUtil.map(relativePaths, s -> GitUtil.toAbsolute(root, s));
        if (list2 == null) {
            GitUtil.$$$reportNull$$$0(88);
        }
        return list2;
    }

    @NotNull
    public static List<Change> findLocalChangesForPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<@NonNls String> affectedPaths, boolean relativePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(89);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(90);
        }
        if (affectedPaths == null) {
            GitUtil.$$$reportNull$$$0(91);
        }
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx((Project)project);
        ArrayList<Change> affectedChanges = new ArrayList<Change>();
        for (String path : affectedPaths) {
            String absolutePath = relativePaths ? GitUtil.toAbsolute(root, path) : path;
            VirtualFile file2 = GitUtil.findRefreshFileOrLog(absolutePath);
            if (file2 == null) continue;
            Change change = changeListManager.getChange(file2);
            if (change != null) {
                affectedChanges.add(change);
                continue;
            }
            String message = "Change is not found for " + file2.getPath();
            if (changeListManager.isInUpdate()) {
                message = message + " because ChangeListManager is being updated.";
            }
            LOG.debug(message);
        }
        ArrayList<Change> arrayList = affectedChanges;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(92);
        }
        return arrayList;
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<@NonNls String> absolutePaths, @NotNull @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.DialogMessage String description2) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(93);
        }
        if (absolutePaths == null) {
            GitUtil.$$$reportNull$$$0(94);
        }
        if (title == null) {
            GitUtil.$$$reportNull$$$0(95);
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)new GitSimplePathsBrowser(project, absolutePaths));
        if (description2 != null) {
            builder.setNorthPanel((JComponent)new MultiLineLabel(description2));
        }
        builder.addOkAction();
        builder.setTitle(title);
        builder.show();
    }

    @NlsSafe
    @NotNull
    public static String cleanupErrorPrefixes(@NotNull @NlsSafe String msg) {
        if (msg == null) {
            GitUtil.$$$reportNull$$$0(96);
        }
        @NonNls String[] PREFIXES = new String[]{"fatal:", "error:"};
        msg = msg.trim();
        for (String prefix : PREFIXES) {
            if (!msg.startsWith(prefix)) continue;
            msg = msg.substring(prefix.length()).trim();
        }
        String string = msg;
        if (string == null) {
            GitUtil.$$$reportNull$$$0(97);
        }
        return string;
    }

    @Nullable
    public static GitRemote getDefaultRemote(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(98);
        }
        return (GitRemote)ContainerUtil.find(remotes, r -> r.getName().equals("origin"));
    }

    @Nullable
    public static GitRemote getDefaultOrFirstRemote(@NotNull Collection<GitRemote> remotes) {
        GitRemote result2;
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(99);
        }
        return (result2 = GitUtil.getDefaultRemote(remotes)) == null ? (GitRemote)ContainerUtil.getFirstItem(remotes) : result2;
    }

    @NotNull
    public static String joinToHtml(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitUtil.$$$reportNull$$$0(100);
        }
        String string = StringUtil.join(repositories2, repository -> repository.getPresentableUrl(), (String)"<br/>");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(101);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String mention(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(102);
        }
        return GitUtil.getRepositoryManager(repository.getProject()).moreThanOneRoot() ? GitBundle.message("mention.in", DvcsUtil.getShortRepositoryName((Repository)repository)) : "";
    }

    @Nls
    @NotNull
    public static String mention(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitUtil.$$$reportNull$$$0(103);
        }
        if (repositories2.isEmpty()) {
            return "";
        }
        String string = GitBundle.message("mention.in", DvcsUtil.joinShortNames(repositories2, (int)-1));
        if (string == null) {
            GitUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    public static void updateRepositories(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitUtil.$$$reportNull$$$0(105);
        }
        for (GitRepository gitRepository : repositories2) {
            gitRepository.update();
        }
    }

    public static boolean hasGitRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(106);
        }
        return !GitUtil.getRepositories(project).isEmpty();
    }

    @NotNull
    public static Collection<GitRepository> getRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(107);
        }
        List<GitRepository> list2 = GitUtil.getRepositoryManager(project).getRepositories();
        if (list2 == null) {
            GitUtil.$$$reportNull$$$0(108);
        }
        return list2;
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesInState(@NotNull Project project, @NotNull Repository.State state2) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(109);
        }
        if (state2 == null) {
            GitUtil.$$$reportNull$$$0(110);
        }
        List list2 = ContainerUtil.filter(GitUtil.getRepositories(project), repository -> repository.getState() == state2);
        if (list2 == null) {
            GitUtil.$$$reportNull$$$0(111);
        }
        return list2;
    }

    public static boolean isCaseOnlyChange(@NotNull @NonNls String oldPath, @NotNull @NonNls String newPath) {
        if (oldPath == null) {
            GitUtil.$$$reportNull$$$0(112);
        }
        if (newPath == null) {
            GitUtil.$$$reportNull$$$0(113);
        }
        if (oldPath.equalsIgnoreCase(newPath)) {
            if (oldPath.equals(newPath)) {
                LOG.info("Comparing perfectly equal paths: " + newPath);
            }
            return true;
        }
        return false;
    }

    @NonNls
    @NotNull
    public static String getLogStringGitDiffChanges(@NotNull @NonNls String root, @NotNull Collection<? extends GitChangeUtils.GitDiffChange> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(114);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(115);
        }
        return GitUtil.getLogString(root, changes, it -> it.getBeforePath(), it -> it.getAfterPath());
    }

    @NonNls
    @NotNull
    public static String getLogString(@NotNull @NonNls String root, @NotNull Collection<? extends Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(116);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(117);
        }
        return GitUtil.getLogString(root, changes, ChangesUtil::getBeforePath, ChangesUtil::getAfterPath);
    }

    @NonNls
    @NotNull
    public static <T> String getLogString(@NotNull @NonNls String root, @NotNull Collection<? extends T> changes, @NotNull Convertor<? super T, ? extends FilePath> beforePathGetter, @NotNull Convertor<? super T, ? extends FilePath> afterPathGetter) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(118);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(119);
        }
        if (beforePathGetter == null) {
            GitUtil.$$$reportNull$$$0(120);
        }
        if (afterPathGetter == null) {
            GitUtil.$$$reportNull$$$0(121);
        }
        String string = StringUtil.join(changes, change -> {
            FilePath after = (FilePath)afterPathGetter.convert(change);
            FilePath before = (FilePath)beforePathGetter.convert(change);
            if (before == null) {
                return "A: " + GitUtil.getRelativePath(root, after);
            }
            if (after == null) {
                return "D: " + GitUtil.getRelativePath(root, before);
            }
            if (ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)before, (Object)after)) {
                return "M: " + GitUtil.getRelativePath(root, after);
            }
            return "R: " + GitUtil.getRelativePath(root, before) + " -> " + GitUtil.getRelativePath(root, after);
        }, (String)", ");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(122);
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(@NotNull String root, @NotNull FilePath after) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(123);
        }
        if (after == null) {
            GitUtil.$$$reportNull$$$0(124);
        }
        return FileUtil.getRelativePath((String)root, (String)after.getPath(), (char)File.separatorChar);
    }

    @NotNull
    public static Collection<Change> findCorrespondentLocalChanges(@NotNull ChangeListManager changeListManager, @NotNull Collection<? extends Change> originalChanges) {
        if (changeListManager == null) {
            GitUtil.$$$reportNull$$$0(125);
        }
        if (originalChanges == null) {
            GitUtil.$$$reportNull$$$0(126);
        }
        ObjectOpenHashSet allChanges = new ObjectOpenHashSet(changeListManager.getAllChanges());
        List list2 = ContainerUtil.mapNotNull(originalChanges, arg_0 -> ((ObjectOpenHashSet)allChanges).get(arg_0));
        if (list2 == null) {
            GitUtil.$$$reportNull$$$0(127);
        }
        return list2;
    }

    public static void refreshVfs(@NotNull VirtualFile root, @Nullable Collection<? extends Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(128);
        }
        if (changes == null || Registry.is((String)"git.refresh.vfs.total")) {
            GitUtil.refreshVfsInRoot(root);
        } else {
            RefreshVFsSynchronously.updateChanges(changes);
        }
    }

    public static void refreshVfsInRoot(@NotNull VirtualFile root) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(129);
        }
        GitUtil.refreshVfsInRoots(Collections.singleton(root));
    }

    public static void refreshVfsInRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            GitUtil.$$$reportNull$$$0(130);
        }
        RefreshVFsSynchronously.trace((String)("refresh roots " + roots));
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])roots.toArray(VirtualFile.EMPTY_ARRAY));
    }

    public static void updateAndRefreshChangedVfs(@NotNull GitRepository repository, @Nullable Hash startHash) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(131);
        }
        repository.update();
        GitUtil.refreshChangedVfs(repository, startHash);
    }

    public static void refreshChangedVfs(@NotNull GitRepository repository, @Nullable Hash startHash) {
        Hash currentHash;
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(132);
        }
        Collection<Change> changes = null;
        if (startHash != null && (currentHash = GitUtil.getHead(repository)) != null) {
            RefreshVFsSynchronously.trace((String)String.format("changes: %s -> %s", startHash.asString(), currentHash.asString()));
            changes = GitChangeUtils.getDiff(repository, startHash.asString(), currentHash.asString(), false);
        }
        GitUtil.refreshVfs(repository.getRoot(), changes);
    }

    @Deprecated
    public static boolean isGitRoot(@NotNull @NonNls String rootDir) {
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(133);
        }
        try {
            return GitUtil.isGitRoot(Paths.get(rootDir, new String[0]));
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @ApiStatus.Obsolete
    public static boolean isGitRoot(@NotNull Path rootDir) {
        String content;
        BasicFileAttributes attributes;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(134);
        }
        Path dotGit = rootDir.resolve(DOT_GIT);
        try {
            attributes = Files.readAttributes(dotGit, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException ignore) {
            return false;
        }
        if (attributes.isDirectory()) {
            try {
                BasicFileAttributes headExists = Files.readAttributes(dotGit.resolve("HEAD"), BasicFileAttributes.class, new LinkOption[0]);
                return headExists.isRegularFile();
            }
            catch (IOException ignore) {
                return false;
            }
        }
        if (!attributes.isRegularFile()) {
            return false;
        }
        try {
            content = (String)DvcsUtil.tryOrThrow(() -> StringUtil.convertLineSeparators((String)Files.readString(dotGit)).trim(), (Object)dotGit);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return false;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        if (pathToDir == null) {
            return false;
        }
        return GitUtil.findRealRepositoryDir(rootDir, pathToDir) != null;
    }

    public static void generateGitignoreFileIfNeeded(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(135);
        }
        if (ignoreFileRoot == null) {
            GitUtil.$$$reportNull$$$0(136);
        }
        VcsImplUtil.generateIgnoreFileIfNeeded((Project)project, (AbstractVcs)GitVcs.getInstance(project), (VirtualFile)ignoreFileRoot);
    }

    public static <T extends Throwable> void tryRunOrClose(@NotNull AutoCloseable closeable, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (closeable == null) {
            GitUtil.$$$reportNull$$$0(137);
        }
        if (runnable == null) {
            GitUtil.$$$reportNull$$$0(138);
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            try {
                closeable.close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @NotNull
    public static <T extends GitHandler> T createHandlerWithPaths(@Nullable Collection<? extends FilePath> paths, @NotNull Computable<T> handlerBuilder) {
        if (handlerBuilder == null) {
            GitUtil.$$$reportNull$$$0(139);
        }
        GitHandler handler = (GitHandler)handlerBuilder.compute();
        handler.endOptions();
        if (paths != null) {
            handler.addRelativePaths(paths);
            if (handler.isLargeCommandLine()) {
                handler = (GitHandler)handlerBuilder.compute();
                handler.endOptions();
            }
        }
        GitHandler gitHandler = handler;
        if (gitHandler == null) {
            GitUtil.$$$reportNull$$$0(140);
        }
        return (T)gitHandler;
    }

    @Nullable
    public static Hash getHead(@NotNull GitRepository repository) {
        GitCommandResult result2;
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(141);
        }
        if (!(result2 = Git.getInstance().tip(repository, "HEAD")).success()) {
            LOG.warn("Couldn't identify the HEAD for " + repository + ": " + result2.getErrorOutputAsJoinedString());
            return null;
        }
        String head = result2.getOutputAsJoinedString();
        return HashImpl.build((String)head);
    }

    public static boolean isHashString(@NotNull @NonNls String revision) {
        if (revision == null) {
            GitUtil.$$$reportNull$$$0(142);
        }
        return HASH_STRING_PATTERN.matcher(revision).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 15, 18, 23, 26, 29, 36, 38, 48, 50, 53, 58, 59, 61, 64, 67, 70, 75, 76, 79, 80, 85, 88, 92, 97, 101, 104, 108, 111, 122, 127, 140 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: 
            case 30: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotGit";
                break;
            }
            case 5: 
            case 63: 
            case 66: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 34: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 77: 
            case 89: 
            case 93: 
            case 106: 
            case 107: 
            case 109: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 36: 
            case 38: 
            case 48: 
            case 50: 
            case 53: 
            case 58: 
            case 59: 
            case 61: 
            case 64: 
            case 67: 
            case 70: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 85: 
            case 88: 
            case 92: 
            case 97: 
            case 101: 
            case 104: 
            case 108: 
            case 111: 
            case 122: 
            case 127: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitUtil";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 39: 
            case 42: 
            case 45: 
            case 55: 
            case 81: 
            case 102: 
            case 131: 
            case 132: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAtRemote";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 49: 
            case 100: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 52: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRef";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRef";
                break;
            }
            case 69: 
            case 72: 
            case 83: 
            case 86: 
            case 90: 
            case 114: 
            case 116: 
            case 118: 
            case 123: 
            case 128: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedPaths";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePaths";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 98: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 115: 
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforePathGetter";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterPathGetter";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalChanges";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileRoot";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeable";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerBuilder";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRootIgnoringMissing";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilePathsByGitRootIgnoringMissing";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRoot";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByRepositoryIgnoringMissing";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByRepository";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilePathsByGitRoot";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesForFiles";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateRemoteBranch";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsFromRepositories";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesFromRoots";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsDiffBetweenRefs";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 64: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryForFile";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryForRoot";
                break;
            }
            case 75: 
            case 76: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootForFile";
                break;
            }
            case 85: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "toAbsolute";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocalChangesForPaths";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupErrorPrefixes";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "joinToHtml";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "mention";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesInState";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogString";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "findCorrespondentLocalChanges";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandlerWithPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGitDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRealRepositoryDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePathToRepository";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRootIgnoringMissing";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 36: 
            case 38: 
            case 48: 
            case 50: 
            case 53: 
            case 58: 
            case 59: 
            case 61: 
            case 64: 
            case 67: 
            case 70: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 85: 
            case 88: 
            case 92: 
            case 97: 
            case 101: 
            case 104: 
            case 108: 
            case 111: 
            case 122: 
            case 127: 
            case 140: {
                break;
            }
            case 11: 
            case 12: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sortFilePathsByGitRoot";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortFilePathsByGitRootIgnoringMissing";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByRepository";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByRepositoryIgnoringMissing";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findGitRootFor";
                break;
            }
            case 31: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isGitRoot";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isUnderGit";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesForFiles";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "unescapePath";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteByName";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateRemoteBranch";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getRootsFromRepositories";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesFromRoots";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getPathsDiffBetweenRefs";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 62: 
            case 63: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFile";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForRoot";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForRootOrLogError";
                break;
            }
            case 73: 
            case 74: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getRootForFile";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForCurrentBranch";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findRefreshFileOrLog";
                break;
            }
            case 83: 
            case 84: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "toAbsolute";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "findLocalChangesForPaths";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "showPathsInDialog";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "cleanupErrorPrefixes";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRemote";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrFirstRemote";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "joinToHtml";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "mention";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "updateRepositories";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRepositories";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesInState";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isCaseOnlyChange";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getLogStringGitDiffChanges";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getLogString";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "findCorrespondentLocalChanges";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfs";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfsInRoot";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfsInRoots";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "updateAndRefreshChangedVfs";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "refreshChangedVfs";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "generateGitignoreFileIfNeeded";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "tryRunOrClose";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "createHandlerWithPaths";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getHead";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "isHashString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 15, 18, 23, 26, 29, 36, 38, 48, 50, 53, 58, 59, 61, 64, 67, 70, 75, 76, 79, 80, 85, 88, 92, 97, 101, 104, 108, 111, 122, 127, 140 -> new IllegalStateException(string);
        };
    }

    private static final class GitRepositoryNotFoundException
    extends VcsException {
        private GitRepositoryNotFoundException(@NotNull VirtualFile file2) {
            if (file2 == null) {
                GitRepositoryNotFoundException.$$$reportNull$$$0(0);
            }
            super(GitBundle.message("repository.not.found.error", file2.getPresentableUrl()));
        }

        private GitRepositoryNotFoundException(@NotNull FilePath filePath) {
            if (filePath == null) {
                GitRepositoryNotFoundException.$$$reportNull$$$0(1);
            }
            super(GitBundle.message("repository.not.found.error", filePath.getPresentableUrl()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
            }
            objectArray[1] = "git4idea/GitUtil$GitRepositoryNotFoundException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

