/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.dvcs.MultiMessage;
import com.intellij.dvcs.MultiRootMessage;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.RestrictingAuthenticationGate;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.fetch.GitFetchHandler;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.fetch.GitFetchSupportImpl;
import git4idea.fetch.GitFetchSupportImplKt;
import git4idea.fetch.GitRemoteOperationQueueImpl;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0005?@ABCB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000b\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001eH\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0016\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0016J\u0016\u0010%\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0016J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\"\u0010)\u001a\u00020\u001d2\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170*0$H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010,\u001a\u00020-2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$2\u0006\u0010.\u001a\u00020-H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00192\u0006\u00100\u001a\u00020\u0019H\u0002J\b\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\u0002022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0002J\u001a\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u0001052\u0006\u00107\u001a\u00020\u0013H\u0002J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u00130 2\f\u00109\u001a\b\u0012\u0004\u0012\u00020'0 H\u0002J!\u0010:\u001a\u0002H;\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=H\u0002\u00a2\u0006\u0002\u0010>R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl;", "Lgit4idea/fetch/GitFetchSupport;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fetchQueue", "Lgit4idea/fetch/GitRemoteOperationQueueImpl;", "fetchRequestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "git", "Lgit4idea/commands/GitImpl;", "getGit", "()Lgit4idea/commands/GitImpl;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "Lorg/jetbrains/annotations/NotNull;", "getProgressManager", "()Lcom/intellij/openapi/progress/ProgressManager;", "doFetch", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "refspec", "", "authenticationGate", "Lcom/intellij/externalProcessAuthHelper/AuthenticationGate;", "fetch", "Lgit4idea/fetch/GitFetchResult;", "Lorg/jetbrains/annotations/NonNls;", "arguments", "", "Lgit4idea/fetch/GitFetchSupportImpl$RemoteRefCoordinates;", "fetchAllRemotes", "repositories", "", "fetchDefaultRemote", "fetchInParallel", "Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "remotes", "fetchRemotes", "Lcom/intellij/openapi/util/Pair;", "getDefaultRemoteToFetch", "getMaxThreads", "", "numberOfRemotes", "getPrunedRef", "line", "isFetchRunning", "", "isStoreCredentialsHelperUsed", "mergeRepoResults", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "firstResult", "secondResult", "waitForFetchTasks", "tasks", "withIndicator", "T", "operation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "FetchResultImpl", "FetchTask", "RemoteRefCoordinates", "RepoResult", "SingleRemoteResult", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitFetchSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n1549#2:354\n1620#2,3:355\n1620#2,3:358\n1747#2,3:361\n1603#2,9:364\n1855#2:373\n1856#2:375\n1612#2:376\n1#3:374\n*S KotlinDebug\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl\n*L\n103#1:354\n103#1:355,3\n148#1:358,3\n190#1:361,3\n232#1:364,9\n232#1:373\n232#1:375\n232#1:376\n232#1:374\n*E\n"})
public final class GitFetchSupportImpl
implements GitFetchSupport {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRemoteOperationQueueImpl fetchQueue;
    @NotNull
    private final AtomicInteger fetchRequestCounter;

    public GitFetchSupportImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fetchQueue = new GitRemoteOperationQueueImpl();
        this.fetchRequestCounter = new AtomicInteger();
    }

    private final GitImpl getGit() {
        Git git = Git.getInstance();
        Intrinsics.checkNotNull((Object)git, (String)"null cannot be cast to non-null type git4idea.commands.GitImpl");
        return (GitImpl)git;
    }

    private final ProgressManager getProgressManager() {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        return progressManager;
    }

    @Override
    @Nullable
    public GitRemote getDefaultRemoteToFetch(@NotNull GitRepository repository) {
        Comparable<GitReference> comparable;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Collection<GitRemote> collection = repository.getRemotes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemotes(...)");
        Collection<GitRemote> remotes = collection;
        if (remotes.isEmpty()) {
            comparable = null;
        } else if (remotes.size() == 1) {
            comparable = (GitRemote)CollectionsKt.first((Iterable)remotes);
        } else {
            comparable = repository.getCurrentBranch();
            if (comparable == null || (comparable = ((GitLocalBranch)comparable).findTrackedBranch(repository)) == null || (comparable = ((GitRemoteBranch)comparable).getRemote()) == null) {
                comparable = GitUtil.findRemoteByName(repository, "origin");
            }
        }
        return comparable;
    }

    @NotNull
    public GitFetchResult fetchDefaultRemote(@NotNull Collection<? extends GitRepository> repositories2) {
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories2) {
            GitRemote remote = this.getDefaultRemoteToFetch(gitRepository);
            if (remote != null) {
                remotesToFetch.add(new RemoteRefCoordinates(gitRepository, remote, null, 4, null));
                continue;
            }
            GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
        }
        return this.fetch(remotesToFetch);
    }

    @NotNull
    public GitFetchResult fetchAllRemotes(@NotNull Collection<? extends GitRepository> repositories2) {
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories2) {
            if (gitRepository.getRemotes().isEmpty()) {
                GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
                continue;
            }
            for (GitRemote remote : gitRepository.getRemotes()) {
                Intrinsics.checkNotNull((Object)remote);
                remotesToFetch.add(new RemoteRefCoordinates(gitRepository, remote, null, 4, null));
            }
        }
        return this.fetch(remotesToFetch);
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return this.fetch(CollectionsKt.listOf((Object)new RemoteRefCoordinates(repository, remote, null, 4, null)));
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String refspec) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)refspec, (String)"refspec");
        return this.fetch(CollectionsKt.listOf((Object)new RemoteRefCoordinates(repository, remote, refspec)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public GitFetchResult fetchRemotes(@NotNull Collection<? extends com.intellij.openapi.util.Pair<GitRepository, GitRemote>> remotes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
        Iterable iterable = remotes;
        GitFetchSupportImpl gitFetchSupportImpl = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            GitRepository gitRepository = (GitRepository)object;
            Object object2 = it.second;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
            collection.add(new RemoteRefCoordinates(gitRepository, (GitRemote)object2, null, 4, null));
        }
        return gitFetchSupportImpl.fetch((List)destination$iv$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GitFetchResult fetch(List<RemoteRefCoordinates> arguments) {
        try {
            this.fetchRequestCounter.incrementAndGet();
            GitFetchResult gitFetchResult = (GitFetchResult)this.withIndicator((Function0)new Function0<FetchResultImpl>(this, arguments){
                final /* synthetic */ GitFetchSupportImpl this$0;
                final /* synthetic */ List<RemoteRefCoordinates> $arguments;
                {
                    this.this$0 = $receiver;
                    this.$arguments = $arguments;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final FetchResultImpl invoke() {
                    void $this$groupByTo$iv$iv;
                    StructuredIdeActivity activity = IdeActivityDefinition.started$default((IdeActivityDefinition)VcsStatisticsCollector.INSTANCE.getFETCH_ACTIVITY(), (Project)GitFetchSupportImpl.access$getProject$p(this.this$0), null, (int)2, null);
                    List tasks = GitFetchSupportImpl.access$fetchInParallel(this.this$0, this.$arguments);
                    List results = GitFetchSupportImpl.access$waitForFetchTasks(this.this$0, tasks);
                    Map mergedResults = new LinkedHashMap<K, V>();
                    List succeedResults = new ArrayList<E>();
                    for (SingleRemoteResult result2 : results) {
                        RepoResult res = (RepoResult)mergedResults.get(result2.getRepository());
                        mergedResults.put(result2.getRepository(), GitFetchSupportImpl.access$mergeRepoResults(this.this$0, res, result2));
                        if (!result2.success()) continue;
                        succeedResults.add(result2);
                    }
                    Iterable $this$groupBy$iv = succeedResults;
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        void it;
                        Object object;
                        SingleRemoteResult it2 = (SingleRemoteResult)element$iv$iv;
                        boolean $i$a$-groupBy-GitFetchSupportImpl$fetch$1$successFetchesMap$32 = false;
                        GitRepository key$iv$iv = it2.getRepository();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        SingleRemoteResult $i$a$-groupBy-GitFetchSupportImpl$fetch$1$successFetchesMap$32 = (SingleRemoteResult)element$iv$iv;
                        List list2 = list$iv$iv;
                        boolean bl = false;
                        list2.add(it.getRemote());
                    }
                    Map successFetchesMap = destination$iv$iv;
                    if (!successFetchesMap.isEmpty()) {
                        Project project = GitFetchSupportImpl.access$getProject$p(this.this$0);
                        ProgressIndicator progressIndicator = GitFetchSupportImpl.access$getProgressManager(this.this$0).getProgressIndicator();
                        if (progressIndicator == null) {
                            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                        }
                        GitFetchHandler.Companion.afterSuccessfulFetch(project, successFetchesMap, progressIndicator);
                    }
                    StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                    Project project = GitFetchSupportImpl.access$getProject$p(this.this$0);
                    VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)GitFetchSupportImpl.access$getProject$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
                    return new FetchResultImpl(project, vcsNotifier, mergedResults);
                }
            });
            return gitFetchResult;
        }
        finally {
            this.fetchRequestCounter.decrementAndGet();
        }
    }

    private final RepoResult mergeRepoResults(RepoResult firstResult, SingleRemoteResult secondResult) {
        if (firstResult == null) {
            return new RepoResult(MapsKt.mapOf((Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
        }
        return new RepoResult(MapsKt.plus(firstResult.getResults(), (Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
    }

    @Override
    public boolean isFetchRunning() {
        return this.fetchRequestCounter.get() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FetchTask> fetchInParallel(List<RemoteRefCoordinates> remotes) {
        void destination$iv;
        void $this$mapTo$iv;
        List tasks = new ArrayList();
        Iterable iterable = remotes;
        Collection collection = new HashSet();
        GitFetchSupportImpl gitFetchSupportImpl = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            RemoteRefCoordinates remoteRefCoordinates = (RemoteRefCoordinates)item$iv;
            void var14_13 = destination$iv;
            boolean bl = false;
            var14_13.add(it.getRepository());
        }
        int maxThreads = gitFetchSupportImpl.getMaxThreads((Collection<? extends GitRepository>)destination$iv, remotes.size());
        GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remotes + " using " + maxThreads + " threads");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitFetch pool", (int)maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        ExecutorService executor = executorService;
        ProgressIndicator progressIndicator = this.getProgressManager().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator commonIndicator = progressIndicator;
        RestrictingAuthenticationGate authenticationGate = new RestrictingAuthenticationGate();
        for (RemoteRefCoordinates remoteRefCoordinates : remotes) {
            Future<SingleRemoteResult> future2;
            GitRepository repository = remoteRefCoordinates.component1();
            GitRemote remote = remoteRefCoordinates.component2();
            String refspec = remoteRefCoordinates.component3();
            GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remote + " in " + repository);
            Intrinsics.checkNotNullExpressionValue(executor.submit(() -> GitFetchSupportImpl.fetchInParallel$lambda$3(commonIndicator, this, repository, remote, refspec, authenticationGate)), (String)"submit(...)");
            tasks.add(new FetchTask(repository, remote, future2));
        }
        return tasks;
    }

    private final int getMaxThreads(Collection<? extends GitRepository> repositories2, int numberOfRemotes) {
        int maxThreads;
        int config = Registry.intValue((String)"git.parallel.fetch.threads");
        int n = config > 0 ? config : (config == -1 ? Runtime.getRuntime().availableProcessors() : (config == -2 ? numberOfRemotes : (maxThreads = config == -3 ? Math.min(numberOfRemotes, Runtime.getRuntime().availableProcessors() * 2) : 1)));
        if (this.isStoreCredentialsHelperUsed(repositories2)) {
            return 1;
        }
        return Math.min(maxThreads, 10);
    }

    private final boolean isStoreCredentialsHelperUsed(Collection<? extends GitRepository> repositories2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = repositories2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)GitConfigUtil.getValue(this.project, it.getRoot(), "credential.helper"), (String)"store", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<SingleRemoteResult> waitForFetchTasks(List<FetchTask> tasks) {
        List results = new ArrayList();
        for (FetchTask task : tasks) {
            try {
                SingleRemoteResult singleRemoteResult = task.getFuture().get();
                Intrinsics.checkNotNullExpressionValue((Object)singleRemoteResult, (String)"get(...)");
                results.add(singleRemoteResult);
            }
            catch (CancellationException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.ProcessCanceledException");
                    throw (ProcessCanceledException)throwable;
                }
                GitRepository gitRepository = task.getRepository();
                GitRemote gitRemote = task.getRemote();
                Object object = e.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    String string = GitBundle.message("error.dialog.title", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                }
                results.add(new SingleRemoteResult(gitRepository, gitRemote, (String)object, CollectionsKt.emptyList()));
                GitFetchSupportImplKt.access$getLOG$p().error((Throwable)e);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withIndicator(Function0<? extends T> operation) {
        ProgressIndicator indicator;
        ProgressIndicator progressIndicator = indicator = this.getProgressManager().getProgressIndicator();
        String prevText = progressIndicator != null ? progressIndicator.getText() : null;
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(GitBundle.message("git.fetch.progress", new Object[0]));
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText(prevText);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SingleRemoteResult doFetch(GitRepository repository, GitRemote remote, String refspec, AuthenticationGate authenticationGate) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray;
        String recurseSubmodules = "--recurse-submodules=no";
        if (refspec == null) {
            var7_6 = new String[]{recurseSubmodules};
            stringArray = var7_6;
        } else {
            var7_6 = new String[]{refspec, recurseSubmodules};
            stringArray = var7_6;
        }
        String[] params = stringArray;
        GitCommandResult gitCommandResult = this.getGit().fetch(repository, remote, (List<? extends GitLineHandlerListener>)CollectionsKt.emptyList(), authenticationGate, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"fetch(...)");
        GitCommandResult result2 = gitCommandResult;
        List<String> list2 = result2.getOutput();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getOutput(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.getPrunedRef(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pruned = (List)destination$iv$iv;
        if (result2.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)repository.getProject(), GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
            repository.update();
        }
        String error = result2.success() ? null : result2.getErrorOutputAsJoinedString();
        return new SingleRemoteResult(repository, remote, error, pruned);
    }

    static /* synthetic */ SingleRemoteResult doFetch$default(GitFetchSupportImpl gitFetchSupportImpl, GitRepository gitRepository, GitRemote gitRemote, String string, AuthenticationGate authenticationGate, int n, Object object) {
        if ((n & 8) != 0) {
            authenticationGate = null;
        }
        return gitFetchSupportImpl.doFetch(gitRepository, gitRemote, string, authenticationGate);
    }

    private final String getPrunedRef(String line) {
        Matcher matcher = GitFetchSupportImplKt.access$getPRUNE_PATTERN$p().matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private static final void fetchInParallel$lambda$3$lambda$2(ProgressIndicator $commonIndicator, Ref.ObjectRef $result, GitFetchSupportImpl this$0, GitRepository $repository, GitRemote $remote, String $refspec, RestrictingAuthenticationGate $authenticationGate) {
        Intrinsics.checkNotNullParameter((Object)$commonIndicator, (String)"$commonIndicator");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        Intrinsics.checkNotNullParameter((Object)$remote, (String)"$remote");
        Intrinsics.checkNotNullParameter((Object)$authenticationGate, (String)"$authenticationGate");
        $commonIndicator.checkCanceled();
        $result.element = this$0.fetchQueue.executeForRemote($repository, $remote, (Function0)new Function0<SingleRemoteResult>(this$0, $repository, $remote, $refspec, $authenticationGate){
            final /* synthetic */ GitFetchSupportImpl this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRemote $remote;
            final /* synthetic */ String $refspec;
            final /* synthetic */ RestrictingAuthenticationGate $authenticationGate;
            {
                this.this$0 = $receiver;
                this.$repository = $repository;
                this.$remote = $remote;
                this.$refspec = $refspec;
                this.$authenticationGate = $authenticationGate;
                super(0);
            }

            @NotNull
            public final SingleRemoteResult invoke() {
                return GitFetchSupportImpl.access$doFetch(this.this$0, this.$repository, this.$remote, this.$refspec, (AuthenticationGate)this.$authenticationGate);
            }
        });
    }

    private static final SingleRemoteResult fetchInParallel$lambda$3(ProgressIndicator $commonIndicator, GitFetchSupportImpl this$0, GitRepository $repository, GitRemote $remote, String $refspec, RestrictingAuthenticationGate $authenticationGate) {
        SingleRemoteResult singleRemoteResult;
        Intrinsics.checkNotNullParameter((Object)$commonIndicator, (String)"$commonIndicator");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        Intrinsics.checkNotNullParameter((Object)$remote, (String)"$remote");
        Intrinsics.checkNotNullParameter((Object)$authenticationGate, (String)"$authenticationGate");
        $commonIndicator.checkCanceled();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        ProgressManager.getInstance().executeProcessUnderProgress(() -> GitFetchSupportImpl.fetchInParallel$lambda$3$lambda$2($commonIndicator, result2, this$0, $repository, $remote, $refspec, $authenticationGate), $commonIndicator);
        if (result2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            singleRemoteResult = null;
        } else {
            singleRemoteResult = (SingleRemoteResult)result2.element;
        }
        return singleRemoteResult;
    }

    public static final /* synthetic */ Project access$getProject$p(GitFetchSupportImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ List access$fetchInParallel(GitFetchSupportImpl $this, List remotes) {
        return $this.fetchInParallel(remotes);
    }

    public static final /* synthetic */ List access$waitForFetchTasks(GitFetchSupportImpl $this, List tasks) {
        return $this.waitForFetchTasks(tasks);
    }

    public static final /* synthetic */ RepoResult access$mergeRepoResults(GitFetchSupportImpl $this, RepoResult firstResult, SingleRemoteResult secondResult) {
        return $this.mergeRepoResults(firstResult, secondResult);
    }

    public static final /* synthetic */ ProgressManager access$getProgressManager(GitFetchSupportImpl $this) {
        return $this.getProgressManager();
    }

    public static final /* synthetic */ SingleRemoteResult access$doFetch(GitFetchSupportImpl $this, GitRepository repository, GitRemote remote, String refspec, AuthenticationGate authenticationGate) {
        return $this.doFetch(repository, remote, refspec, authenticationGate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\r\u0010\u001c\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\u0019\u0010\u001d\u001a\u00020\u00142\u000f\b\u0002\u0010\u001c\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0015\u0010\u001f\u001a\u00020\f2\u000b\u0010 \u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0016J\b\u0010!\u001a\u00020\u0014H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchResultImpl;", "Lgit4idea/fetch/GitFetchResult;", "project", "Lcom/intellij/openapi/project/Project;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "results", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsNotifier;Ljava/util/Map;)V", "isFailed", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResults", "()Ljava/util/Map;", "getVcsNotifier", "()Lcom/intellij/openapi/vcs/VcsNotifier;", "appendDetails", "", "sb", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "details", "Lcom/intellij/dvcs/MultiRootMessage;", "buildMessage", "", "Lorg/jetbrains/annotations/Nls;", "failureTitle", "doShowNotification", "showNotification", "showNotificationIfFailed", "title", "throwExceptionIfFailed", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitFetchSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$FetchResultImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,353:1\n1747#2,3:354\n1549#2:357\n1620#2,3:358\n494#3,7:361\n*S KotlinDebug\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$FetchResultImpl\n*L\n288#1:354,3\n317#1:357\n317#1:358,3\n321#1:361,7\n*E\n"})
    private static final class FetchResultImpl
    implements GitFetchResult {
        @NotNull
        private final Project project;
        @NotNull
        private final VcsNotifier vcsNotifier;
        @NotNull
        private final Map<GitRepository, RepoResult> results;
        private final boolean isFailed;

        /*
         * WARNING - void declaration
         */
        public FetchResultImpl(@NotNull Project project, @NotNull VcsNotifier vcsNotifier, @NotNull Map<GitRepository, RepoResult> results) {
            boolean bl;
            boolean bl2;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)vcsNotifier, (String)"vcsNotifier");
                Intrinsics.checkNotNullParameter(results, (String)"results");
                this.project = project;
                this.vcsNotifier = vcsNotifier;
                this.results = results;
                Iterable iterable = this.results.values();
                FetchResultImpl fetchResultImpl = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RepoResult it = (RepoResult)element$iv;
                        boolean bl3 = false;
                        if (!(!it.totallySuccessful())) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = false;
                }
            }
            fetchResultImpl.isFailed = bl = bl2;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VcsNotifier getVcsNotifier() {
            return this.vcsNotifier;
        }

        @NotNull
        public final Map<GitRepository, RepoResult> getResults() {
            return this.results;
        }

        @Override
        public void showNotification() {
            FetchResultImpl.doShowNotification$default(this, null, 1, null);
        }

        @Override
        public boolean showNotificationIfFailed() {
            if (this.isFailed) {
                this.doShowNotification(null);
            }
            return !this.isFailed;
        }

        @Override
        public boolean showNotificationIfFailed(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            if (this.isFailed) {
                this.doShowNotification(title);
            }
            return !this.isFailed;
        }

        private final void doShowNotification(String failureTitle) {
            NotificationType type = !this.isFailed ? NotificationType.INFORMATION : NotificationType.ERROR;
            String message = this.buildMessage(failureTitle);
            Notification notification2 = VcsNotifier.STANDARD_NOTIFICATION.createNotification(message, type);
            notification2.setDisplayId(!this.isFailed ? "git.fetch.result" : "git.fetch.result.error");
            this.vcsNotifier.notify(notification2);
        }

        static /* synthetic */ void doShowNotification$default(FetchResultImpl fetchResultImpl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            fetchResultImpl.doShowNotification(string);
        }

        @Override
        public void throwExceptionIfFailed() {
            if (this.isFailed) {
                throw new VcsException(this.buildMessage(null));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String buildMessage(String failureTitle) {
            GitRepository repo;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.results.keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean bl = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GitRepository gitRepository = (GitRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(gitRepository.getRoot());
            }
            List roots = (List)destination$iv$iv;
            MultiRootMessage errorMessage = new MultiRootMessage(this.project, (Collection)roots, true, false, 8, null);
            MultiRootMessage prunedRefs = new MultiRootMessage(this.project, (Collection)roots, false, false, 12, null);
            Iterator<Map.Entry<GitRepository, RepoResult>> $this$filterValues$iv = this.results;
            boolean entry = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry2 : $this$filterValues$iv.entrySet()) {
                RepoResult it = (RepoResult)entry2.getValue();
                boolean bl3 = false;
                if (!(!it.totallySuccessful())) continue;
                result$iv.put(entry2.getKey(), entry2.getValue());
            }
            Map failed = result$iv;
            for (Map.Entry entry3 : failed.entrySet()) {
                repo = (GitRepository)entry3.getKey();
                RepoResult result2 = (RepoResult)entry3.getValue();
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                errorMessage.append((Object)virtualFile, result2.error());
            }
            for (Map.Entry<GitRepository, RepoResult> entry4 : this.results.entrySet()) {
                repo = entry4.getKey();
                RepoResult result2 = entry4.getValue();
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                prunedRefs.append((Object)virtualFile, result2.prunedRefs());
            }
            HtmlBuilder sb = new HtmlBuilder();
            if (!this.isFailed) {
                sb.append((HtmlChunk)HtmlChunk.text((String)GitBundle.message("notification.title.fetch.success", new Object[0])).bold());
            } else {
                String string = failureTitle;
                if (string == null) {
                    String string2 = GitBundle.message("notification.title.fetch.failure", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                }
                sb.append((HtmlChunk)HtmlChunk.text((String)string).bold());
                if (failed.size() != roots.size()) {
                    sb.append(GitUtil.mention(failed.keySet()));
                }
            }
            this.appendDetails(sb, errorMessage);
            this.appendDetails(sb, prunedRefs);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void appendDetails(HtmlBuilder sb, MultiRootMessage details) {
            String text2 = details.asString();
            if (((CharSequence)text2).length() > 0) {
                sb.br().append(text2);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "future", "Ljava/util/concurrent/Future;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/util/concurrent/Future;)V", "getFuture", "()Ljava/util/concurrent/Future;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    private static final class FetchTask {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @NotNull
        private final Future<SingleRemoteResult> future;

        public FetchTask(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Future<SingleRemoteResult> future2) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter(future2, (String)"future");
            this.repository = repository;
            this.remote = remote;
            this.future = future2;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @NotNull
        public final Future<SingleRemoteResult> getFuture() {
            return this.future;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RemoteRefCoordinates;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "refspec", "", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/lang/String;)V", "getRefspec", "()Ljava/lang/String;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class RemoteRefCoordinates {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @Nullable
        private final String refspec;

        public RemoteRefCoordinates(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String refspec) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            this.repository = repository;
            this.remote = remote;
            this.refspec = refspec;
        }

        public /* synthetic */ RemoteRefCoordinates(GitRepository gitRepository, GitRemote gitRemote, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = null;
            }
            this(gitRepository, gitRemote, string);
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @Nullable
        public final String getRefspec() {
            return this.refspec;
        }

        @NotNull
        public final GitRepository component1() {
            return this.repository;
        }

        @NotNull
        public final GitRemote component2() {
            return this.remote;
        }

        @Nullable
        public final String component3() {
            return this.refspec;
        }

        @NotNull
        public final RemoteRefCoordinates copy(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String refspec) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            return new RemoteRefCoordinates(repository, remote, refspec);
        }

        public static /* synthetic */ RemoteRefCoordinates copy$default(RemoteRefCoordinates remoteRefCoordinates, GitRepository gitRepository, GitRemote gitRemote, String string, int n, Object object) {
            if ((n & 1) != 0) {
                gitRepository = remoteRefCoordinates.repository;
            }
            if ((n & 2) != 0) {
                gitRemote = remoteRefCoordinates.remote;
            }
            if ((n & 4) != 0) {
                string = remoteRefCoordinates.refspec;
            }
            return remoteRefCoordinates.copy(gitRepository, gitRemote, string);
        }

        @NotNull
        public String toString() {
            return "RemoteRefCoordinates(repository=" + this.repository + ", remote=" + this.remote + ", refspec=" + this.refspec + ")";
        }

        public int hashCode() {
            int result2 = this.repository.hashCode();
            result2 = result2 * 31 + this.remote.hashCode();
            result2 = result2 * 31 + (this.refspec == null ? 0 : this.refspec.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoteRefCoordinates)) {
                return false;
            }
            RemoteRefCoordinates remoteRefCoordinates = (RemoteRefCoordinates)other;
            if (!Intrinsics.areEqual((Object)this.repository, (Object)remoteRefCoordinates.repository)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.remote, (Object)remoteRefCoordinates.remote)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.refspec, (Object)remoteRefCoordinates.refspec);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000b\u0010\u0010\u001a\u00070\n\u00a2\u0006\u0002\b\u0011J\u0006\u0010\u0012\u001a\u00020\u000fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "", "results", "", "Lgit4idea/repo/GitRemote;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "(Ljava/util/Map;)V", "getResults", "()Ljava/util/Map;", "error", "", "Lorg/jetbrains/annotations/Nls;", "multiRemoteMessage", "Lcom/intellij/dvcs/MultiMessage;", "remoteInPrefix", "", "prunedRefs", "Lcom/intellij/openapi/util/NlsSafe;", "totallySuccessful", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitFetchSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$RepoResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n1726#2,3:354\n*S KotlinDebug\n*F\n+ 1 GitFetchSupportImpl.kt\ngit4idea/fetch/GitFetchSupportImpl$RepoResult\n*L\n252#1:354,3\n*E\n"})
    private static final class RepoResult {
        @NotNull
        private final Map<GitRemote, SingleRemoteResult> results;

        public RepoResult(@NotNull Map<GitRemote, SingleRemoteResult> results) {
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.results = results;
        }

        @NotNull
        public final Map<GitRemote, SingleRemoteResult> getResults() {
            return this.results;
        }

        public final boolean totallySuccessful() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.results.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        SingleRemoteResult it = (SingleRemoteResult)element$iv;
                        boolean bl2 = false;
                        if (it.success()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public final String error() {
            MultiMessage<GitRemote> errorMessage = this.multiRemoteMessage(true);
            for (Map.Entry<GitRemote, SingleRemoteResult> entry : this.results.entrySet()) {
                GitRemote remote = entry.getKey();
                SingleRemoteResult result2 = entry.getValue();
                if (result2.getError() == null) continue;
                errorMessage.append((Object)remote, result2.getError());
            }
            return errorMessage.asString();
        }

        @NotNull
        public final String prunedRefs() {
            MultiMessage<GitRemote> prunedRefs = this.multiRemoteMessage(false);
            for (Map.Entry<GitRemote, SingleRemoteResult> entry : this.results.entrySet()) {
                GitRemote remote = entry.getKey();
                SingleRemoteResult result2 = entry.getValue();
                if (!(!((Collection)result2.getPrunedRefs()).isEmpty())) continue;
                prunedRefs.append((Object)remote, CollectionsKt.joinToString$default((Iterable)result2.getPrunedRefs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            return prunedRefs.asString();
        }

        private final MultiMessage<GitRemote> multiRemoteMessage(boolean remoteInPrefix) {
            return new MultiMessage((Collection)this.results.keySet(), (Function1)multiRemoteMessage.1.INSTANCE, (Function1)multiRemoteMessage.2.INSTANCE, remoteInPrefix, false, 16, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0018\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "error", "", "Lorg/jetbrains/annotations/Nls;", "prunedRefs", "", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/lang/String;Ljava/util/List;)V", "getError", "()Ljava/lang/String;", "getPrunedRefs", "()Ljava/util/List;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "success", "", "intellij.vcs.git"})
    private static final class SingleRemoteResult {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @Nullable
        private final String error;
        @NotNull
        private final List<String> prunedRefs;

        public SingleRemoteResult(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String error, @NotNull List<String> prunedRefs) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter(prunedRefs, (String)"prunedRefs");
            this.repository = repository;
            this.remote = remote;
            this.error = error;
            this.prunedRefs = prunedRefs;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final List<String> getPrunedRefs() {
            return this.prunedRefs;
        }

        public final boolean success() {
            return this.error == null;
        }
    }
}

