/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.LibraryUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMethodParameterCountInspectionBase
extends GroovyMethodMetricInspection {
    public GroovyMethodParameterCountInspectionBase() {
        super(5);
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.method.ref.contains.too.many.parameters.0.1", args[0], args[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            if (grMethod == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(grMethod);
            GrParameter[] parameters2 = grMethod.getParameters();
            int limit = GroovyMethodParameterCountInspectionBase.this.getLimit();
            if (parameters2.length <= limit) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(grMethod)) {
                return;
            }
            this.registerMethodError(grMethod, parameters2.length, limit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethod", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMethodParameterCountInspectionBase$Visitor", "visitMethod"));
        }
    }
}

