/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.aliasImport;

import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.aliasImport.AliasImportIntentionPredicate;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrImportAlias;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GrAliasImportIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        PsiMember resolved;
        GrImportStatement context;
        if (element == null) {
            GrAliasImportIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GrAliasImportIntention.$$$reportNull$$$0(1);
        }
        if (element instanceof GrReferenceExpression) {
            GrReferenceExpression ref2 = (GrReferenceExpression)element;
            GroovyResolveResult result2 = ref2.advancedResolve();
            context = (GrImportStatement)result2.getCurrentFileResolveContext();
            assert (context != null);
            resolved = (PsiMember)result2.getElement();
        } else if (element instanceof GrImportStatement) {
            context = (GrImportStatement)element;
            GrCodeReferenceElement reference = context.getImportReference();
            assert (reference != null);
            resolved = (PsiMember)reference.resolve();
        } else {
            return;
        }
        assert (resolved != null);
        GrAliasImportIntention.doRefactoring(project, context, resolved);
    }

    private static void doRefactoring(@NotNull Project project, @NotNull GrImportStatement importStatement, @NotNull PsiMember member) {
        if (project == null) {
            GrAliasImportIntention.$$$reportNull$$$0(2);
        }
        if (importStatement == null) {
            GrAliasImportIntention.$$$reportNull$$$0(3);
        }
        if (member == null) {
            GrAliasImportIntention.$$$reportNull$$$0(4);
        }
        if (member instanceof GrAccessorMethod && !importStatement.isOnDemand() && !Objects.equals(importStatement.getImportedName(), member.getName())) {
            member = ((GrAccessorMethod)member).getProperty();
        }
        GroovyFileBase file = (GroovyFileBase)importStatement.getContainingFile();
        List<UsageInfo> usages = GrAliasImportIntention.findUsages(member, file);
        GrImportStatement templateImport = GrAliasImportIntention.createTemplateImport(project, member, file);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!importStatement.isOnDemand()) {
                importStatement.delete();
            }
            GrAliasImportIntention.updateRefs(usages, member.getName(), templateImport);
        } else {
            GrAliasImportIntention.runTemplate(project, importStatement, member, file, usages, templateImport);
        }
    }

    private static GrImportStatement createTemplateImport(Project project, PsiMember resolved, GroovyFileBase file) {
        PsiClass aClass = resolved.getContainingClass();
        assert (aClass != null);
        String qname = aClass.getQualifiedName();
        String name = resolved.getName();
        GrImportStatement template = GroovyPsiElementFactory.getInstance(project).createImportStatementFromText("import static " + qname + "." + name + " as aliased");
        return file.addImport(template);
    }

    private static void runTemplate(Project project, GrImportStatement context, PsiMember resolved, final GroovyFileBase file, final List<UsageInfo> usages, GrImportStatement templateImport) {
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting();
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)templateImport);
        LinkedHashSet<String> names = GrAliasImportIntention.getSuggestedNames((PsiElement)resolved, context);
        GrImportAlias alias = templateImport.getAlias();
        assert (alias != null);
        PsiElement aliasNameElement = alias.getNameElement();
        assert (aliasNameElement != null);
        MyLookupExpression lookupExpression = new MyLookupExpression(resolved.getName(), names, (PsiNamedElement)resolved, (PsiElement)resolved, true, null);
        lookupExpression.setLookupFocusDegree(LookupFocusDegree.UNFOCUSED);
        templateBuilder.replaceElement(aliasNameElement, (Expression)lookupExpression);
        Template built = templateBuilder.buildTemplate();
        Editor newEditor = IntentionUtils.positionCursor(project, file, templateImport);
        Document document = newEditor.getDocument();
        final RangeMarker contextImportPointer = document.createRangeMarker(context.getTextRange());
        final TextRange range = templateImport.getTextRange();
        document.deleteString(range.getStartOffset(), range.getEndOffset());
        final String name = resolved.getName();
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, built, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                GrImportStatement importStatement = (GrImportStatement)ReadAction.compute(() -> (GrImportStatement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)range.getStartOffset(), GrImportStatement.class, (boolean)true));
                if (brokenOff) {
                    if (importStatement != null) {
                        ApplicationManager.getApplication().runWriteAction(() -> importStatement.delete());
                    }
                    return;
                }
                GrAliasImportIntention.updateRefs(usages, name, importStatement);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    GrImportStatement context1 = (GrImportStatement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)contextImportPointer.getStartOffset(), (int)contextImportPointer.getEndOffset(), GrImportStatement.class);
                    if (context1 != null) {
                        context1.delete();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/groovy/intentions/aliasImport/GrAliasImportIntention$1", "templateFinished"));
            }
        });
    }

    private static void updateRefs(List<UsageInfo> usages, String memberName, GrImportStatement updatedImport) {
        if (updatedImport == null) {
            return;
        }
        String name = (String)ReadAction.compute(() -> updatedImport.getImportedName());
        for (UsageInfo usage : usages) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                GrReferenceElement ref2;
                PsiElement qualifier;
                PsiElement usageElement = usage.getElement();
                if (usageElement == null) {
                    return;
                }
                if (usageElement.getParent() instanceof GrImportStatement) {
                    return;
                }
                if (usageElement instanceof GrReferenceElement && (qualifier = (ref2 = (GrReferenceElement)usageElement).getQualifier()) == null) {
                    String refName = ref2.getReferenceName();
                    if (refName == null) {
                        return;
                    }
                    if (memberName.equals(refName)) {
                        ref2.handleElementRename(name);
                    } else if (refName.equals(GroovyPropertyUtils.getPropertyNameByAccessorName(memberName))) {
                        String newPropName = GroovyPropertyUtils.getPropertyNameByAccessorName(name);
                        if (newPropName != null) {
                            ref2.handleElementRename(newPropName);
                        } else {
                            ref2.handleElementRename(name);
                        }
                    } else if (refName.equals(GroovyPropertyUtils.getGetterNameBoolean(memberName))) {
                        String getterName = GroovyPropertyUtils.getGetterNameBoolean(name);
                        ref2.handleElementRename(getterName);
                    } else if (refName.equals(GroovyPropertyUtils.getGetterNameNonBoolean(memberName))) {
                        String getterName = GroovyPropertyUtils.getGetterNameNonBoolean(name);
                        ref2.handleElementRename(getterName);
                    } else if (refName.equals(GroovyPropertyUtils.getSetterName(memberName))) {
                        String getterName = GroovyPropertyUtils.getSetterName(name);
                        ref2.handleElementRename(getterName);
                    }
                }
            });
        }
    }

    private static List<UsageInfo> findUsages(PsiMember member, GroovyFileBase file) {
        LocalSearchScope scope = new LocalSearchScope((PsiElement)file);
        ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>();
        HashSet usedRefs = new HashSet();
        Processor consumer = reference -> {
            if (usedRefs.add(reference)) {
                infos.add(new UsageInfo(reference));
            }
            return true;
        };
        if (member instanceof PsiMethod) {
            MethodReferencesSearch.search((PsiMethod)((PsiMethod)member), (SearchScope)scope, (boolean)false).forEach(consumer);
        } else {
            ReferencesSearch.search((PsiElement)member, (SearchScope)scope).forEach(consumer);
            if (member instanceof PsiField) {
                PsiMethod setter;
                PsiMethod getter = GroovyPropertyUtils.findGetterForField((PsiField)member);
                if (getter != null) {
                    MethodReferencesSearch.search((PsiMethod)getter, (SearchScope)scope, (boolean)false).forEach(consumer);
                }
                if ((setter = GroovyPropertyUtils.findSetterForField((PsiField)member)) != null) {
                    MethodReferencesSearch.search((PsiMethod)setter, (SearchScope)scope, (boolean)false).forEach(consumer);
                }
            }
        }
        return infos;
    }

    public static LinkedHashSet<String> getSuggestedNames(PsiElement psiElement, PsiElement nameSuggestionContext) {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        result2.add(UsageViewUtil.getShortName((PsiElement)psiElement));
        NameSuggestionProvider.suggestNames((PsiElement)psiElement, (PsiElement)nameSuggestionContext, result2);
        return result2;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AliasImportIntentionPredicate aliasImportIntentionPredicate = AliasImportIntentionPredicate.INSTANCE;
        if (aliasImportIntentionPredicate == null) {
            GrAliasImportIntention.$$$reportNull$$$0(5);
        }
        return aliasImportIntentionPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/aliasImport/GrAliasImportIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/aliasImport/GrAliasImportIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

