/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

public class ConvertJunitAssertionToAssertStatementIntention
extends Intention
implements PsiElementPredicate {
    @Nullable
    private static String getReplacementStatement(@NotNull PsiMethod method, @NotNull GrMethodCall methodCall) {
        PsiClass containingClass;
        if (method == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(0);
        }
        if (methodCall == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(1);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            return null;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (!"junit.framework.Assert".equals(qualifiedName) && !"groovy.util.GroovyTestCase".equals(qualifiedName)) {
            return null;
        }
        String[] replacementStatements = Holder.ourStatementMap.get(method.getName());
        if (replacementStatements == null) {
            return null;
        }
        GrArgumentList argumentList = methodCall.getArgumentList();
        if (argumentList.getNamedArguments().length > 0) {
            return null;
        }
        GrExpression[] arguments2 = argumentList.getExpressionArguments();
        if (arguments2.length >= replacementStatements.length) {
            return null;
        }
        return replacementStatements[arguments2.length];
    }

    @Nullable
    private static GrStatement getReplacementElement(@NotNull PsiMethod method, @NotNull GrMethodCall methodCall) {
        String replacementStatement;
        if (method == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(2);
        }
        if (methodCall == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(3);
        }
        if ((replacementStatement = ConvertJunitAssertionToAssertStatementIntention.getReplacementStatement(method, methodCall)) == null) {
            return null;
        }
        final GrExpression[] arguments2 = methodCall.getArgumentList().getExpressionArguments();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
        GrAssertStatement statement = (GrAssertStatement)factory.createStatementFromText(replacementStatement);
        final HashMap replaceMap = new HashMap();
        statement.acceptChildren(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitExpression(@NotNull GrExpression expression) {
                Matcher matcher;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((matcher = Holder.PATTERN.matcher(expression.getText())).matches()) {
                    int index = Integer.parseInt(matcher.group(1));
                    replaceMap.put(expression, arguments2[index]);
                } else {
                    super.visitExpression(expression);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertJunitAssertionToAssertStatementIntention$1", "visitExpression"));
            }
        });
        for (Map.Entry entry : replaceMap.entrySet()) {
            ((GrExpression)entry.getKey()).replaceWithExpression((GrExpression)entry.getValue(), true);
        }
        return statement;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrMethodCall methodCall;
        PsiMethod method;
        if (element == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(5);
        }
        if ((method = (methodCall = (GrMethodCall)element).resolveMethod()) == null) {
            return;
        }
        GrStatement replacementElement = ConvertJunitAssertionToAssertStatementIntention.getReplacementElement(method, methodCall);
        if (replacementElement == null) {
            return;
        }
        ((GrMethodCall)element).replaceWithStatement(replacementElement);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertJunitAssertionToAssertStatementIntention convertJunitAssertionToAssertStatementIntention = this;
        if (convertJunitAssertionToAssertStatementIntention == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(6);
        }
        return convertJunitAssertionToAssertStatementIntention;
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            ConvertJunitAssertionToAssertStatementIntention.$$$reportNull$$$0(7);
        }
        if (!(element instanceof GrMethodCall)) {
            return false;
        }
        GrMethodCall methodCall = (GrMethodCall)element;
        PsiMethod method = methodCall.resolveMethod();
        if (method == null) {
            return false;
        }
        return ConvertJunitAssertionToAssertStatementIntention.getReplacementStatement(method, methodCall) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/conversions/ConvertJunitAssertionToAssertStatementIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/ConvertJunitAssertionToAssertStatementIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementStatement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "satisfiedBy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        private static final Pattern PATTERN = Pattern.compile("arg(\\d+)");
        private static final Map<String, String[]> ourStatementMap = Map.of("assertNotNull", new String[]{null, "assert arg0 != null", "assert arg1 != null : arg0"}, "assertNull", new String[]{null, "assert arg0 == null", "assert arg1 == null : arg0"}, "assertTrue", new String[]{null, "assert arg0", "assert arg1 : arg0"}, "assertFalse", new String[]{null, "assert !arg0", "assert !arg1 : arg0"}, "assertEquals", new String[]{null, null, "assert arg0 == arg1", "assert arg1 == arg2 : arg0"}, "assertSame", new String[]{null, null, "assert arg0.is(arg1)", "assert arg1.is(arg2) : arg0"}, "assertNotSame", new String[]{null, null, "assert !arg0.is(arg1)", "assert !arg1.is(arg2) : arg0"});

        private Holder() {
        }
    }
}

