/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyDummyElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyPsiElementFactoryImpl
extends GroovyPsiElementFactory {
    private static final Logger LOG = Logger.getInstance(GroovyPsiElementFactoryImpl.class);
    private final Project myProject;
    private final PsiManager myManager;

    public GroovyPsiElementFactoryImpl(Project project) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    @Override
    @NotNull
    public PsiElement createReferenceNameFromText(@NotNull String refName) {
        GroovyFile file;
        GrTopStatement statement;
        if (refName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(0);
        }
        if (!((statement = (file = this.createGroovyFileChecked("a." + refName)).getTopStatements()[0]) instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        PsiElement element = ((GrReferenceExpression)statement).getReferenceNameElement();
        if (element == null) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createDocMemberReferenceNameFromText(@NotNull String idText) {
        GrDocMemberReference reference;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((reference = this.createDocMemberReferenceFromText("Foo", idText)) != null, (Object)idText);
        GrDocTagValueToken grDocTagValueToken = reference.getReferenceNameElement();
        if (grDocTagValueToken == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(3);
        }
        return grDocTagValueToken;
    }

    @Override
    @NotNull
    public GrDocMemberReference createDocMemberReferenceFromText(@NotNull String className, @NotNull String text) {
        if (className == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(4);
        }
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(5);
        }
        GroovyFile file = this.createGroovyFileChecked("/** @see " + className + "#" + text + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        GrDocMemberReference grDocMemberReference = (GrDocMemberReference)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocMemberReference.class);
        if (grDocMemberReference == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(6);
        }
        return grDocMemberReference;
    }

    @Override
    @NotNull
    public GrDocReferenceElement createDocReferenceElementFromFQN(@NotNull String qName) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(7);
        }
        GroovyFile file = this.createGroovyFileChecked("/** @see " + qName + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        GrDocReferenceElement grDocReferenceElement = (GrDocReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocReferenceElement.class);
        if (grDocReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(8);
        }
        return grDocReferenceElement;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReference(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(9);
        }
        return this.createElementFromText(text, context, GroovyElementTypes.CODE_REFERENCE, GrCodeReferenceElement.class);
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText) {
        GroovyFile file;
        GrTopStatement[] statements2;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(10);
        }
        if ((statements2 = (file = this.createGroovyFileChecked(idText)).getTopStatements()).length != 1 || !(statements2[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException(idText);
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)statements2[0];
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(11);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText, PsiElement context) {
        GroovyFile file;
        GrTopStatement[] statements2;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(12);
        }
        if ((statements2 = (file = this.createGroovyFileChecked(idText, false, context)).getTopStatements()).length != 1) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        if (!(statements2[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)statements2[0];
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(13);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceElementForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(14);
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        GrReferenceExpression grReferenceExpression = this.createReferenceExpressionFromText(text);
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(15);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrExpression createExpressionFromText(@NotNull String text, PsiElement context) {
        GroovyFile file;
        GrTopStatement[] topStatements;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(16);
        }
        if ((topStatements = (file = this.createGroovyFile(text, false, context)).getTopStatements()).length == 0 || !(topStatements[0] instanceof GrExpression)) {
            throw new IncorrectOperationException("incorrect expression = '" + text + "'");
        }
        GrExpression grExpression = (GrExpression)topStatements[0];
        if (grExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(17);
        }
        return grExpression;
    }

    @NotNull
    public GrCodeReferenceElement createReferenceElementByType(PsiClassType type2) {
        if (type2 instanceof GrClassReferenceType) {
            GrCodeReferenceElement grCodeReferenceElement = ((GrClassReferenceType)type2).getReference();
            if (grCodeReferenceElement == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(18);
            }
            return grCodeReferenceElement;
        }
        PsiClassType.ClassResolveResult resolveResult2 = type2.resolveGenerics();
        PsiClass refClass = resolveResult2.getElement();
        assert (refClass != null) : type2;
        GrCodeReferenceElement grCodeReferenceElement = this.createCodeReference(type2.getCanonicalText());
        if (grCodeReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(19);
        }
        return grCodeReferenceElement;
    }

    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = this.createMethodFromText("def <> void foo(){}").getTypeParameterList();
        if (psiTypeParameterList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(20);
        }
        return psiTypeParameterList;
    }

    @NotNull
    public PsiTypeParameter createTypeParameter(@NotNull String name, PsiClassType @NotNull [] superTypes) {
        PsiTypeParameter psiTypeParameter;
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(21);
        }
        if (superTypes == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(22);
        }
        @NlsSafe StringBuilder builder = new StringBuilder();
        builder.append("def <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type2 : superTypes) {
                if (type2.equalsToText("java.lang.Object")) continue;
                builder.append(type2.getCanonicalText()).append(',');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            psiTypeParameter = this.createMethodFromText(builder).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder);
        }
        if (psiTypeParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(23);
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(String @Nullable [] modifiers, @Nullable GrExpression initializer, @Nullable PsiType type2, String ... identifiers) {
        String initializerText;
        if (initializer != null) {
            if (initializer instanceof GrApplicationStatement && !GroovyConfigUtils.getInstance().isVersionAtLeast(initializer, "1.8", false)) {
                initializer = this.createMethodCallByAppCall((GrApplicationStatement)initializer);
            }
            assert (initializer != null);
            initializerText = initializer.getText();
        } else {
            initializerText = null;
        }
        GrVariableDeclaration grVariableDeclaration = this.createVariableDeclaration(modifiers, initializerText, type2, identifiers);
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(24);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(String @Nullable [] modifiers, @Nullable String initializer, @Nullable PsiType type2, String ... identifiers) {
        GrTopStatement grTopStatement;
        GrTopStatement[] topStatements;
        @NlsSafe StringBuilder text = GroovyPsiElementFactoryImpl.writeModifiers(modifiers);
        if (type2 != null && type2 != PsiTypes.nullType()) {
            PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type2);
            String typeText = GroovyPsiElementFactoryImpl.getTypeText(unboxed);
            text.append(typeText).append(" ");
        } else if (text.length() == 0) {
            text.insert(0, "def ");
        }
        if (identifiers.length > 1 && initializer != null) {
            text.append('(');
        }
        text.append(String.join((CharSequence)", ", identifiers));
        if (identifiers.length > 1 && initializer != null) {
            text.append(')');
        }
        if (!StringUtil.isEmptyOrSpaces((String)initializer)) {
            text.append(" = ").append(initializer);
        }
        if ((topStatements = this.createGroovyFileChecked(text).getTopStatements()).length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            topStatements = this.createGroovyFileChecked("def " + text).getTopStatements();
        }
        if (topStatements.length == 0 || !((grTopStatement = topStatements[0]) instanceof GrVariableDeclaration)) {
            throw new RuntimeException("Invalid arguments, text = " + text);
        }
        GrVariableDeclaration statement = (GrVariableDeclaration)grTopStatement;
        CodeEditUtil.markToReformatBefore((ASTNode)statement.getNode().findLeafElementAt(0), (boolean)true);
        GrVariableDeclaration grVariableDeclaration = statement;
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(25);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrEnumConstant createEnumConstantFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(26);
        }
        GroovyFile file = this.createGroovyFileChecked("enum E{" + text + "}");
        GrEnumTypeDefinition enumClass = (GrEnumTypeDefinition)file.getClasses()[0];
        GrEnumConstant grEnumConstant = enumClass.getEnumConstants()[0];
        if (grEnumConstant == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(27);
        }
        return grEnumConstant;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclaration(String @NotNull [] modifiers, @NotNull String identifier, @Nullable GrExpression initializer, @Nullable PsiType type2) {
        String varDeclaration;
        GroovyFile file;
        GrTypeDefinitionBody body;
        if (identifier == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(28);
        }
        if (modifiers == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(29);
        }
        LOG.assertTrue((body = (file = this.createGroovyFileChecked("class A { " + (varDeclaration = this.createVariableDeclaration(modifiers, initializer, type2, identifier).getText()) + "}")).getTypeDefinitions()[0].getBody()).getMemberDeclarations().length == 1 && body.getMemberDeclarations()[0] instanceof GrVariableDeclaration, (Object)("ident = <" + identifier + "> initializer = " + (String)(initializer == null ? "_null_" : "<" + initializer.getText() + ">")));
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)body.getMemberDeclarations()[0];
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(30);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclarationFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(31);
        }
        GroovyFile file = this.createGroovyFileChecked("class X{\n" + text + "\n}");
        PsiClass psiClass = file.getClasses()[0];
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)psiClass.getFields()[0].getParent();
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(32);
        }
        return grVariableDeclaration;
    }

    private static StringBuilder writeModifiers(String[] modifiers) {
        StringBuilder text = new StringBuilder();
        if (modifiers != null && modifiers.length != 0) {
            for (String modifier : modifiers) {
                text.append(modifier);
                text.append(" ");
            }
        }
        return text;
    }

    private static String getTypeText(PsiType type2) {
        if (!(type2 instanceof PsiArrayType)) {
            String text;
            String canonical = type2.getCanonicalText();
            String string = text = canonical != null ? canonical : type2.getPresentableText();
            if ("null".equals(text)) {
                return "";
            }
            return text;
        }
        return GroovyPsiElementFactoryImpl.getTypeText(((PsiArrayType)type2).getComponentType()) + "[]";
    }

    @Override
    @NotNull
    public GrTopStatement createTopElementFromText(@NotNull String text) {
        GroovyFile dummyFile;
        GrTopStatement[] topStatements;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(33);
        }
        if ((topStatements = (dummyFile = this.createGroovyFileChecked(text)).getTopStatements()).length != 1) {
            throw new IncorrectOperationException("text = '" + text + "'");
        }
        GrTopStatement grTopStatement = topStatements[0];
        if (grTopStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(34);
        }
        return grTopStatement;
    }

    @Override
    @NotNull
    public GrClosableBlock createClosureFromText(@NotNull String closureText, PsiElement context) throws IncorrectOperationException {
        if (closureText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(35);
        }
        return this.createElementFromText(closureText, context, (IElementType)GroovyElementTypes.CLOSURE, GrClosableBlock.class);
    }

    @Override
    @NotNull
    public GrLambdaExpression createLambdaFromText(@NotNull String lambdaText, PsiElement context) throws IncorrectOperationException {
        if (lambdaText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(36);
        }
        return this.createElementFromText(lambdaText, context, GroovyElementTypes.LAMBDA_EXPRESSION, GrLambdaExpression.class);
    }

    private GroovyFileImpl createDummyFile(@NotNull CharSequence text, boolean physical) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(37);
        }
        String fileName = "DUMMY__1234567890_DUMMYYYYYY___." + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
        long stamp = System.currentTimeMillis();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        return (GroovyFileImpl)factory.createFileFromText(fileName, (FileType)GroovyFileType.GROOVY_FILE_TYPE, text, stamp, physical);
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull String name, @Nullable String typeText, @Nullable String initializer, @Nullable GroovyPsiElement context, String ... modifiers) throws IncorrectOperationException {
        GrParameter grParameter;
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(38);
        }
        try {
            @NonNls StringBuilder fileText = new StringBuilder();
            fileText.append("def dsfsadfnbhfjks_weyripouh_huihnrecuio(");
            for (String modifier : modifiers) {
                fileText.append(modifier).append(' ');
            }
            if (StringUtil.isNotEmpty((String)typeText)) {
                fileText.append(typeText).append(' ');
            }
            fileText.append(name);
            if (initializer != null && !initializer.isEmpty()) {
                fileText.append(" = ").append(initializer);
            }
            fileText.append("){}");
            GroovyFile groovyFile = this.createGroovyFileChecked(fileText, false, context);
            ASTNode node = groovyFile.getFirstChild().getNode();
            grParameter = ((GrMethod)node.getPsi()).getParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("name = " + name + ", type = " + typeText + ", initializer = " + initializer);
        }
        if (grParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(39);
        }
        return grParameter;
    }

    @Override
    @NotNull
    public GrTypeDefinition createTypeDefinition(@NotNull String text) throws IncorrectOperationException {
        GroovyFile file;
        GrTypeDefinition[] classes2;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(40);
        }
        if ((classes2 = (file = this.createGroovyFileChecked(text)).getTypeDefinitions()).length != 1) {
            throw new IncorrectOperationException("Incorrect type definition text");
        }
        GrTypeDefinition grTypeDefinition = classes2[0];
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(41);
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull String typeText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (typeText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(42);
        }
        return this.createElementFromText(typeText, context, GroovyElementTypes.TYPE_ELEMENT, GrTypeElement.class);
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull PsiType type2) throws IncorrectOperationException {
        String typeText;
        if (type2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(43);
        }
        if ((typeText = GroovyPsiElementFactoryImpl.getTypeText(type2)) == null) {
            throw new IncorrectOperationException("Cannot create type element: cannot obtain text for type");
        }
        GrTypeElement grTypeElement = this.createTypeElement(typeText);
        if (grTypeElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(44);
        }
        return grTypeElement;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(45);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(46);
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public GrParenthesizedExpression createParenthesizedExpr(@NotNull GrExpression expression, @Nullable PsiElement context) {
        if (expression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(47);
        }
        GrParenthesizedExpression grParenthesizedExpression = (GrParenthesizedExpression)this.createExpressionFromText("(" + expression.getText() + ")", context);
        if (grParenthesizedExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(48);
        }
        return grParenthesizedExpression;
    }

    @Override
    @NotNull
    public PsiElement createStringLiteralForReference(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(49);
        }
        PsiElement psiElement = this.createLiteralFromValue(text).getFirstChild();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(50);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createModifierFromText(@NotNull String name) {
        GroovyFile file;
        GrTopStatement[] definitions;
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(51);
        }
        if ((definitions = (file = this.createGroovyFileChecked(name + " foo() {}")).getTopStatements()).length != 1) {
            throw new IncorrectOperationException(name);
        }
        PsiElement psiElement = definitions[0].getFirstChild().getFirstChild();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(52);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrCodeBlock createMethodBodyFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(53);
        }
        GroovyFile file = this.createGroovyFileChecked("def foo () {" + text + "}");
        GrMethod method = (GrMethod)file.getTopStatements()[0];
        GrOpenBlock grOpenBlock = method.getBlock();
        if (grOpenBlock == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(54);
        }
        return grOpenBlock;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createSimpleVariableDeclaration(@NotNull String name, @NotNull String typeText) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(55);
        }
        if (typeText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(56);
        }
        String classText = Character.isLowerCase(typeText.charAt(0)) ? "class A { def " + typeText + " " + name + "}" : "class A { " + typeText + " " + name + "}";
        GroovyFile file = this.createGroovyFileChecked(classText);
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)body.getMemberDeclarations()[0];
        if (grVariableDeclaration == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(57);
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public PsiElement createDotToken(@NotNull String newDot) {
        if (newDot == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(58);
        }
        PsiElement psiElement = this.createReferenceExpressionFromText("a" + newDot + "b").getDotToken();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(59);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(@NotNull String constructorName, String @Nullable [] paramTypes, String @NotNull [] paramNames, @Nullable String body, @Nullable PsiElement context) {
        if (constructorName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(60);
        }
        if (paramNames == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(61);
        }
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(null, constructorName, null, paramTypes, paramNames, body, true);
        GrMethod grMethod = this.createConstructorFromText(constructorName, text, context);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(62);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(String constructorName, CharSequence constructorText, @Nullable PsiElement context) {
        GroovyFile file = this.createGroovyFileChecked("class " + constructorName + "{" + constructorText + "}", false, context);
        GrTypeDefinition definition = file.getTypeDefinitions()[0];
        if (definition == null) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        GrMethod[] methods = definition.getCodeMethods();
        if (methods.length != 1) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        GrMethod grMethod = methods[0];
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(63);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(String methodText, @Nullable PsiElement context) {
        if (methodText == null) {
            throw new IncorrectOperationException("Method text not provided");
        }
        GroovyFile file = this.createGroovyFile(methodText, false, context);
        GrTopStatement[] definitions = file.getTopStatements();
        if (definitions.length != 1) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        GrTopStatement definition = definitions[0];
        if (!(definition instanceof GrMethod)) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        GrMethod grMethod = (GrMethod)definition;
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(64);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull @NonNls String annotationText, @Nullable PsiElement context) {
        if (annotationText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(65);
        }
        return this.createElementFromText(annotationText, context, (IElementType)GroovyElementTypes.ANNOTATION, GrAnnotation.class);
    }

    @Override
    @NotNull
    public GrAnnotationNameValuePair createAnnotationAttribute(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(66);
        }
        return this.createElementFromText(text, context, (IElementType)GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR, GrAnnotationNameValuePair.class);
    }

    @Override
    @NotNull
    public GrMethod createMethodFromSignature(@NotNull String name, @NotNull GrSignature signature) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(67);
        }
        if (signature == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(68);
        }
        StringBuilder builder = new StringBuilder("public");
        PsiType returnType2 = signature.getReturnType();
        if (returnType2 != null && returnType2 != PsiTypes.nullType()) {
            builder.append(' ');
            builder.append(returnType2.getCanonicalText());
        }
        builder.append(' ').append(name).append('(');
        int i2 = 0;
        for (GrClosureParameter parameter : signature.getParameters()) {
            PsiType type2 = parameter.getType();
            if (type2 != null) {
                builder.append(type2.getCanonicalText());
                builder.append(' ');
            }
            builder.append('p').append(++i2);
            GrExpression initializer = parameter.getDefaultInitializer();
            if (initializer == null) continue;
            builder.append(" = ").append(initializer.getText());
            builder.append(", ");
        }
        if (signature.getParameterCount() > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("){}");
        GrMethod grMethod = this.createMethodFromText(builder);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(69);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull String annoText) {
        if (annoText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(70);
        }
        GrAnnotation grAnnotation = this.createAnnotationFromText(annoText, null);
        if (grAnnotation == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(71);
        }
        return grAnnotation;
    }

    private GroovyFile createGroovyFileChecked(@NlsSafe @NotNull CharSequence idText) {
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(72);
        }
        return this.createGroovyFileChecked(idText, false, null);
    }

    private GroovyFile createGroovyFileChecked(@NlsSafe @NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        GroovyFileImpl file;
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(73);
        }
        if (ErrorUtil.containsError(file = this.createDummyFile(idText, isPhysical))) {
            throw new IncorrectOperationException("cannot create file from text: " + idText);
        }
        file.setContext(context);
        return file;
    }

    @Override
    @NotNull
    public GroovyFile createGroovyFile(@NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        if (idText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(74);
        }
        GroovyFileImpl file = this.createDummyFile(idText, isPhysical);
        file.setContext(context);
        GroovyFileImpl groovyFileImpl = file;
        if (groovyFileImpl == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(75);
        }
        return groovyFileImpl;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpace() {
        GroovyFileImpl dummyFile = this.createDummyFile(" ", false);
        PsiElement psiElement = dummyFile.getFirstChild();
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(76);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(int length) {
        String text;
        String string = text = length <= 1 ? "\n" : "";
        if (length > 1) {
            text = StringUtil.repeatSymbol((char)'\n', (int)length);
        }
        PsiElement psiElement = this.createLineTerminator(text);
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(77);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(78);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        PsiElement child = dummyFile.getFirstChild();
        assert (child != null);
        PsiElement psiElement = child;
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(79);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrArgumentList createExpressionArgumentList(GrExpression ... expressions) {
        @NonNls StringBuilder text = new StringBuilder();
        text.append("ven (");
        for (GrExpression expression : expressions) {
            text.append(expression.getText()).append(", ");
        }
        if (expressions.length > 0) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(')');
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        GrArgumentList grArgumentList = ((GrMethodCallExpression)file.getChildren()[0]).getArgumentList();
        if (grArgumentList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(80);
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrNamedArgument createNamedArgument(@NotNull String name, @NotNull GrExpression expression) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(81);
        }
        if (expression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(82);
        }
        GroovyFile file = this.createGroovyFileChecked("foo (" + name + ":" + expression.getText() + ")");
        assert (file.getChildren()[0] != null);
        GrCall call = (GrCall)file.getChildren()[0];
        GrNamedArgument grNamedArgument = call.getArgumentList().getNamedArguments()[0];
        if (grNamedArgument == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(83);
        }
        return grNamedArgument;
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(84);
        }
        GrStatement grStatement = this.createStatementFromText(text, null);
        if (grStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(85);
        }
        return grStatement;
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text, @Nullable PsiElement context) {
        GroovyFile file;
        GrTopStatement[] statements2;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(86);
        }
        if ((statements2 = (file = this.createGroovyFileChecked(text, false, context)).getTopStatements()).length != 1) {
            throw new IncorrectOperationException("count = " + statements2.length + ", " + text);
        }
        if (!(statements2[0] instanceof GrStatement)) {
            throw new IncorrectOperationException("type = " + statements2[0].getClass().getName() + ", " + text);
        }
        GrStatement grStatement = (GrStatement)statements2[0];
        if (grStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(87);
        }
        return grStatement;
    }

    @Override
    @NotNull
    public GrMethodCallExpression createMethodCallByAppCall(@NotNull GrApplicationStatement callExpr) {
        if (callExpr == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(88);
        }
        StringBuilder text = new StringBuilder();
        text.append(callExpr.getInvokedExpression().getText());
        text.append("(");
        GrCommandArgumentList argumentList = callExpr.getArgumentList();
        if (argumentList != null) {
            text.append(argumentList.getText());
        }
        text.append(")");
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        GrMethodCallExpression grMethodCallExpression = (GrMethodCallExpression)file.getChildren()[0];
        if (grMethodCallExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(89);
        }
        return grMethodCallExpression;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReferenceElementFromClass(@NotNull PsiClass aClass) {
        String qualifiedName;
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(90);
        }
        if ((qualifiedName = aClass.getQualifiedName()) == null) {
            throw new IncorrectOperationException("cannot create code reference element for class " + aClass.getText());
        }
        GrCodeReferenceElement grCodeReferenceElement = this.createCodeReference(qualifiedName);
        if (grCodeReferenceElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(91);
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrReferenceExpression createThisExpression(@Nullable PsiClass psiClass) {
        String qname;
        Object text = psiClass == null ? "this" : (StringUtil.isEmpty((String)(qname = psiClass.getQualifiedName())) ? "this" : qname + ".this");
        GrReferenceExpression grReferenceExpression = this.createReferenceExpressionFromText((String)text, (PsiElement)psiClass);
        if (grReferenceExpression == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(92);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrBlockStatement createBlockStatementFromText(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(93);
        }
        return this.createElementFromText(text, context, GroovyElementTypes.BLOCK_STATEMENT, GrBlockStatement.class);
    }

    @Override
    @NotNull
    public GrModifierList createModifierList(@NotNull CharSequence text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(94);
        }
        GrMethod method = this.createMethodFromText(text + " void foo()");
        GrModifierList grModifierList = method.getModifierList();
        if (grModifierList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(95);
        }
        return grModifierList;
    }

    @Override
    @NotNull
    public GrCaseSection createSwitchSection(@NotNull String text) {
        GrStatement statement;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(96);
        }
        if (!((statement = this.createStatementFromText("switch (a) {\n" + text + "\n}")) instanceof GrSwitchElement)) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        GrCaseSection[] sections = ((GrSwitchElement)((Object)statement)).getCaseSections();
        if (sections.length != 1) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        GrCaseSection grCaseSection = sections[0];
        if (grCaseSection == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(97);
        }
        return grCaseSection;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String qName, boolean isStatic, boolean isOnDemand, String alias) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(98);
        }
        GrImportStatement grImportStatement = this.createImportStatement(qName, isStatic, isOnDemand, alias, null);
        if (grImportStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(99);
        }
        return grImportStatement;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(100);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        GrImportStatement grImportStatement = (GrImportStatement)dummyFile.getFirstChild();
        if (grImportStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(101);
        }
        return grImportStatement;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatement(@NotNull String qname, boolean isStatic, boolean isOnDemand, String alias, PsiElement context) {
        if (qname == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(102);
        }
        @NlsSafe StringBuilder builder = new StringBuilder();
        builder.append("import ");
        if (isStatic) {
            builder.append("static ");
        }
        builder.append(qname);
        if (isOnDemand) {
            builder.append(".*");
        }
        if (StringUtil.isNotEmpty((String)alias)) {
            builder.append(" as ").append(alias);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(builder, false, context);
        GrImportStatement grImportStatement = (GrImportStatement)dummyFile.getFirstChild();
        if (grImportStatement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(103);
        }
        return grImportStatement;
    }

    @NlsSafe
    private static CharSequence generateMethodText(@Nullable String modifier, @NotNull String name, @Nullable String type2, String @NotNull [] paramTypes, String @NotNull [] paramNames, @Nullable String body, boolean isConstructor) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(104);
        }
        if (paramTypes == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(105);
        }
        if (paramNames == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(106);
        }
        @NlsSafe StringBuilder builder = new StringBuilder();
        if (modifier != null) {
            builder.append(modifier);
            builder.append(" ");
        }
        if (!isConstructor) {
            builder.append("def ");
        }
        if (type2 != null) {
            builder.append(type2);
            builder.append(" ");
        }
        builder.append(name);
        builder.append("(");
        for (int i2 = 0; i2 < paramNames.length; ++i2) {
            String paramType;
            String string = paramType = paramTypes == null ? null : paramTypes[i2];
            if (i2 > 0) {
                builder.append(", ");
            }
            if (paramType != null) {
                builder.append(paramType);
                builder.append(" ");
            }
            builder.append(paramNames[i2]);
        }
        builder.append(")");
        if (body != null) {
            builder.append(body);
        } else {
            builder.append("{");
            builder.append("}");
        }
        return builder;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(@NotNull String modifier, @NotNull String name, @Nullable String type2, String @NotNull [] paramTypes, PsiElement context) {
        if (modifier == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(107);
        }
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(108);
        }
        if (paramTypes == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(109);
        }
        ArrayList<PsiType> res = new ArrayList<PsiType>();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (String paramType : paramTypes) {
            PsiType psiType;
            try {
                psiType = factory.createTypeElement(paramType).getType();
            }
            catch (IncorrectOperationException e) {
                psiType = TypesUtil.getJavaLangObject(context);
            }
            res.add(psiType);
        }
        String[] paramNames = GroovyNamesUtil.getMethodArgumentsNames(this.myProject, res.toArray(PsiType.createArray((int)res.size())));
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(modifier, name, type2, paramTypes, paramNames, null, false);
        GrMethod grMethod = this.createMethodFromText(text.toString(), context);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(110);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrDocComment createDocCommentFromText(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(111);
        }
        GrDocComment grDocComment = (GrDocComment)this.createGroovyFileChecked(text).getFirstChild();
        if (grDocComment == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(112);
        }
        return grDocComment;
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(113);
        }
        GrConstructorInvocation grConstructorInvocation = this.createConstructorInvocation(text, null);
        if (grConstructorInvocation == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(114);
        }
        return grConstructorInvocation;
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(115);
        }
        GroovyFile file = this.createGroovyFileChecked("class Foo{ def Foo(){" + text + "}}", false, context);
        GrConstructorInvocation grConstructorInvocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)file.getClasses()[0].getConstructors()[0]);
        if (grConstructorInvocation == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(116);
        }
        return grConstructorInvocation;
    }

    @Override
    @NotNull
    public PsiReferenceList createThrownList(PsiClassType @NotNull [] exceptionTypes) {
        if (exceptionTypes == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(117);
        }
        if (exceptionTypes.length == 0) {
            PsiReferenceList psiReferenceList = this.createMethodFromText("def foo(){}", null).getThrowsList();
            if (psiReferenceList == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(118);
            }
            return psiReferenceList;
        }
        String[] types = new String[exceptionTypes.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = exceptionTypes[i2].getCanonicalText();
        }
        String end = StringUtil.join((String[])types, (String)",");
        PsiReferenceList psiReferenceList = this.createMethodFromText("def foo() throws " + end + "{}", null).getThrowsList();
        if (psiReferenceList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(119);
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public GrCatchClause createCatchClause(@NotNull PsiClassType type2, @NotNull String parameterName) {
        if (type2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(120);
        }
        if (parameterName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(121);
        }
        @NonNls StringBuilder buffer = new StringBuilder("try{} catch(");
        if (type2 == null) {
            buffer.append("Throwable ");
        } else {
            buffer.append(type2.getCanonicalText()).append(" ");
        }
        buffer.append(parameterName).append("){\n}");
        GrTryCatchStatement statement = (GrTryCatchStatement)this.createStatementFromText(buffer);
        GrCatchClause grCatchClause = statement.getCatchClauses()[0];
        if (grCatchClause == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(122);
        }
        return grCatchClause;
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentList() {
        GrArgumentList grArgumentList = ((GrCall)((Object)this.createExpressionFromText("foo()"))).getArgumentList();
        if (grArgumentList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(123);
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentListFromText(@NotNull String argListText) {
        GrArgumentList grArgumentList;
        if (argListText == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(124);
        }
        try {
            grArgumentList = ((GrCall)((Object)this.createExpressionFromText("foo " + argListText))).getArgumentList();
        }
        catch (IncorrectOperationException e) {
            LOG.debug(argListText);
            throw e;
        }
        if (grArgumentList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(125);
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrExtendsClause createExtendsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A extends B {}");
        GrExtendsClause clause = typeDefinition.getExtendsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        GrExtendsClause grExtendsClause = clause;
        if (grExtendsClause == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(126);
        }
        return grExtendsClause;
    }

    @Override
    @NotNull
    public GrImplementsClause createImplementsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A implements B {}");
        GrImplementsClause clause = typeDefinition.getImplementsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        GrImplementsClause grImplementsClause = clause;
        if (grImplementsClause == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(127);
        }
        return grImplementsClause;
    }

    @Override
    @NotNull
    public GrLiteral createLiteralFromValue(@Nullable Object value2) {
        if (value2 instanceof String) {
            StringBuilder buffer = GrStringUtil.getLiteralTextByValue((String)value2);
            GrExpression expr = this.createExpressionFromText(buffer);
            LOG.assertTrue(expr instanceof GrLiteral, (Object)("value = " + value2));
            GrLiteral grLiteral = (GrLiteral)expr;
            if (grLiteral == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(128);
            }
            return grLiteral;
        }
        if (value2 == null) {
            GrLiteral grLiteral = (GrLiteral)this.createExpressionFromText("null");
            if (grLiteral == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(129);
            }
            return grLiteral;
        }
        if (value2 instanceof Boolean) {
            GrLiteral grLiteral = (GrLiteral)this.createExpressionFromText(value2.toString());
            if (grLiteral == null) {
                GroovyPsiElementFactoryImpl.$$$reportNull$$$0(130);
            }
            return grLiteral;
        }
        throw new IncorrectOperationException("Can not create literal from type: " + value2.getClass().getName());
    }

    @NotNull
    public PsiClass createClass(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(131);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("class " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(132);
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiClass createInterface(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(133);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("interface " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(134);
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiClass createEnum(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(135);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("enum " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(136);
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public GrField createField(@NotNull @NonNls String name, @NotNull PsiType type2) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(137);
        }
        if (type2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(138);
        }
        GrVariableDeclaration fieldDeclaration = this.createFieldDeclaration(ArrayUtilRt.EMPTY_STRING_ARRAY, name, null, type2);
        GrField grField = (GrField)fieldDeclaration.getVariables()[0];
        if (grField == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(139);
        }
        return grField;
    }

    @Override
    @NotNull
    public GrTraitTypeDefinition createTrait(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(140);
        }
        GrTraitTypeDefinition grTraitTypeDefinition = (GrTraitTypeDefinition)this.createTypeDefinition("trait " + name + "{}");
        if (grTraitTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(141);
        }
        return grTraitTypeDefinition;
    }

    @Override
    @NotNull
    public GrTraitTypeDefinition createRecord(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(142);
        }
        GrTraitTypeDefinition grTraitTypeDefinition = (GrTraitTypeDefinition)this.createTypeDefinition("record " + name + "() {}");
        if (grTraitTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(143);
        }
        return grTraitTypeDefinition;
    }

    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, @Nullable PsiType returnType2) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(144);
        }
        GrMethod grMethod = this.createMethod(name, returnType2, null);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(145);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, PsiType returnType2, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(146);
        }
        @NonNls StringBuilder builder = new StringBuilder();
        builder.append("def <T>");
        if (returnType2 != null) {
            builder.append(returnType2.getCanonicalText());
        }
        builder.append(' ');
        if (GroovyNamesUtil.isIdentifier(name)) {
            builder.append(name);
        } else {
            builder.append('\"');
            builder.append(GrStringUtil.escapeSymbolsForGString(name, true, false));
            builder.append('\"');
        }
        builder.append("(){}");
        GrMethod method = this.createMethodFromText(builder.toString(), context);
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        assert (typeParameterList != null);
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        if (returnType2 != null) {
            method.getModifierList().setModifierProperty("def", false);
        }
        GrMethod grMethod = method;
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(147);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createConstructor() {
        GrMethod grMethod = this.createConstructorFromText("Foo", "Foo(){}", null);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(148);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrClassInitializer createClassInitializer() throws IncorrectOperationException {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class X {{}}");
        GrClassInitializer grClassInitializer = typeDefinition.getInitializers()[0];
        if (grClassInitializer == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(149);
        }
        return grClassInitializer;
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type2) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(150);
        }
        GrParameter grParameter = this.createParameter(name, type2 == null ? null : type2.getCanonicalText(), null, null, new String[0]);
        if (grParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(151);
        }
        return grParameter;
    }

    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type2, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(152);
        }
        GrParameter grParameter = this.createParameter(name, type2 == null ? null : type2.getCanonicalText(), null, context instanceof GroovyPsiElement ? (GroovyPsiElement)context : null, new String[0]);
        if (grParameter == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(153);
        }
        return grParameter;
    }

    @NotNull
    public PsiParameterList createParameterList(@NonNls String @NotNull [] names, PsiType @NotNull [] types) throws IncorrectOperationException {
        if (names == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(154);
        }
        if (types == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(155);
        }
        @NonNls StringBuilder builder = new StringBuilder();
        builder.append("def foo(");
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            PsiType type2 = types[i2];
            if (type2 != null) {
                builder.append(type2.getCanonicalText());
                builder.append(' ');
            }
            builder.append(name);
            builder.append(',');
        }
        if (names.length > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("){}");
        GrMethod method = this.createMethodFromText(builder);
        GrParameterList grParameterList = method.getParameterList();
        if (grParameterList == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(156);
        }
        return grParameterList;
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(157);
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("@interface " + name + "{}");
        if (grTypeDefinition == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(158);
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(159);
        }
        GrMethod grMethod = this.createConstructorFromText(name, name + "(){}", null);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(160);
        }
        return grMethod;
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name, PsiElement context) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(161);
        }
        GrMethod grMethod = this.createConstructorFromText(name, name + "(){}", context);
        if (grMethod == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(162);
        }
        return grMethod;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor2) {
        if (resolve2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(163);
        }
        if (substitutor2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(164);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve2, substitutor2);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(165);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor2, @Nullable LanguageLevel languageLevel) {
        if (resolve2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(166);
        }
        if (substitutor2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(167);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve2, substitutor2, languageLevel);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(168);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameters2) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(169);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters2);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(170);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters2) {
        if (aClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(171);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters2);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(172);
        }
        return psiClassType;
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(173);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)this.myProject).createRawSubstitutor(owner);
        if (psiSubstitutor == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(174);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(175);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)this.myProject).createSubstitutor(map2);
        if (psiSubstitutor == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(176);
        }
        return psiSubstitutor;
    }

    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(177);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createPrimitiveType(text);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(178);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(179);
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(180);
        }
        if (resolveScope == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(181);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName, resolveScope);
        if (psiClassType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(182);
        }
        return psiClassType;
    }

    public boolean isValidClassName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(183);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidMethodName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(184);
        }
        return true;
    }

    public boolean isValidParameterName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(185);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidFieldName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(186);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidLocalVariableName(@NotNull String name) {
        if (name == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(187);
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    @NotNull
    private <T extends PsiElement> T createElementFromText(@NotNull String text, @Nullable PsiElement context, @NotNull IElementType elementType, @NotNull Class<T> elementClass) {
        GroovyDummyElement dummyElement;
        DummyHolder holder;
        PsiElement element;
        PsiElement result2;
        if (text == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(188);
        }
        if (elementType == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(189);
        }
        if (elementClass == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(190);
        }
        if ((result2 = (PsiElement)ObjectUtils.tryCast((Object)(element = (holder = new DummyHolder(this.myManager, (TreeElement)(dummyElement = new GroovyDummyElement(elementType, text)), context)).getFirstChild()), elementClass)) == null) {
            throw new IncorrectOperationException("Cannot create '" + elementClass.getName() + "' from text '" + text + "'");
        }
        GeneratedMarkerVisitor.markGenerated((PsiElement)result2);
        PsiElement psiElement = result2;
        if (psiElement == null) {
            GroovyPsiElementFactoryImpl.$$$reportNull$$$0(191);
        }
        return (T)psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 8, 11, 13, 15, 17, 18, 19, 20, 23, 24, 25, 27, 30, 32, 34, 39, 41, 44, 46, 48, 50, 52, 54, 57, 59, 62, 63, 64, 69, 71, 75, 76, 77, 79, 80, 83, 85, 87, 89, 91, 92, 95, 97, 99, 101, 103, 110, 112, 114, 116, 118, 119, 122, 123, 125, 126, 127, 128, 129, 130, 132, 134, 136, 139, 141, 143, 145, 147, 148, 149, 151, 153, 156, 158, 160, 162, 165, 168, 170, 172, 174, 176, 179, 182, 191 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 110: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 153: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 165: 
            case 168: 
            case 170: 
            case 172: 
            case 174: 
            case 176: 
            case 179: 
            case 182: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 72: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 26: 
            case 31: 
            case 33: 
            case 37: 
            case 40: 
            case 49: 
            case 53: 
            case 66: 
            case 78: 
            case 84: 
            case 86: 
            case 93: 
            case 94: 
            case 96: 
            case 100: 
            case 111: 
            case 113: 
            case 115: 
            case 177: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 98: 
            case 178: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 14: 
            case 45: 
            case 90: 
            case 169: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: 
            case 38: 
            case 51: 
            case 55: 
            case 67: 
            case 81: 
            case 104: 
            case 108: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 150: 
            case 152: 
            case 157: 
            case 159: 
            case 161: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureText";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaText";
                break;
            }
            case 42: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 43: 
            case 120: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 47: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDot";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorName";
                break;
            }
            case 61: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNames";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationText";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoText";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 105: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTypes";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionTypes";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argListText";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 163: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 164: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceNameFromText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocMemberReferenceNameFromText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocMemberReferenceFromText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocReferenceElementFromFQN";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceExpressionFromText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceElementForClass";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFromText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceElementByType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameterList";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameter";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableDeclaration";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumConstantFromText";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldDeclaration";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldDeclarationFromText";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopElementFromText";
                break;
            }
            case 39: 
            case 151: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeDefinition";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeElement";
                break;
            }
            case 46: 
            case 165: 
            case 168: 
            case 170: 
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createParenthesizedExpr";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringLiteralForReference";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifierFromText";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodBodyFromText";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleVariableDeclaration";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createDotToken";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorFromText";
                break;
            }
            case 64: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFromText";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFromSignature";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroovyFile";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createWhiteSpace";
                break;
            }
            case 77: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineTerminator";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionArgumentList";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedArgument";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatementFromText";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodCallByAppCall";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeReferenceElementFromClass";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createThisExpression";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifierList";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwitchSection";
                break;
            }
            case 99: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatementFromText";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatement";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocCommentFromText";
                break;
            }
            case 114: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorInvocation";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "createThrownList";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "createCatchClause";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentList";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentListFromText";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtendsClause";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementsClause";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralFromValue";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "createClass";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterface";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnum";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "createField";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrait";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecord";
                break;
            }
            case 145: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
            case 148: 
            case 160: 
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassInitializer";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationType";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutor";
                break;
            }
            case 179: 
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceNameFromText";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 110: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 153: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 165: 
            case 168: 
            case 170: 
            case 172: 
            case 174: 
            case 176: 
            case 179: 
            case 182: 
            case 191: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDocMemberReferenceNameFromText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDocMemberReferenceFromText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDocReferenceElementFromFQN";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCodeReference";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceExpressionFromText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElementForClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromText";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createTypeParameter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEnumConstantFromText";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createFieldDeclaration";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createFieldDeclarationFromText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTopElementFromText";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createClosureFromText";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createLambdaFromText";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
            case 38: 
            case 150: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createTypeDefinition";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElement";
                break;
            }
            case 45: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createParenthesizedExpr";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteralForReference";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createModifierFromText";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createMethodBodyFromText";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleVariableDeclaration";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createDotToken";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorFromText";
                break;
            }
            case 65: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationAttribute";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFromSignature";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createGroovyFileChecked";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createGroovyFile";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createLineTerminator";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createNamedArgument";
                break;
            }
            case 84: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromText";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCallByAppCall";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "createCodeReferenceElementFromClass";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createBlockStatementFromText";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "createModifierList";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createSwitchSection";
                break;
            }
            case 98: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatementFromText";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatement";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodText";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFromText";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "createDocCommentFromText";
                break;
            }
            case 113: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorInvocation";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "createThrownList";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createCatchClause";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentListFromText";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "createInterface";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "createEnum";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "createTrait";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "createRecord";
                break;
            }
            case 144: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationType";
                break;
            }
            case 159: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutor";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveType";
                break;
            }
            case 178: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassName";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "isValidMethodName";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "isValidParameterName";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "isValidFieldName";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "isValidLocalVariableName";
                break;
            }
            case 188: 
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 8, 11, 13, 15, 17, 18, 19, 20, 23, 24, 25, 27, 30, 32, 34, 39, 41, 44, 46, 48, 50, 52, 54, 57, 59, 62, 63, 64, 69, 71, 75, 76, 77, 79, 80, 83, 85, 87, 89, 91, 92, 95, 97, 99, 101, 103, 110, 112, 114, 116, 118, 119, 122, 123, 125, 126, 127, 128, 129, 130, 132, 134, 136, 139, 141, 143, 145, 147, 148, 149, 151, 153, 156, 158, 160, 162, 165, 168, 170, 172, 174, 176, 179, 182, 191 -> new IllegalStateException(string);
        };
    }
}

