/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/refactoring/convertToStatic/EmptyDeclarationTypeCollector;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "recursive", "", "(Z)V", "elements", "", "Lcom/intellij/psi/PsiElement;", "getElements", "()Ljava/util/List;", "checkField", "", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "checkReference", "referenceExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyReference;", "visitElement", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "visitReferenceExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nfixes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 fixes.kt\norg/jetbrains/plugins/groovy/refactoring/convertToStatic/EmptyDeclarationTypeCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
final class EmptyDeclarationTypeCollector
extends GroovyElementVisitor {
    private final boolean recursive;
    @NotNull
    private final List<PsiElement> elements;

    public EmptyDeclarationTypeCollector(boolean recursive) {
        this.recursive = recursive;
        this.elements = new ArrayList();
    }

    @NotNull
    public final List<PsiElement> getElements() {
        return this.elements;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
        this.checkReference(referenceExpression);
        super.visitReferenceExpression(referenceExpression);
    }

    private final void checkReference(GroovyReference referenceExpression) {
        GroovyResolveResult groovyResolveResult = referenceExpression.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        GroovyResolveResult resolveResult2 = groovyResolveResult;
        if (!resolveResult2.isValidResult()) {
            return;
        }
        PsiElement element = resolveResult2.getElement();
        if (element instanceof GrAccessorMethod) {
            GrField grField = ((GrAccessorMethod)element).getProperty();
            Intrinsics.checkNotNullExpressionValue((Object)grField, (String)"getProperty(...)");
            this.checkField(grField);
        } else if (element instanceof GrField) {
            this.checkField((GrField)element);
        } else {
            if (element instanceof LightElement) {
                return;
            }
            if (element instanceof GrMethod) {
                if (((GrMethod)element).isConstructor()) {
                    return;
                }
                GrTypeElement grTypeElement = ((GrMethod)element).getReturnTypeElementGroovy();
                if (grTypeElement != null) {
                    GrTypeElement it = grTypeElement;
                    boolean bl = false;
                    return;
                }
                ((Collection)this.elements).add(element);
            }
        }
    }

    private final void checkField(GrField element) {
        PsiType psiType = element.getDeclaredType();
        if (psiType != null) {
            PsiType it = psiType;
            boolean bl = false;
            return;
        }
        GrExpression grExpression = element.getInitializerGroovy();
        if (grExpression == null) {
            return;
        }
        GrExpression initializer = grExpression;
        if (initializer.getType() == null) {
            return;
        }
        ((Collection)this.elements).add(element);
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.recursive) {
            element.acceptChildren(this);
        }
    }
}

