/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableSettings;

public abstract class GrIntroduceLocalVariableProcessor {
    private static final Logger LOG = Logger.getInstance(GrIntroduceLocalVariableProcessor.class);
    private final GrIntroduceContext myContext;
    private final GroovyIntroduceVariableSettings mySettings;
    private final boolean myProcessUsages;
    private final PsiElement[] myOccurrences;
    private final GrExpression myExpression;

    public GrIntroduceLocalVariableProcessor(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings, PsiElement @NotNull [] occurrences, @NotNull GrExpression expression, boolean processUsages) {
        PsiElement[] psiElementArray;
        if (context == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(2);
        }
        if (occurrences == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(3);
        }
        this.myContext = context;
        this.mySettings = settings;
        this.myProcessUsages = processUsages;
        if (settings.replaceAllOccurrences()) {
            psiElementArray = occurrences;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = expression;
        }
        this.myOccurrences = psiElementArray;
        this.myExpression = expression;
    }

    @NotNull
    public GrVariable processExpression(@NotNull GrVariableDeclaration declaration) {
        if (declaration == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(4);
        }
        GrIntroduceLocalVariableProcessor.resolveLocalConflicts(this.myContext.getScope(), this.mySettings.getName());
        this.preprocessOccurrences();
        int expressionIndex = ArrayUtilRt.find((Object[])this.myOccurrences, (Object)this.myExpression);
        PsiElement[] replaced = this.myProcessUsages ? this.processOccurrences() : this.myOccurrences;
        PsiElement replacedExpression = replaced[expressionIndex];
        GrStatement anchor = GrIntroduceHandlerBase.getAnchor(replaced, this.myContext.getScope());
        RefactoringUtil.highlightAllOccurrences((Project)this.myContext.getProject(), (PsiElement[])replaced, (Editor)this.myContext.getEditor());
        return this.insertVariableDefinition(declaration, anchor, replacedExpression);
    }

    protected abstract void refreshPositionMarker(PsiElement var1);

    private static boolean isControlStatementBranch(GrStatement statement) {
        return statement.getParent() instanceof GrLoopStatement && statement == ((GrLoopStatement)statement.getParent()).getBody() || statement.getParent() instanceof GrIfStatement && (statement == ((GrIfStatement)statement.getParent()).getThenBranch() || statement == ((GrIfStatement)statement.getParent()).getElseBranch());
    }

    private PsiElement[] processOccurrences() {
        ArrayList<GrExpression> result2 = new ArrayList<GrExpression>();
        GrReferenceExpression templateRef = GroovyPsiElementFactory.getInstance(this.myContext.getProject()).createReferenceExpressionFromText(this.mySettings.getName());
        for (PsiElement occurrence : this.myOccurrences) {
            if (!(occurrence instanceof GrExpression)) {
                throw new IncorrectOperationException("Expression occurrence to be replaced is not instance of GroovyPsiElement");
            }
            GrExpression replaced = ((GrExpression)occurrence).replaceWithExpression(templateRef, true);
            result2.add(replaced);
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    @NotNull
    private GrExpression preprocessOccurrences() {
        GroovyRefactoringUtil.sortOccurrences(this.myOccurrences);
        if (this.myOccurrences.length == 0 || !(this.myOccurrences[0] instanceof GrExpression)) {
            throw new IncorrectOperationException("Wrong expression occurrence");
        }
        GrExpression grExpression = (GrExpression)this.myOccurrences[0];
        if (grExpression == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(5);
        }
        return grExpression;
    }

    private static void resolveLocalConflicts(@NotNull PsiElement tempContainer, @NotNull String varName) {
        if (tempContainer == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(6);
        }
        if (varName == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(7);
        }
        for (PsiElement child : tempContainer.getChildren()) {
            if (child instanceof GrReferenceExpression && !child.getText().contains(".")) {
                String fieldName;
                PsiElement resolved;
                PsiReference psiReference = child.getReference();
                if (psiReference == null || (resolved = psiReference.resolve()) == null || !varName.equals(fieldName = GrIntroduceLocalVariableProcessor.getFieldName(resolved))) continue;
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(tempContainer.getProject());
                ((GrReferenceExpression)child).replaceWithExpression(factory.createExpressionFromText("this." + child.getText()), true);
                continue;
            }
            GrIntroduceLocalVariableProcessor.resolveLocalConflicts(child, varName);
        }
    }

    @NotNull
    private GrVariable insertVariableDefinition(@NotNull GrVariableDeclaration declaration, @NotNull GrStatement anchor, @Nullable PsiElement expression) throws IncorrectOperationException {
        boolean isInsideControlStatement;
        String usedLabel;
        if (declaration == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(8);
        }
        if (anchor == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(9);
        }
        GrLabeledStatement labeledStatement = expression != null && expression.getParent() instanceof GrLabeledStatement ? (GrLabeledStatement)expression.getParent() : null;
        boolean expressionMustBeDeleted = expression != null && PsiUtil.isExpressionStatement(expression) && !GrIntroduceLocalVariableProcessor.isSingleGStringInjectionExpr(expression);
        boolean anchorEqualsExpression = anchor == expression || labeledStatement == anchor;
        String string = usedLabel = labeledStatement != null ? labeledStatement.getName() : null;
        if (expressionMustBeDeleted && !anchorEqualsExpression) {
            expression.delete();
        }
        if (isInsideControlStatement = GrIntroduceLocalVariableProcessor.isControlStatementBranch(anchor)) {
            anchor = GrIntroduceLocalVariableProcessor.insertBraces(anchor);
        }
        LOG.assertTrue(this.myOccurrences.length > 0);
        GrStatementOwner block = (GrStatementOwner)anchor.getParent();
        if (usedLabel != null && expressionMustBeDeleted && anchorEqualsExpression) {
            GrLabeledStatement definitionWithLabel = (GrLabeledStatement)GroovyPsiElementFactory.getInstance(anchor.getProject()).createStatementFromText(usedLabel + ": foo()");
            GrLabeledStatement inserted = GrIntroduceLocalVariableProcessor.insertStatement(definitionWithLabel, anchor, block, true);
            declaration = inserted.getStatement().replaceWithStatement(declaration);
        } else {
            declaration = GrIntroduceLocalVariableProcessor.insertStatement(declaration, anchor, block, expressionMustBeDeleted && anchorEqualsExpression);
        }
        GrVariable variable = declaration.getVariables()[0];
        JavaCodeStyleManager.getInstance((Project)declaration.getProject()).shortenClassReferences((PsiElement)declaration);
        GrVariable markerPlace = expressionMustBeDeleted ? variable : (isInsideControlStatement ? declaration.getParent() : expression);
        this.refreshPositionMarker(markerPlace);
        GrVariable grVariable = variable;
        if (grVariable == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(10);
        }
        return grVariable;
    }

    private static <T extends GrStatement> T insertStatement(T declaration, GrStatement anchor, GrStatementOwner block, boolean replaceAnchor) {
        if (replaceAnchor) {
            return (T)((GrStatement)anchor.replace(declaration));
        }
        return (T)block.addStatementBefore(declaration, anchor);
    }

    @NotNull
    static GrStatement insertBraces(@NotNull GrStatement anchor) {
        if (anchor == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(11);
        }
        GrBlockStatement blockStatement = GroovyPsiElementFactory.getInstance(anchor.getProject()).createBlockStatement(new GrStatement[0]);
        blockStatement.getBlock().addStatementBefore(anchor, null);
        GrBlockStatement newBlockStatement = (GrBlockStatement)anchor.replace(blockStatement);
        GrStatement grStatement = newBlockStatement.getBlock().getStatements()[0];
        if (grStatement == null) {
            GrIntroduceLocalVariableProcessor.$$$reportNull$$$0(12);
        }
        return grStatement;
    }

    private static boolean isSingleGStringInjectionExpr(PsiElement expression) {
        PsiElement parent2 = expression.getParent();
        return parent2 instanceof GrClosableBlock && parent2.getParent() instanceof GrStringInjection;
    }

    @Nullable
    private static String getFieldName(@Nullable PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        return element instanceof GrField ? ((GrField)element).getName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/variable/GrIntroduceLocalVariableProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempContainer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/variable/GrIntroduceLocalVariableProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOccurrences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "insertVariableDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBraces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processExpression";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocalConflicts";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "insertVariableDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "insertBraces";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 12 -> new IllegalStateException(string);
        };
    }
}

