/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.BlockTerminalController;
import org.jetbrains.plugins.terminal.exp.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.exp.TerminalPromptController;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionController;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0005\u000e\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction;", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromotedDumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Disabled;", "()V", "handlers", "", "Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$TerminalEscapeHandler;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "CloseHistoryHandler", "CloseSearchHandler", "SelectEditorHandler", "SelectPromptHandler", "TerminalEscapeHandler", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalEscapeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEscapeAction.kt\norg/jetbrains/plugins/terminal/action/TerminalEscapeAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1#2:107\n1747#3,3:108\n*S KotlinDebug\n*F\n+ 1 TerminalEscapeAction.kt\norg/jetbrains/plugins/terminal/action/TerminalEscapeAction\n*L\n42#1:108,3\n*E\n"})
public final class TerminalEscapeAction
extends TerminalPromotedDumbAwareAction
implements ActionRemoteBehaviorSpecification.Disabled {
    @NotNull
    private final List<TerminalEscapeHandler> handlers;

    public TerminalEscapeAction() {
        Object[] objectArray = new TerminalEscapeHandler[]{new CloseHistoryHandler(), new SelectPromptHandler(), new CloseSearchHandler(), new SelectEditorHandler()};
        this.handlers = CollectionsKt.listOf((Object[])objectArray);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Iterable iterable = this.handlers;
            for (Object t : iterable) {
                TerminalEscapeHandler it = (TerminalEscapeHandler)t;
                boolean bl = false;
                if (!it.isEnabled(e)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TerminalEscapeHandler terminalEscapeHandler = v0;
        if (terminalEscapeHandler == null) {
            return;
        }
        TerminalEscapeHandler handler = terminalEscapeHandler;
        handler.execute(e);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Presentation presentation;
        block5: {
            void $this$any$iv;
            Editor editor;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor2 = editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
            if (!(editor2 != null ? TerminalDataContextUtils.INSTANCE.isPromptEditor(editor2) : false)) {
                Editor editor3 = editor;
                if (!(editor3 != null ? TerminalDataContextUtils.INSTANCE.isOutputEditor(editor3) : false)) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
            }
            Iterable iterable = this.handlers;
            presentation = e.getPresentation();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TerminalEscapeHandler it = (TerminalEscapeHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.isEnabled(e)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        presentation.setEnabledAndVisible(bl3);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$CloseHistoryHandler;", "Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$TerminalEscapeHandler;", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal"})
    private static final class CloseHistoryHandler
    implements TerminalEscapeHandler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TerminalPromptController terminalPromptController = TerminalDataContextUtils.INSTANCE.getPromptController(e);
                if (terminalPromptController == null) break block0;
                terminalPromptController.onCommandHistoryClosed();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            LookupEx lookupEx = LookupManager.getActiveLookup((Editor)TerminalDataContextUtils.INSTANCE.getEditor(e));
            UserDataHolder lookup = lookupEx instanceof UserDataHolder ? (UserDataHolder)lookupEx : null;
            Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
            if (editor == null) return false;
            if (!TerminalDataContextUtils.INSTANCE.isPromptEditor(editor)) return false;
            boolean bl = true;
            if (!bl) return false;
            UserDataHolder userDataHolder = lookup;
            if (userDataHolder == null) return false;
            boolean bl2 = Intrinsics.areEqual((Object)userDataHolder.getUserData(CommandHistoryPresenter.Companion.getIS_COMMAND_HISTORY_LOOKUP_KEY()), (Object)true);
            if (!bl2) return false;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$CloseSearchHandler;", "Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$TerminalEscapeHandler;", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal"})
    private static final class CloseSearchHandler
    implements TerminalEscapeHandler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BlockTerminalController blockTerminalController = TerminalDataContextUtils.INSTANCE.getBlockTerminalController(e);
                if (blockTerminalController == null) break block0;
                blockTerminalController.finishSearchSession();
            }
        }

        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BlockTerminalController blockTerminalController = TerminalDataContextUtils.INSTANCE.getBlockTerminalController(e);
            return (blockTerminalController != null ? blockTerminalController.getSearchSession() : null) != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$SelectEditorHandler;", "Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$TerminalEscapeHandler;", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal"})
    private static final class SelectEditorHandler
    implements TerminalEscapeHandler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            ToolWindowManager.Companion.getInstance(project).activateEditorComponent();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TerminalSession terminalSession = TerminalDataContextUtils.INSTANCE.getTerminalSession(e);
            Object object = terminalSession;
            if (terminalSession == null) return false;
            if ((object = ((TerminalSession)object).getModel()) == null) {
                return false;
            }
            Object terminalModel = object;
            if (e.getProject() == null) return false;
            if (LookupManager.getActiveLookup((Editor)TerminalDataContextUtils.INSTANCE.getEditor(e)) != null) return false;
            if (e.getData(PlatformDataKeys.TOOL_WINDOW) == null) return false;
            if (!AdvancedSettings.Companion.getBoolean("terminal.escape.moves.focus.to.editor")) return false;
            Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
            if (editor != null) {
                if (TerminalDataContextUtils.INSTANCE.isPromptEditor(editor)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (!((TerminalModel)terminalModel).isCommandRunning()) return false;
            if (((TerminalModel)terminalModel).getUseAlternateBuffer()) return false;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$SelectPromptHandler;", "Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$TerminalEscapeHandler;", "()V", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal"})
    private static final class SelectPromptHandler
    implements TerminalEscapeHandler {
        @Override
        public void execute(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
                if (terminalSelectionController == null) break block0;
                terminalSelectionController.clearSelection();
            }
        }

        @Override
        public boolean isEnabled(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
            if (editor == null) {
                return false;
            }
            Editor editor2 = editor;
            TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
            if (terminalSelectionController == null) {
                return false;
            }
            TerminalSelectionController selectionController = terminalSelectionController;
            return TerminalDataContextUtils.INSTANCE.isOutputEditor(editor2) && (selectionController.getPrimarySelection() != null || editor2.getSelectionModel().hasSelection());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalEscapeAction$TerminalEscapeHandler;", "", "execute", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "intellij.terminal"})
    private static interface TerminalEscapeHandler {
        public void execute(@NotNull AnActionEvent var1);

        public boolean isEnabled(@NotNull AnActionEvent var1);
    }
}

