/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.terminal.BlockTerminalColors;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.AbstractBlockDecorationState;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.ui.TerminalBlockBackgroundRenderer;
import org.jetbrains.plugins.terminal.exp.ui.TerminalBlockCornersRenderer;
import org.jetbrains.plugins.terminal.exp.ui.TerminalBlockLeftAreaRenderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/exp/DefaultBlockDecorationState;", "Lorg/jetbrains/plugins/terminal/exp/AbstractBlockDecorationState;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "backgroundEnd", "Ljava/awt/Color;", "backgroundRenderer", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "getBackgroundRenderer", "()Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "backgroundStart", "cornersRenderer", "getCornersRenderer", "leftAreaRenderer", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "getLeftAreaRenderer", "()Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "Companion", "intellij.terminal"})
public final class DefaultBlockDecorationState
extends AbstractBlockDecorationState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Color backgroundStart;
    @NotNull
    private final Color backgroundEnd;
    @NotNull
    private final CustomHighlighterRenderer backgroundRenderer;
    @NotNull
    private final CustomHighlighterRenderer cornersRenderer;
    @NotNull
    private final LineMarkerRenderer leftAreaRenderer;
    @NotNull
    public static final String NAME = "DEFAULT";

    public DefaultBlockDecorationState(@NotNull EditorColorsScheme scheme) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        super(NAME, 0);
        Color color2 = scheme.getColor(BlockTerminalColors.getBLOCK_BACKGROUND_START());
        if (color2 == null) {
            color2 = this.backgroundStart = TerminalUi.INSTANCE.getBlockBackgroundStart();
        }
        if ((color = scheme.getColor(BlockTerminalColors.getBLOCK_BACKGROUND_END())) == null) {
            color = TerminalUi.INSTANCE.getBlockBackgroundEnd();
        }
        this.backgroundEnd = color;
        this.backgroundRenderer = new TerminalBlockBackgroundRenderer(this.backgroundStart, this.backgroundEnd);
        this.cornersRenderer = new TerminalBlockCornersRenderer(this.backgroundStart, this.backgroundEnd, null, 0, 12, null);
        this.leftAreaRenderer = new TerminalBlockLeftAreaRenderer(this.backgroundStart, null, 0, 6, null);
    }

    @Override
    @NotNull
    public CustomHighlighterRenderer getBackgroundRenderer() {
        return this.backgroundRenderer;
    }

    @Override
    @NotNull
    public CustomHighlighterRenderer getCornersRenderer() {
        return this.cornersRenderer;
    }

    @Override
    @NotNull
    public LineMarkerRenderer getLeftAreaRenderer() {
        return this.leftAreaRenderer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/DefaultBlockDecorationState$Companion;", "", "()V", "NAME", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

