/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.Terminal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandRun;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0016\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002J\u0016\u0010\"\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002J\u0016\u0010#\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002J\u0016\u0010$\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;", "", "terminal", "Lcom/jediterm/terminal/Terminal;", "(Lcom/jediterm/terminal/Terminal;)V", "commandRun", "Lorg/jetbrains/plugins/terminal/exp/CommandRun;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "addListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "decodeHex", "", "hexStr", "fireCommandFinished", "exitCode", "", "fireCommandHistoryReceived", "history", "fireCommandStarted", "fireDirectoryChanged", "newDirectory", "fireGeneratorFinished", "requestId", "result", "fireInitialized", "firePromptShown", "processCommandFinishedEvent", "event", "", "processCommandHistoryEvent", "processCommandStartedEvent", "processGeneratorFinishedEvent", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,195:1\n10#2:196\n*S KotlinDebug\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager\n*L\n163#1:196\n*E\n"})
public final class ShellCommandManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CopyOnWriteArrayList<ShellCommandListener> listeners;
    @Nullable
    private volatile CommandRun commandRun;
    @NotNull
    private static final Logger LOG;

    public ShellCommandManager(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.listeners = new CopyOnWriteArrayList();
        terminal.addCustomCommandListener(arg_0 -> ShellCommandManager._init_$lambda$0(this, arg_0));
    }

    private final void processCommandStartedEvent(List<String> event) {
        String command = (String)CollectionsKt.getOrNull(event, (int)1);
        String currentDirectory = (String)CollectionsKt.getOrNull(event, (int)2);
        if (command != null && StringsKt.startsWith$default((String)command, (String)"command=", (boolean)false, (int)2, null) && currentDirectory != null && StringsKt.startsWith$default((String)currentDirectory, (String)"current_directory=", (boolean)false, (int)2, null)) {
            CommandRun commandRun;
            this.commandRun = commandRun = new CommandRun(System.nanoTime(), this.decodeHex(StringsKt.removePrefix((String)currentDirectory, (CharSequence)"current_directory=")), this.decodeHex(StringsKt.removePrefix((String)command, (CharSequence)"command=")));
            this.fireCommandStarted(commandRun);
        }
    }

    private final void processCommandFinishedEvent(List<String> event) {
        String exitCodeStr = (String)CollectionsKt.getOrNull(event, (int)1);
        String currentDirectoryField = (String)CollectionsKt.getOrNull(event, (int)2);
        if (exitCodeStr != null && StringsKt.startsWith$default((String)exitCodeStr, (String)"exit_code=", (boolean)false, (int)2, null) && currentDirectoryField != null && StringsKt.startsWith$default((String)currentDirectoryField, (String)"current_directory=", (boolean)false, (int)2, null)) {
            int n;
            try {
                n = Integer.parseInt(StringsKt.removePrefix((String)exitCodeStr, (CharSequence)"exit_code="));
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            int exitCode = n;
            CommandRun commandRun = this.commandRun;
            if (commandRun != null) {
                String newDirectory = this.decodeHex(StringsKt.removePrefix((String)currentDirectoryField, (CharSequence)"current_directory="));
                if (!Intrinsics.areEqual((Object)commandRun.getWorkingDirectory(), (Object)newDirectory)) {
                    this.fireDirectoryChanged(newDirectory);
                }
                this.fireCommandFinished(commandRun, exitCode);
            }
        }
    }

    private final void processCommandHistoryEvent(List<String> event) {
        String history = (String)CollectionsKt.getOrNull(event, (int)1);
        if (history != null && StringsKt.startsWith$default((String)history, (String)"history_string=", (boolean)false, (int)2, null)) {
            this.fireCommandHistoryReceived(this.decodeHex(StringsKt.removePrefix((String)history, (CharSequence)"history_string=")));
        }
    }

    private final void processGeneratorFinishedEvent(List<String> event) {
        String requestId = (String)CollectionsKt.getOrNull(event, (int)1);
        String result2 = (String)CollectionsKt.getOrNull(event, (int)2);
        if (requestId != null && StringsKt.startsWith$default((String)requestId, (String)"request_id=", (boolean)false, (int)2, null) && result2 != null && StringsKt.startsWith$default((String)result2, (String)"result=", (boolean)false, (int)2, null)) {
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)requestId, (CharSequence)"request_id="));
            if (n == null) {
                return;
            }
            int requestIdInt = n;
            this.fireGeneratorFinished(requestIdInt, this.decodeHex(StringsKt.removePrefix((String)result2, (CharSequence)"result=")));
        }
    }

    private final void fireInitialized() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shell event: initialized");
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.initialized();
        }
    }

    private final void firePromptShown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shell event: prompt_shown");
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.promptShown();
        }
    }

    private final void fireCommandStarted(CommandRun commandRun) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shell event: command_started - " + commandRun);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandStarted(commandRun.getCommand());
        }
    }

    private final void fireCommandFinished(CommandRun commandRun, int exitCode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shell event: command_finished - " + commandRun + ", exit code: " + exitCode);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandFinished(commandRun.getCommand(), exitCode, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - commandRun.getCommandStartedNano()));
        }
    }

    private final void fireDirectoryChanged(String newDirectory) {
        for (ShellCommandListener listener : this.listeners) {
            listener.directoryChanged(newDirectory);
        }
        if (LOG.isDebugEnabled()) {
            CommandRun commandRun = this.commandRun;
            LOG.debug("Current directory changed from '" + (commandRun != null ? commandRun.getWorkingDirectory() : null) + "' to '" + newDirectory + "'");
        }
    }

    private final void fireCommandHistoryReceived(String history) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shell event: command_history of " + history.length() + " size");
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandHistoryReceived(history);
        }
    }

    private final void fireGeneratorFinished(int requestId, String result2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shell event: generator_finished with requestId " + requestId + " and result of " + result2.length() + " size");
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.generatorFinished(requestId, result2);
        }
    }

    public final void addListener(@NotNull ShellCommandListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> ShellCommandManager.addListener$lambda$1(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(ShellCommandManager shellCommandManager, ShellCommandListener shellCommandListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        shellCommandManager.addListener(shellCommandListener, disposable);
    }

    private final String decodeHex(String hexStr) {
        byte[] bytes = HexFormat.of().parseHex(hexStr);
        Intrinsics.checkNotNull((Object)bytes);
        byte[] byArray = bytes;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void _init_$lambda$0(ShellCommandManager this$0, List it) {
        block15: {
            block13: {
                block12: {
                    block14: {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String string = (String)CollectionsKt.getOrNull((List)it, (int)0);
                        if (string == null) return;
                        switch (string.hashCode()) {
                            case 424089318: {
                                if (!string.equals("command_finished")) {
                                    return;
                                }
                                break block12;
                            }
                            case -1808601184: {
                                if (!string.equals("command_history")) {
                                    return;
                                }
                                break block13;
                            }
                            case -337753203: {
                                if (!string.equals("command_started")) {
                                    return;
                                }
                                break block14;
                            }
                            case -872176010: {
                                if (string.equals("prompt_shown")) break;
                                return;
                            }
                            case -268905378: {
                                if (!string.equals("generator_finished")) {
                                    return;
                                }
                                break block15;
                            }
                            case 1234020052: {
                                if (!string.equals("initialized")) return;
                                this$0.fireInitialized();
                                return;
                            }
                        }
                        this$0.firePromptShown();
                        return;
                    }
                    this$0.processCommandStartedEvent(it);
                    return;
                }
                this$0.processCommandFinishedEvent(it);
                return;
            }
            this$0.processCommandHistoryEvent(it);
            return;
        }
        this$0.processGeneratorFinishedEvent(it);
    }

    private static final void addListener$lambda$1(ShellCommandManager this$0, ShellCommandListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellCommandManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

