/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.BlockDecoration;
import org.jetbrains.plugins.terminal.exp.BlockDecorationState;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.DefaultBlockDecorationState;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalUi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator;", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel$TerminalOutputListener;", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "blockDecorationStateChanged", "", "block", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "oldStates", "", "Lorg/jetbrains/plugins/terminal/exp/BlockDecorationState;", "newStates", "installDecoration", "isFirstBlock", "", "EmptyWidthInlayRenderer", "TerminalRightAreaRenderer", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalBlocksDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksDecorator.kt\norg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1963#2,14:108\n*S KotlinDebug\n*F\n+ 1 TerminalBlocksDecorator.kt\norg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator\n*L\n64#1:108,14\n*E\n"})
public final class TerminalBlocksDecorator
implements TerminalOutputModel.TerminalOutputListener {
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final EditorEx editor;

    public TerminalBlocksDecorator(@NotNull TerminalOutputModel outputModel, @NotNull EditorEx editor) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.outputModel = outputModel;
        this.editor = editor;
        TerminalOutputModel.addListener$default(this.outputModel, this, null, 2, null);
        RangeHighlighter $this$_init__u24lambda_u240 = rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(0, 0, 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        boolean bl = false;
        $this$_init__u24lambda_u240.setGreedyToLeft(true);
        $this$_init__u24lambda_u240.setGreedyToRight(true);
        $this$_init__u24lambda_u240.setCustomRenderer((CustomHighlighterRenderer)new TerminalRightAreaRenderer());
    }

    @RequiresEdt
    public final void installDecoration(@NotNull CommandBlock block, boolean isFirstBlock) {
        Inlay inlay;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        int topInset = 8 + (isFirstBlock ? 6 : 0);
        EmptyWidthInlayRenderer topRenderer = new EmptyWidthInlayRenderer(topInset);
        Inlay inlay2 = this.editor.getInlayModel().addBlockElement(block.getStartOffset(), false, true, 1, (EditorCustomElementRenderer)topRenderer);
        Intrinsics.checkNotNull((Object)inlay2);
        Inlay topInlay = inlay2;
        EmptyWidthInlayRenderer bottomRenderer = new EmptyWidthInlayRenderer(18);
        Inlay inlay3 = this.editor.getInlayModel().addBlockElement(block.getEndOffset(), true, false, 0, (EditorCustomElementRenderer)bottomRenderer);
        Intrinsics.checkNotNull((Object)inlay3);
        Inlay bottomInlay = inlay3;
        CharSequence charSequence = block.getCommand();
        if (!(charSequence == null || charSequence.length() == 0)) {
            EmptyWidthInlayRenderer renderer = new EmptyWidthInlayRenderer(2);
            Inlay inlay4 = this.editor.getInlayModel().addBlockElement(block.getOutputStartOffset(), false, true, 0, (EditorCustomElementRenderer)renderer);
            inlay = inlay4;
            Intrinsics.checkNotNull((Object)inlay4);
        } else {
            inlay = null;
        }
        Inlay commandToOutputInlay = inlay;
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(block.getStartOffset(), block.getEndOffset(), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter bgHighlighter = rangeHighlighter;
        bgHighlighter.setGreedyToRight(true);
        RangeHighlighter rangeHighlighter2 = this.editor.getMarkupModel().addRangeHighlighter(block.getStartOffset(), block.getEndOffset(), 900, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter cornersHighlighter = rangeHighlighter2;
        cornersHighlighter.setGreedyToRight(true);
        BlockDecoration decoration = new BlockDecoration(bgHighlighter, cornersHighlighter, topInlay, bottomInlay, commandToOutputInlay);
        this.outputModel.putDecoration(block, decoration);
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        this.outputModel.addBlockState(block, new DefaultBlockDecorationState(editorColorsScheme));
    }

    public static /* synthetic */ void installDecoration$default(TerminalBlocksDecorator terminalBlocksDecorator, CommandBlock commandBlock, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        terminalBlocksDecorator.installDecoration(commandBlock, bl);
    }

    @Override
    public void blockDecorationStateChanged(@NotNull CommandBlock block, @NotNull List<? extends BlockDecorationState> oldStates, @NotNull List<? extends BlockDecorationState> newStates) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(oldStates, (String)"oldStates");
        Intrinsics.checkNotNullParameter(newStates, (String)"newStates");
        BlockDecoration blockDecoration = this.outputModel.getDecoration(block);
        if (blockDecoration == null) {
            return;
        }
        BlockDecoration decoration = blockDecoration;
        Iterable $this$maxByOrNull$iv = newStates;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                BlockDecorationState it = (BlockDecorationState)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPriority();
                do {
                    Object e$iv = iterator$iv.next();
                    BlockDecorationState it2 = (BlockDecorationState)e$iv;
                    $i$a$-maxByOrNull-TerminalBlocksDecorator$blockDecorationStateChanged$state$1 = false;
                    int v$iv = it2.getPriority();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        BlockDecorationState blockDecorationState = v1;
        if (blockDecorationState == null) {
            return;
        }
        BlockDecorationState state = blockDecorationState;
        BlockDecoration $this$blockDecorationStateChanged_u24lambda_u242 = decoration;
        boolean bl = false;
        $this$blockDecorationStateChanged_u24lambda_u242.getBackgroundHighlighter().setCustomRenderer(state.getBackgroundRenderer());
        $this$blockDecorationStateChanged_u24lambda_u242.getCornersHighlighter().setCustomRenderer(state.getCornersRenderer());
        $this$blockDecorationStateChanged_u24lambda_u242.getCornersHighlighter().setLineMarkerRenderer(state.getLeftAreaRenderer());
        Rectangle bounds = this.outputModel.getBlockBounds(block);
        this.editor.getComponent().repaint(bounds);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\u00032\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0014\u0010\n\u001a\u00020\u00032\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator$EmptyWidthInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "height", "", "(I)V", "getHeight", "()I", "calcHeightInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "intellij.terminal"})
    private static final class EmptyWidthInlayRenderer
    implements EditorCustomElementRenderer {
        private final int height;

        public EmptyWidthInlayRenderer(int height) {
            this.height = height;
        }

        public final int getHeight() {
            return this.height;
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return 0;
        }

        public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return JBUI.scale((int)this.height);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator$TerminalRightAreaRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "()V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.terminal"})
    private static final class TerminalRightAreaRenderer
    implements CustomHighlighterRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            int width = JBUI.scale((int)7);
            Color oldColor = g.getColor();
            try {
                g.setColor(TerminalUi.INSTANCE.getTerminalBackground());
                g.fillRect(visibleArea.width - width, visibleArea.y, width, visibleArea.height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }
}

