/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalExecutorServiceManagerImpl;
import com.jediterm.core.typeahead.Debouncer;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTermDebouncerImpl;
import com.jediterm.terminal.model.JediTermTypeAheadModel;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.exp.ModelUpdatingTerminalDisplay;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandManager;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0001J\u0016\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0001J\b\u0010)\u001a\u00020#H\u0016J\u000e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u000202R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "Lcom/intellij/openapi/Disposable;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/util/ShellIntegration;)V", "commandManager", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;", "controller", "Lcom/jediterm/terminal/model/JediTerminal;", "getController$intellij_terminal", "()Lcom/jediterm/terminal/model/JediTerminal;", "executorServiceManager", "Lcom/jediterm/terminal/TerminalExecutorServiceManager;", "model", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getShellIntegration", "()Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "terminalStarter", "Lcom/jediterm/terminal/TerminalStarter;", "getTerminalStarter", "()Lcom/jediterm/terminal/TerminalStarter;", "setTerminalStarter", "(Lcom/jediterm/terminal/TerminalStarter;)V", "terminationListeners", "", "Ljava/lang/Runnable;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "typeAheadManager", "Lcom/jediterm/core/typeahead/TerminalTypeAheadManager;", "addCommandListener", "", "listener", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "parentDisposable", "addTerminationCallback", "onTerminated", "dispose", "executeCommand", "command", "", "postResize", "newSize", "Lcom/jediterm/core/util/TermSize;", "start", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "Companion", "intellij.terminal"})
public final class TerminalSession
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ShellIntegration shellIntegration;
    @NotNull
    private final TerminalModel model;
    public TerminalStarter terminalStarter;
    @NotNull
    private final TerminalExecutorServiceManager executorServiceManager;
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final JediTerminal controller;
    @NotNull
    private final ShellCommandManager commandManager;
    @NotNull
    private final TerminalTypeAheadManager typeAheadManager;
    @NotNull
    private final List<Runnable> terminationListeners;
    @NotNull
    private static final Key<TerminalSession> KEY;
    @NotNull
    private static final DataKey<TerminalSession> DATA_KEY;

    public TerminalSession(@NotNull JBTerminalSystemSettingsProviderBase settings, @Nullable ShellIntegration shellIntegration) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.shellIntegration = shellIntegration;
        this.executorServiceManager = (TerminalExecutorServiceManager)new TerminalExecutorServiceManagerImpl();
        this.terminationListeners = new CopyOnWriteArrayList();
        StyleState styleState = new StyleState();
        styleState.setDefaultStyle(settings.getDefaultStyle());
        this.textBuffer = new TerminalTextBuffer(80, 24, styleState);
        this.model = new TerminalModel(this.textBuffer, styleState);
        this.controller = new JediTerminal((TerminalDisplay)new ModelUpdatingTerminalDisplay(this.model, settings), this.textBuffer, styleState);
        this.commandManager = new ShellCommandManager((Terminal)this.controller);
        JediTermTypeAheadModel typeAheadTerminalModel = new JediTermTypeAheadModel((Terminal)this.controller, this.textBuffer, (SettingsProvider)settings);
        this.typeAheadManager = new TerminalTypeAheadManager((TypeAheadTerminalModel)typeAheadTerminalModel);
        JediTermDebouncerImpl typeAheadDebouncer = new JediTermDebouncerImpl(() -> ((TerminalTypeAheadManager)this.typeAheadManager).debounce(), TerminalTypeAheadManager.MAX_TERMINAL_DELAY, this.executorServiceManager);
        this.typeAheadManager.setClearPredictionsDebouncer((Debouncer)typeAheadDebouncer);
    }

    @Nullable
    public final ShellIntegration getShellIntegration() {
        return this.shellIntegration;
    }

    @NotNull
    public final TerminalModel getModel() {
        return this.model;
    }

    @NotNull
    public final TerminalStarter getTerminalStarter() {
        TerminalStarter terminalStarter = this.terminalStarter;
        if (terminalStarter != null) {
            return terminalStarter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"terminalStarter");
        return null;
    }

    public final void setTerminalStarter(@NotNull TerminalStarter terminalStarter) {
        Intrinsics.checkNotNullParameter((Object)terminalStarter, (String)"<set-?>");
        this.terminalStarter = terminalStarter;
    }

    @NotNull
    public final JediTerminal getController$intellij_terminal() {
        return this.controller;
    }

    public final void start(@NotNull TtyConnector ttyConnector) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        this.setTerminalStarter(new TerminalStarter(this.controller, ttyConnector, (TerminalDataStream)new TtyBasedArrayDataStream(ttyConnector), this.typeAheadManager, this.executorServiceManager));
        this.executorServiceManager.getUnboundedExecutorService().submit(() -> TerminalSession.start$lambda$0(this, ttyConnector));
    }

    public final void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem(this.terminationListeners, onTerminated, parentDisposable);
    }

    public final void executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        byte[] enterCode = this.getTerminalStarter().getCode(10, 0);
        this.getTerminalStarter().sendString(command, false);
        this.getTerminalStarter().sendBytes(enterCode, false);
    }

    public final void postResize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        if (this.terminalStarter != null && (newSize.getColumns() != this.model.getWidth() || newSize.getRows() != this.model.getHeight())) {
            this.getTerminalStarter().postResize(newSize, RequestOrigin.User);
        }
    }

    public final void addCommandListener(@NotNull ShellCommandListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.commandManager.addListener(listener, parentDisposable);
    }

    public static /* synthetic */ void addCommandListener$default(TerminalSession terminalSession, ShellCommandListener shellCommandListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalSession.addCommandListener(shellCommandListener, disposable);
    }

    public void dispose() {
        this.executorServiceManager.shutdownWhenAllExecuted();
        if (this.terminalStarter != null) {
            this.getTerminalStarter().close();
        }
    }

    private static final void start$lambda$0(TerminalSession this$0, TtyConnector $ttyConnector) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ttyConnector, (String)"$ttyConnector");
        this$0.getTerminalStarter().start();
        try {
            $ttyConnector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Runnable terminationListener : this$0.terminationListeners) {
            terminationListener.run();
        }
    }

    static {
        Key key = Key.create((String)"TerminalSession");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        DataKey dataKey = DataKey.create((String)"TerminalSession");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        DATA_KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSession$Companion;", "", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "getDATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "KEY", "Lcom/intellij/openapi/util/Key;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<TerminalSession> getKEY() {
            return KEY;
        }

        @NotNull
        public final DataKey<TerminalSession> getDATA_KEY() {
            return DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

