/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.MappingCandidateHarvester;

public class AwsCandidateHarvester
extends MappingCandidateHarvester {
    private static final Logger logger = Logger.getLogger(AwsCandidateHarvester.class.getName());
    private static final String PUBLIC_IP_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";
    private static final String LOCAL_IP_URL = "http://169.254.169.254/latest/meta-data/local-ipv4";
    private static final String EC2_TEST_URL = "http://169.254.169.254/latest/meta-data/";
    private static Boolean RUNNING_ON_EC2 = null;
    private static TransportAddress mask;
    private static TransportAddress face;
    private static boolean addressChecked;

    public AwsCandidateHarvester() {
        super("aws");
    }

    private static synchronized void obtainEC2Addresses() {
        if (addressChecked) {
            return;
        }
        addressChecked = true;
        String localIPStr = null;
        String publicIPStr = null;
        try {
            localIPStr = AwsCandidateHarvester.fetch(LOCAL_IP_URL);
            publicIPStr = AwsCandidateHarvester.fetch(PUBLIC_IP_URL);
            face = new TransportAddress(localIPStr, 9, Transport.UDP);
            mask = new TransportAddress(publicIPStr, 9, Transport.UDP);
            logger.info("Detected AWS local IP: " + face);
            logger.info("Detected AWS public IP: " + mask);
        }
        catch (Exception exc) {
            logger.log(Level.INFO, "We failed to obtain EC2 instance addresses for the following reason: ", exc);
            logger.info("String for local IP: " + localIPStr);
            logger.info("String for public IP: " + publicIPStr);
        }
    }

    @Override
    public TransportAddress getMask() {
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            AwsCandidateHarvester.obtainEC2Addresses();
            return mask;
        }
        return null;
    }

    @Override
    public TransportAddress getFace() {
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            AwsCandidateHarvester.obtainEC2Addresses();
            return face;
        }
        return null;
    }

    public static synchronized boolean smellsLikeAnEC2() {
        if (RUNNING_ON_EC2 == null) {
            RUNNING_ON_EC2 = AwsCandidateHarvester.doTestEc2();
        }
        return RUNNING_ON_EC2;
    }

    private static boolean doTestEc2() {
        try {
            URLConnection conn = new URL(EC2_TEST_URL).openConnection();
            conn.setConnectTimeout(500);
            conn.getContent();
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    private static String fetch(String url) throws Exception {
        URLConnection conn = new URL(url).openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        String retString = in.readLine();
        in.close();
        return retString;
    }

    static {
        addressChecked = false;
    }
}

