/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IllegalIpV6NeighborDiscoveryOption
implements IcmpV6CommonPacket.IpV6NeighborDiscoveryOption {
    private static final long serialVersionUID = 2715909582897939970L;
    private final IpV6NeighborDiscoveryOptionType type;
    private final byte[] rawData;

    public static IllegalIpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalIpV6NeighborDiscoveryOption(rawData, offset, length);
    }

    private IllegalIpV6NeighborDiscoveryOption(byte[] rawData, int offset, int length) {
        this.type = IpV6NeighborDiscoveryOptionType.getInstance(rawData[offset]);
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    private IllegalIpV6NeighborDiscoveryOption(Builder builder2) {
        if (builder2 == null || builder2.type == null || builder2.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.type: ").append(builder2.type).append(" builder.rawData: ").append(builder2.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.type = builder2.type;
        this.rawData = new byte[builder2.rawData.length];
        System.arraycopy(builder2.rawData, 0, this.rawData, 0, builder2.rawData.length);
    }

    @Override
    public IpV6NeighborDiscoveryOptionType getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy2 = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy2, 0, copy2.length);
        return copy2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.type).append("] [Illegal Raw Data: 0x").append(ByteArrays.toHexString(this.rawData, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IllegalIpV6NeighborDiscoveryOption other = (IllegalIpV6NeighborDiscoveryOption)obj;
        return this.type.equals(other.type) && Arrays.equals(other.rawData, this.rawData);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.type.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.rawData);
        return result2;
    }

    public static final class Builder {
        private IpV6NeighborDiscoveryOptionType type;
        private byte[] rawData;

        public Builder() {
        }

        private Builder(IllegalIpV6NeighborDiscoveryOption option) {
            this.type = option.type;
            this.rawData = option.rawData;
        }

        public Builder type(IpV6NeighborDiscoveryOptionType type2) {
            this.type = type2;
            return this;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public IllegalIpV6NeighborDiscoveryOption build() {
            return new IllegalIpV6NeighborDiscoveryOption(this);
        }
    }
}

