/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class RoleRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String roleId;
    private String roleName;
    private String containerId;

    public static RoleRemovedEvent create(String roleId, String roleName, String containerId) {
        RoleRemovedEvent event = new RoleRemovedEvent();
        event.roleId = roleId;
        event.roleName = roleName;
        event.containerId = containerId;
        return event;
    }

    @Override
    public String getId() {
        return this.roleId;
    }

    public String toString() {
        return String.format("RoleRemovedEvent [ roleId=%s, containerId=%s ]", this.roleId, this.containerId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.roleRemoval(this.roleId, this.roleName, this.containerId, invalidations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleRemovedEvent that = (RoleRemovedEvent)o;
        return Objects.equals(this.roleId, that.roleId) && Objects.equals(this.roleName, that.roleName) && Objects.equals(this.containerId, that.containerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.roleId, this.roleName, this.containerId);
    }

    public static class ExternalizerImpl
    implements Externalizer<RoleRemovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, RoleRemovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.roleId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.roleName, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.containerId, (ObjectOutput)output);
        }

        public RoleRemovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public RoleRemovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            RoleRemovedEvent res = new RoleRemovedEvent();
            res.roleId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.roleName = MarshallUtil.unmarshallString((ObjectInput)input);
            res.containerId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

