/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.quarkus.micrometer.runtime.binder.vertx.NetworkMetrics;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;

public class VertxUdpMetrics
implements DatagramSocketMetrics {
    private final MeterRegistry registry;
    private volatile Tags tags;
    private final String exception;
    private final String read;
    private final String sent;

    public VertxUdpMetrics(MeterRegistry registry, String prefix, Tags tags) {
        this.registry = registry;
        this.tags = tags;
        this.sent = prefix + ".bytes.written";
        this.read = prefix + ".bytes.read";
        this.exception = prefix + ".errors";
    }

    public void listening(String localName, SocketAddress localAddress) {
        this.tags = this.tags.and("address", NetworkMetrics.toString(localAddress));
    }

    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        DistributionSummary.builder((String)this.read).description("Number of bytes read").tags((Iterable)this.tags.and("remote-address", NetworkMetrics.toString(remoteAddress))).register(this.registry).record((double)numberOfBytes);
    }

    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        DistributionSummary.builder((String)this.sent).description("Number of bytes written").tags((Iterable)this.tags.and("remote-address", NetworkMetrics.toString(remoteAddress))).register(this.registry);
    }

    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        Tags copy = this.tags.and(new Tag[]{Tag.of((String)"class", (String)t.getClass().getName())});
        this.registry.counter(this.exception, (Iterable)copy).increment();
    }
}

