/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.values;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.util.ColorUtil;

public class HslValueFunction
implements StyleValueFunction {
    protected int validateHueParameter(CSSValue cSSValue) throws FunctionEvaluationException {
        CSSNumericValue cSSNumericValue;
        if (cSSValue instanceof CSSStringValue) {
            CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
            cSSNumericValue = FunctionUtilities.parseNumberValue(cSSStringValue.getValue());
        } else {
            if (!(cSSValue instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            cSSNumericValue = (CSSNumericValue)cSSValue;
        }
        if (cSSNumericValue.getType().equals(CSSNumericType.NUMBER)) {
            return (int)(cSSNumericValue.getValue() % 360.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    protected float validateOtherParameter(CSSValue cSSValue) throws FunctionEvaluationException {
        CSSNumericValue cSSNumericValue;
        if (cSSValue instanceof CSSStringValue) {
            CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
            cSSNumericValue = FunctionUtilities.parseNumberValue(cSSStringValue.getValue());
        } else {
            if (!(cSSValue instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            cSSNumericValue = (CSSNumericValue)cSSValue;
        }
        if (cSSNumericValue.getType().equals(CSSNumericType.PERCENTAGE)) {
            return (float)(cSSNumericValue.getValue() % 100.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    @Override
    public CSSValue evaluate(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSFunctionValue cSSFunctionValue) throws FunctionEvaluationException {
        CSSValue[] cSSValueArray = cSSFunctionValue.getParameters();
        if (cSSValueArray.length == 3) {
            int n = this.validateHueParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[0]));
            float f = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[1]));
            float f2 = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[2]));
            float[] fArray = ColorUtil.hslToRGB(n, f, f2);
            return new CSSColorValue(fArray[0], fArray[1], fArray[2]);
        }
        if (cSSValueArray.length == 4) {
            int n = this.validateHueParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[0]));
            float f = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[1]));
            float f3 = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[2]));
            float f4 = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[3]));
            float[] fArray = ColorUtil.hslToRGB(n, f, f3);
            return new CSSColorValue(fArray[0], fArray[1], fArray[2], f4);
        }
        throw new FunctionEvaluationException("Expected either three or four parameters.");
    }
}

