/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.session.DeviceSession;

public abstract class BaseMqttProtocolDecoder
extends BaseProtocolDecoder {
    public BaseMqttProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    protected abstract Object decode(DeviceSession var1, MqttPublishMessage var2) throws Exception;

    @Override
    protected final Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        if (msg instanceof MqttConnectMessage) {
            MqttConnectMessage message = (MqttConnectMessage)msg;
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, message.payload().clientIdentifier());
            MqttConnectReturnCode returnCode = deviceSession != null ? MqttConnectReturnCode.CONNECTION_ACCEPTED : MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED;
            MqttConnAckMessage response = MqttMessageBuilders.connAck().returnCode(returnCode).build();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        } else if (msg instanceof MqttSubscribeMessage) {
            MqttSubscribeMessage message = (MqttSubscribeMessage)msg;
            MqttSubAckMessage response = MqttMessageBuilders.subAck().packetId(message.variableHeader().messageId()).build();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        } else if (msg instanceof MqttPublishMessage) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            MqttPublishMessage message = (MqttPublishMessage)msg;
            Object result = this.decode(deviceSession, message);
            MqttMessage response = MqttMessageBuilders.pubAck().packetId(message.variableHeader().packetId()).build();
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return result;
        }
        return null;
    }
}

