/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class T622IridiumProtocolDecoder
extends BaseProtocolDecoder {
    private String format;

    public T622IridiumProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public List<Integer> getParameters(long deviceId) {
        String value = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_FORMAT.withPrefix(this.getProtocolName()), deviceId);
        return Arrays.stream((value != null ? value : this.format).split(",")).map(s -> Integer.parseInt(s, 16)).collect(Collectors.toList());
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        buf.readUnsignedInt();
        String imei = buf.readCharSequence(15, StandardCharsets.US_ASCII).toString();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedInt();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        List<Integer> parameters = this.getParameters(deviceSession.getDeviceId());
        for (int parameter : parameters) {
            switch (parameter) {
                case 1: {
                    position.set("event", buf.readUnsignedByte());
                    break;
                }
                case 2: {
                    position.setLatitude((double)buf.readIntLE() / 1000000.0);
                    break;
                }
                case 3: {
                    position.setLongitude((double)buf.readIntLE() / 1000000.0);
                    break;
                }
                case 4: {
                    position.setTime(new Date((buf.readUnsignedIntLE() + 946684800L) * 1000L));
                    break;
                }
                case 5: {
                    position.setValid(buf.readUnsignedByte() > 0);
                    break;
                }
                case 6: {
                    position.set("sat", buf.readUnsignedByte());
                    break;
                }
                case 7: {
                    position.set("rssi", buf.readUnsignedByte());
                    break;
                }
                case 8: {
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                    break;
                }
                case 9: {
                    position.setCourse(buf.readUnsignedShortLE());
                    break;
                }
                case 10: {
                    position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
                    break;
                }
                case 11: {
                    position.setAltitude(buf.readShortLE());
                    break;
                }
                case 12: {
                    position.set("odometer", buf.readUnsignedIntLE());
                    break;
                }
                case 13: {
                    position.set("hours", buf.readUnsignedIntLE() * 1000L);
                    break;
                }
                case 20: {
                    position.set("output", buf.readUnsignedByte());
                    break;
                }
                case 21: {
                    position.set("input", buf.readUnsignedByte());
                    break;
                }
                case 25: {
                    position.set("battery", (double)buf.readUnsignedShortLE() * 0.01);
                    break;
                }
                case 26: {
                    position.set("power", (double)buf.readUnsignedShortLE() * 0.01);
                    break;
                }
                case 27: {
                    buf.readUnsignedByte();
                    break;
                }
            }
        }
        return position;
    }
}

