/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.jfc;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.SAXParser;
import jdk.internal.util.xml.impl.SAXParserImpl;
import jdk.jfr.Configuration;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.jfc.JFCParserHandler;

final class JFCParser {
    static final String FILE_EXTENSION = ".jfc";
    private static final int MAXIMUM_FILE_SIZE = 0x100000;

    JFCParser() {
    }

    public static Configuration createConfiguration(String string, Reader reader) throws IOException, ParseException {
        return JFCParser.createConfiguration(string, JFCParser.readContent(reader));
    }

    public static Configuration createConfiguration(String string, String string2) throws IOException, ParseException {
        try {
            JFCParserHandler jFCParserHandler = new JFCParserHandler();
            JFCParser.parseXML(string2, jFCParserHandler);
            return PrivateAccess.getInstance().newConfiguration(string, jFCParserHandler.label, jFCParserHandler.description, jFCParserHandler.provider, jFCParserHandler.settings, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), -1);
        }
        catch (SAXException sAXException) {
            ParseException parseException = new ParseException("Error reading JFC file. " + sAXException.getMessage(), -1);
            parseException.initCause(sAXException);
            throw parseException;
        }
    }

    private static void parseXML(String string, JFCParserHandler jFCParserHandler) throws SAXException, IOException {
        CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
        SAXParserImpl sAXParserImpl = new SAXParserImpl();
        ((SAXParser)sAXParserImpl).parse(new InputSource(charArrayReader), (DefaultHandler)jFCParserHandler);
    }

    private static String readContent(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter(1024);
        int n2 = 0;
        while ((n = reader.read()) != -1) {
            charArrayWriter.write(n);
            if (++n2 < 0x100000) continue;
            throw new IOException("Presets with more than 1048576 characters can't be read.");
        }
        return new String(charArrayWriter.toCharArray());
    }
}

