/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsClient;
import org.jitsi.nlj.dtls.DtlsRole;
import org.jitsi.nlj.dtls.DtlsServer;
import org.jitsi.nlj.dtls.DtlsStack;
import org.jitsi.nlj.dtls.DtlsUtils;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.concurrent.ArrayBlockingQueueWithShutdown;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 H2\u00020\u0001:\u0005HIJKLB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020:J\u0006\u0010<\u001a\u00020:J\u0006\u0010=\u001a\u00020>J\b\u0010?\u001a\u00020:H\u0002J\u001e\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020%J\u001e\u0010C\u001a\u00020:2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020%J\u0006\u0010D\u001a\u00020:J\u0012\u0010E\u001a\u00020:2\b\u0010F\u001a\u0004\u0018\u00010GH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u000e\u0010#\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R&\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00104\u001a\u0004\u0018\u0001032\b\u00102\u001a\u0004\u0018\u000103@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jitsi/nlj/dtls/DtlsStack;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/utils/logging2/Logger;)V", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "certificateInfo$1", "datagramTransport", "Lorg/bouncycastle/tls/DatagramTransport;", "dtlsAppDataBuf", "", "dtlsTransport", "Lorg/bouncycastle/tls/DTLSTransport;", "eventHandler", "Lorg/jitsi/nlj/dtls/DtlsStack$EventHandler;", "getEventHandler", "()Lorg/jitsi/nlj/dtls/DtlsStack$EventHandler;", "setEventHandler", "(Lorg/jitsi/nlj/dtls/DtlsStack$EventHandler;)V", "incomingDataHandler", "Lorg/jitsi/nlj/dtls/DtlsStack$IncomingDataHandler;", "getIncomingDataHandler", "()Lorg/jitsi/nlj/dtls/DtlsStack$IncomingDataHandler;", "setIncomingDataHandler", "(Lorg/jitsi/nlj/dtls/DtlsStack$IncomingDataHandler;)V", "incomingProtocolData", "Lorg/jitsi/utils/concurrent/ArrayBlockingQueueWithShutdown;", "Ljava/nio/ByteBuffer;", "localFingerprint", "", "getLocalFingerprint", "()Ljava/lang/String;", "localFingerprintHashFunction", "getLocalFingerprintHashFunction", "logger", "numPacketDropsQueueFull", "", "outgoingDataHandler", "Lorg/jitsi/nlj/dtls/DtlsStack$OutgoingDataHandler;", "getOutgoingDataHandler", "()Lorg/jitsi/nlj/dtls/DtlsStack$OutgoingDataHandler;", "setOutgoingDataHandler", "(Lorg/jitsi/nlj/dtls/DtlsStack$OutgoingDataHandler;)V", "remoteFingerprints", "", "getRemoteFingerprints", "()Ljava/util/Map;", "setRemoteFingerprints", "(Ljava/util/Map;)V", "<set-?>", "Lorg/jitsi/nlj/dtls/DtlsRole;", "role", "getRole", "()Lorg/jitsi/nlj/dtls/DtlsRole;", "roleSet", "Ljava/util/concurrent/CountDownLatch;", "actAsClient", "", "actAsServer", "close", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "processIncomingProtocolData", "data", "off", "len", "sendApplicationData", "start", "verifyAndValidateRemoteCertificate", "remoteCertificate", "Lorg/bouncycastle/tls/Certificate;", "Companion", "DatagramTransportImpl", "EventHandler", "IncomingDataHandler", "OutgoingDataHandler", "jitsi-media-transform"})
public final class DtlsStack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final CountDownLatch roleSet;
    @NotNull
    private final CertificateInfo certificateInfo$1;
    @NotNull
    private Map<String, String> remoteFingerprints;
    @Nullable
    private IncomingDataHandler incomingDataHandler;
    @Nullable
    private OutgoingDataHandler outgoingDataHandler;
    @Nullable
    private EventHandler eventHandler;
    @NotNull
    private final ArrayBlockingQueueWithShutdown<ByteBuffer> incomingProtocolData;
    private int numPacketDropsQueueFull;
    @Nullable
    private DtlsRole role;
    @NotNull
    private final byte[] dtlsAppDataBuf;
    @Nullable
    private DTLSTransport dtlsTransport;
    @NotNull
    private final DatagramTransport datagramTransport;
    private static final int QUEUE_SIZE = 50;
    @NotNull
    private static final Object syncRoot = new Object();
    @NotNull
    private static CertificateInfo certificateInfo = DtlsUtils.Companion.generateCertificateInfo();

    public DtlsStack(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.roleSet = new CountDownLatch(1);
        this.certificateInfo$1 = DtlsStack.Companion.getCertificateInfo();
        this.remoteFingerprints = new HashMap();
        this.incomingProtocolData = new ArrayBlockingQueueWithShutdown(50, true);
        this.dtlsAppDataBuf = new byte[1500];
        this.datagramTransport = new DatagramTransportImpl(this.logger);
    }

    @NotNull
    public final String getLocalFingerprintHashFunction() {
        return this.certificateInfo$1.getLocalFingerprintHashFunction();
    }

    @NotNull
    public final String getLocalFingerprint() {
        return this.certificateInfo$1.getLocalFingerprint();
    }

    @NotNull
    public final Map<String, String> getRemoteFingerprints() {
        return this.remoteFingerprints;
    }

    public final void setRemoteFingerprints(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.remoteFingerprints = map;
    }

    @Nullable
    public final IncomingDataHandler getIncomingDataHandler() {
        return this.incomingDataHandler;
    }

    public final void setIncomingDataHandler(@Nullable IncomingDataHandler incomingDataHandler) {
        this.incomingDataHandler = incomingDataHandler;
    }

    @Nullable
    public final OutgoingDataHandler getOutgoingDataHandler() {
        return this.outgoingDataHandler;
    }

    public final void setOutgoingDataHandler(@Nullable OutgoingDataHandler outgoingDataHandler) {
        this.outgoingDataHandler = outgoingDataHandler;
    }

    @Nullable
    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public final void setEventHandler(@Nullable EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Nullable
    public final DtlsRole getRole() {
        return this.role;
    }

    public final void actAsServer() {
        this.role = new DtlsServer(this.datagramTransport, this.certificateInfo$1, new Function3<Integer, TlsRole, byte[], Unit>(this){
            final /* synthetic */ DtlsStack this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(int chosenSrtpProfile, @NotNull TlsRole tlsRole, @NotNull byte[] keyingMaterial) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), "tlsRole");
                    Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
                    EventHandler eventHandler = this.this$0.getEventHandler();
                    if (eventHandler == null) break block0;
                    eventHandler.handshakeComplete(chosenSrtpProfile, tlsRole, keyingMaterial);
                }
            }
        }, new Function1<Certificate, Unit>((Object)this){

            public final void invoke(@Nullable Certificate p0) {
                DtlsStack.access$verifyAndValidateRemoteCertificate((DtlsStack)this.receiver, p0);
            }
        }, this.logger, null, 32, null);
        this.roleSet.countDown();
    }

    public final void actAsClient() {
        this.role = new DtlsClient(this.datagramTransport, this.certificateInfo$1, new Function3<Integer, TlsRole, byte[], Unit>(this){
            final /* synthetic */ DtlsStack this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(int chosenSrtpProfile, @NotNull TlsRole tlsRole, @NotNull byte[] keyingMaterial) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), "tlsRole");
                    Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
                    EventHandler eventHandler = this.this$0.getEventHandler();
                    if (eventHandler == null) break block0;
                    eventHandler.handshakeComplete(chosenSrtpProfile, tlsRole, keyingMaterial);
                }
            }
        }, new Function1<Certificate, Unit>((Object)this){

            public final void invoke(@Nullable Certificate p0) {
                DtlsStack.access$verifyAndValidateRemoteCertificate((DtlsStack)this.receiver, p0);
            }
        }, this.logger, null, 32, null);
        this.roleSet.countDown();
    }

    public final void start() {
        this.roleSet.await();
        DtlsRole dtlsRole = this.role;
        this.dtlsTransport = dtlsRole != null ? dtlsRole.start() : null;
        this.processIncomingProtocolData();
    }

    public final void close() {
        this.datagramTransport.close();
        this.incomingProtocolData.shutdown();
        Iterable $this$forEach$iv = this.incomingProtocolData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ByteBuffer it = (ByteBuffer)element$iv;
            boolean bl = false;
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            byte[] byArray = it.array();
            Intrinsics.checkNotNullExpressionValue(byArray, "it.array()");
            function1.invoke(byArray);
        }
        this.incomingProtocolData.clear();
    }

    private final void verifyAndValidateRemoteCertificate(Certificate remoteCertificate) {
        Unit unit;
        Certificate certificate = remoteCertificate;
        if (certificate != null) {
            Certificate it = certificate;
            boolean bl = false;
            DtlsUtils.Companion.verifyAndValidateCertificate(it, this.remoteFingerprints);
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl2 = false;
                logger.debug("Fingerprints verified.");
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            DtlsStack $this$verifyAndValidateRemoteCertificate_u24lambda_u2d3 = this;
            boolean bl = false;
            throw new DtlsUtils.DtlsException("Remote certificate was null");
        }
    }

    public final void sendApplicationData(@NotNull byte[] data2, int off, int len) {
        block0: {
            Intrinsics.checkNotNullParameter(data2, "data");
            DTLSTransport dTLSTransport = this.dtlsTransport;
            if (dTLSTransport == null) break block0;
            dTLSTransport.send(data2, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processIncomingProtocolData() {
        int bytesReceived = 0;
        do {
            byte[] byArray;
            byte[] byArray2 = this.dtlsAppDataBuf;
            synchronized (byArray2) {
                byte[] byArray3;
                boolean bl = false;
                DTLSTransport dTLSTransport = this.dtlsTransport;
                int n = bytesReceived = dTLSTransport != null ? dTLSTransport.receive(this.dtlsAppDataBuf, 0, 1500, 1) : -1;
                if (bytesReceived > 0) {
                    byte[] byArray4;
                    byte[] $this$processIncomingProtocolData_u24lambda_u2d5_u24lambda_u2d4 = byArray4 = BufferPool.Companion.getGetBuffer().invoke(bytesReceived);
                    boolean bl2 = false;
                    System.arraycopy(this.dtlsAppDataBuf, 0, $this$processIncomingProtocolData_u24lambda_u2d5_u24lambda_u2d4, 0, bytesReceived);
                    byArray3 = byArray4;
                } else {
                    byArray3 = null;
                }
                byArray = byArray3;
            }
            byte[] bufCopy2 = byArray;
            if (bufCopy2 == null) continue;
            IncomingDataHandler incomingDataHandler = this.incomingDataHandler;
            if (incomingDataHandler == null) continue;
            incomingDataHandler.dataReceived(bufCopy2, 0, bytesReceived);
        } while (bytesReceived > 0);
    }

    public final void processIncomingProtocolData(@NotNull byte[] data2, int off, int len) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(data2, "data");
        byte[] $this$processIncomingProtocolData_u24lambda_u2d6 = byArray = BufferPool.Companion.getGetBuffer().invoke(len);
        boolean bl = false;
        System.arraycopy(data2, off, $this$processIncomingProtocolData_u24lambda_u2d6, 0, len);
        byte[] bufCopy = byArray;
        if (!this.incomingProtocolData.offer(ByteBuffer.wrap(bufCopy, 0, len))) {
            BufferPool.Companion.getReturnBuffer().invoke(bufCopy);
            if (!this.incomingProtocolData.isShutdown()) {
                this.logger.warn("DTLS stack queue full, dropping packet");
                int n = this.numPacketDropsQueueFull;
                this.numPacketDropsQueueFull = n + 1;
            }
        }
        this.processIncomingProtocolData();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OrderedJsonObject getDebugState() {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2d8 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$getDebugState_u24lambda_u2d8.put("localFingerprintHashFunction", this.certificateInfo$1.getLocalFingerprint());
        Map<String, String> map = this.remoteFingerprints;
        String string = "remoteFingerprints";
        OrderedJsonObject orderedJsonObject2 = $this$getDebugState_u24lambda_u2d8;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String hash = (String)entry.getKey();
            String fp = (String)entry.getValue();
            collection.add((CallSite)((Object)(hash + ": " + fp)));
        }
        collection = (List)destination$iv$iv;
        orderedJsonObject2.put(string, CollectionsKt.joinToString$default(collection, null, null, null, 0, null, null, 63, null));
        Object object = this.role;
        $this$getDebugState_u24lambda_u2d8.put("role", String.valueOf(object != null && (object = object.getClass()) != null ? (Serializable)object : (Serializable)((Object)"null")));
        $this$getDebugState_u24lambda_u2d8.put("num_packet_drops_queue_full", (Object)this.numPacketDropsQueueFull);
        return orderedJsonObject;
    }

    public static final /* synthetic */ void access$verifyAndValidateRemoteCertificate(DtlsStack $this, Certificate remoteCertificate) {
        $this.verifyAndValidateRemoteCertificate(remoteCertificate);
    }

    public static final /* synthetic */ void access$setCertificateInfo$cp(CertificateInfo certificateInfo2) {
        certificateInfo = certificateInfo2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jitsi/nlj/dtls/DtlsStack$Companion;", "", "()V", "QUEUE_SIZE", "", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "getCertificateInfo", "()Lorg/jitsi/nlj/dtls/CertificateInfo;", "syncRoot", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final CertificateInfo getCertificateInfo() {
            Object object = syncRoot;
            synchronized (object) {
                boolean bl = false;
                long expirationPeriodMs = Duration.ofDays(1L).toMillis();
                if (certificateInfo.getCreationTimestampMs() + expirationPeriodMs < System.currentTimeMillis()) {
                    ThreadsKt.thread$default(false, false, null, null, 0, certificateInfo.1.1.INSTANCE, 31, null);
                }
                CertificateInfo certificateInfo2 = certificateInfo;
                return certificateInfo2;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J(\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/dtls/DtlsStack$DatagramTransportImpl;", "Lorg/bouncycastle/tls/DatagramTransport;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/dtls/DtlsStack;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "close", "", "getReceiveLimit", "", "getSendLimit", "receive", "buf", "", "off", "len", "waitMillis", "send", "jitsi-media-transform"})
    public final class DatagramTransportImpl
    implements DatagramTransport {
        @NotNull
        private final Logger logger;

        public DatagramTransportImpl(Logger parentLogger) {
            Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
            this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        }

        @Override
        public int receive(@NotNull byte[] buf, int off, int len, int waitMillis) {
            ByteBuffer byteBuffer;
            Intrinsics.checkNotNullParameter(buf, "buf");
            try {
                ByteBuffer byteBuffer2 = (ByteBuffer)DtlsStack.this.incomingProtocolData.poll(waitMillis, TimeUnit.MILLISECONDS);
                if (byteBuffer2 == null) {
                    return -1;
                }
                byteBuffer = byteBuffer2;
            }
            catch (InterruptedException ie) {
                return -1;
            }
            ByteBuffer data2 = byteBuffer;
            int length = Math.min(len, data2.limit());
            if (length < data2.limit()) {
                this.logger.warn("Passed buffer size (" + len + ") was too small to hold incoming data size (" + data2.limit() + "); data was truncated");
            }
            System.arraycopy(data2.array(), data2.arrayOffset(), buf, off, length);
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            byte[] byArray = data2.array();
            Intrinsics.checkNotNullExpressionValue(byArray, "data.array()");
            function1.invoke(byArray);
            return length;
        }

        @Override
        public void send(@NotNull byte[] buf, int off, int len) {
            block0: {
                Intrinsics.checkNotNullParameter(buf, "buf");
                OutgoingDataHandler outgoingDataHandler = DtlsStack.this.getOutgoingDataHandler();
                if (outgoingDataHandler == null) break block0;
                outgoingDataHandler.sendData(buf, off, len);
            }
        }

        @Override
        public int getReceiveLimit() {
            return 1472;
        }

        @Override
        public int getSendLimit() {
            return 1408;
        }

        @Override
        public void close() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lorg/jitsi/nlj/dtls/DtlsStack$IncomingDataHandler;", "", "dataReceived", "", "data", "", "off", "", "len", "jitsi-media-transform"})
    public static interface IncomingDataHandler {
        public void dataReceived(@NotNull byte[] var1, int var2, int var3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lorg/jitsi/nlj/dtls/DtlsStack$OutgoingDataHandler;", "", "sendData", "", "data", "", "off", "", "len", "jitsi-media-transform"})
    public static interface OutgoingDataHandler {
        public void sendData(@NotNull byte[] var1, int var2, int var3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lorg/jitsi/nlj/dtls/DtlsStack$EventHandler;", "", "handshakeComplete", "", "chosenSrtpProtectionProfile", "", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "jitsi-media-transform"})
    public static interface EventHandler {
        public void handshakeComplete(int var1, @NotNull TlsRole var2, @NotNull byte[] var3);
    }
}

