/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.vp9;

import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.VideoCodecParser;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.util.StateChangeLogger;
import org.jitsi.rtp.extensions.ByteArrayBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Parser;", "Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "([Lorg/jitsi/nlj/MediaSourceDesc;Lorg/jitsi/utils/logging2/Logger;)V", "extendedPictureIdState", "Lorg/jitsi/nlj/util/StateChangeLogger;", "logger", "numSpatialLayers", "", "pictureIdState", "ssrcsSeen", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "parse", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "jitsi-media-transform"})
public final class Vp9Parser
extends VideoCodecParser {
    @NotNull
    private final Logger logger;
    @NotNull
    private final StateChangeLogger pictureIdState;
    @NotNull
    private final StateChangeLogger extendedPictureIdState;
    private int numSpatialLayers;
    @NotNull
    private final HashSet<Long> ssrcsSeen;

    public Vp9Parser(@NotNull MediaSourceDesc[] sources, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(sources);
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.pictureIdState = new StateChangeLogger("missing picture id", this.logger);
        this.extendedPictureIdState = new StateChangeLogger("missing extended picture ID", this.logger);
        this.numSpatialLayers = -1;
        this.ssrcsSeen = new HashSet();
    }

    @Override
    public void parse(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Vp9Packet vp9Packet = (Vp9Packet)packetInfo.packetAs();
        this.ssrcsSeen.add(vp9Packet.getSsrc());
        if (vp9Packet.getHasScalabilityStructure()) {
            int packetSpatialLayers = vp9Packet.getScalabilityStructureNumSpatial();
            if (packetSpatialLayers != -1) {
                if (this.numSpatialLayers != -1 && this.numSpatialLayers != packetSpatialLayers) {
                    packetInfo.setLayeringChanged(true);
                }
                this.numSpatialLayers = packetSpatialLayers;
            }
            Pair<MediaSourceDesc, RtpEncodingDesc> pair = this.findSourceDescAndRtpEncodingDesc(vp9Packet);
            if (pair != null) {
                Pair<MediaSourceDesc, RtpEncodingDesc> pair2 = pair;
                boolean bl = false;
                MediaSourceDesc src = pair2.component1();
                RtpEncodingDesc enc = pair2.component2();
                RtpEncodingDesc rtpEncodingDesc = Vp9Packet.getScalabilityStructure$default(vp9Packet, enc.getEid(), 0.0, 2, null);
                if (rtpEncodingDesc != null) {
                    RtpEncodingDesc it = rtpEncodingDesc;
                    boolean bl2 = false;
                    src.setEncodingLayers(it.getLayers$jitsi_media_transform(), vp9Packet.getSsrc());
                }
                for (RtpEncodingDesc otherEnc : src.getRtpEncodings()) {
                    if (this.ssrcsSeen.contains(otherEnc.getPrimarySSRC())) continue;
                    boolean $i$f$emptyArray = false;
                    src.setEncodingLayers((RtpLayerDesc[])((Object[])new RtpLayerDesc[0]), otherEnc.getPrimarySSRC());
                }
            }
        }
        if (vp9Packet.getSpatialLayerIndex() > 0 && vp9Packet.isInterPicturePredicted()) {
            RtpLayerDesc rtpLayerDesc = this.findRtpLayerDesc(vp9Packet);
            if (rtpLayerDesc != null) {
                rtpLayerDesc.setUseSoftDependencies(vp9Packet.getUsesInterLayerDependency());
            }
        }
        this.pictureIdState.setState(vp9Packet.getHasPictureId(), vp9Packet, new Function0<String>(vp9Packet){
            final /* synthetic */ Vp9Packet $vp9Packet;
            {
                this.$vp9Packet = $vp9Packet;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Packet Data: " + ByteArrayBufferKt.toHex(this.$vp9Packet, 80);
            }
        });
        this.extendedPictureIdState.setState(vp9Packet.getHasExtendedPictureId(), vp9Packet, new Function0<String>(vp9Packet){
            final /* synthetic */ Vp9Packet $vp9Packet;
            {
                this.$vp9Packet = $vp9Packet;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Packet Data: " + ByteArrayBufferKt.toHex(this.$vp9Packet, 80);
            }
        });
    }
}

