/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.stat.TimerTracker;

public class FunctionTimerTrackerImpl
implements TimerTracker {
    private final LongAdder counter;
    private final DoubleAdder totalTime;
    private final TimeUnit totalTimeTimeUnit;

    FunctionTimerTrackerImpl(TimeUnit totalTimeTimeUnit) {
        this.totalTimeTimeUnit = Objects.requireNonNull(totalTimeTimeUnit);
        this.counter = new LongAdder();
        this.totalTime = new DoubleAdder();
    }

    public void update(Duration duration) {
        this.update(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void update(long value, TimeUnit timeUnit) {
        this.counter.increment();
        this.totalTime.add(TimeUtils.convert((double)value, (TimeUnit)timeUnit, (TimeUnit)this.totalTimeTimeUnit));
    }

    private long count() {
        return this.counter.sum();
    }

    private double totalTime() {
        return this.totalTime.sum();
    }

    public FunctionTimer.Builder<FunctionTimerTrackerImpl> create(String metricName) {
        return FunctionTimer.builder((String)metricName, (Object)this, FunctionTimerTrackerImpl::count, FunctionTimerTrackerImpl::totalTime, (TimeUnit)this.totalTimeTimeUnit);
    }
}

