/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.puma;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class MiniSSL
extends RubyObject {
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new MiniSSL(ruby, rubyClass);
        }
    };
    private SSLEngine engine;
    private boolean closed;
    private boolean handshake;
    private MiniSSLBuffer inboundNetData;
    private MiniSSLBuffer outboundAppData;
    private MiniSSLBuffer outboundNetData;
    private static Map<String, KeyManagerFactory> keyManagerFactoryMap = new ConcurrentHashMap<String, KeyManagerFactory>();
    private static Map<String, TrustManagerFactory> trustManagerFactoryMap = new ConcurrentHashMap<String, TrustManagerFactory>();
    private volatile transient X509Certificate lastCheckedCert0;

    public static void createMiniSSL(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Puma");
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("MiniSSL");
        rubyModule2.defineClassUnder("SSLError", ruby.getStandardError(), ruby.getStandardError().getAllocator());
        RubyClass rubyClass = rubyModule2.defineClassUnder("Engine", ruby.getObject(), ALLOCATOR);
        rubyClass.defineAnnotatedMethods(MiniSSL.class);
    }

    public MiniSSL(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static synchronized IRubyObject server(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore;
        KeyStore keyStore2;
        String string;
        Object object;
        String string2;
        String string3 = MiniSSL.asStringValue(iRubyObject2.callMethod(threadContext, "keystore"), null);
        char[] cArray = MiniSSL.asStringValue(iRubyObject2.callMethod(threadContext, "keystore_pass"), null).toCharArray();
        String string4 = MiniSSL.asStringValue(iRubyObject2.callMethod(threadContext, "keystore_type"), KeyStore::getDefaultType);
        IRubyObject iRubyObject3 = iRubyObject2.callMethod(threadContext, "truststore");
        if (iRubyObject3.isNil()) {
            string2 = string3;
            object = cArray;
            string = string4;
        } else if (!MiniSSL.isDefaultSymbol(threadContext, iRubyObject3)) {
            string2 = iRubyObject3.convertToString().asJavaString();
            keyStore2 = iRubyObject2.callMethod(threadContext, "truststore_pass");
            object = keyStore2.isNil() ? null : MiniSSL.asStringValue((IRubyObject)keyStore2, null).toCharArray();
            string = MiniSSL.asStringValue(iRubyObject2.callMethod(threadContext, "truststore_type"), KeyStore::getDefaultType);
        } else {
            string2 = null;
            object = null;
            string = null;
        }
        keyStore2 = KeyStore.getInstance(string4);
        try (FileInputStream fileInputStream = new FileInputStream(string3);){
            keyStore2.load(fileInputStream, cArray);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore2, cArray);
        keyManagerFactoryMap.put(string3, keyManagerFactory);
        if (string2 != null) {
            keyStore = KeyStore.getInstance(string);
            fileInputStream = new FileInputStream(string2);
            try {
                keyStore.load(fileInputStream, (char[])object);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
            trustManagerFactoryMap.put(string2, trustManagerFactory);
        }
        keyStore = (RubyClass)iRubyObject;
        return keyStore.newInstance(threadContext, iRubyObject2, Block.NULL_BLOCK);
    }

    private static String asStringValue(IRubyObject iRubyObject, Supplier<String> supplier) {
        if (supplier != null && iRubyObject.isNil()) {
            return supplier.get();
        }
        return iRubyObject.convertToString().asJavaString();
    }

    private static boolean isDefaultSymbol(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.runtime.newSymbol("default").equals((Object)iRubyObject);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        IRubyObject iRubyObject2;
        String[] stringArray;
        String string = iRubyObject.callMethod(threadContext, "keystore").convertToString().asJavaString();
        KeyManagerFactory keyManagerFactory = keyManagerFactoryMap.get(string);
        IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, "truststore");
        String string2 = MiniSSL.isDefaultSymbol(threadContext, iRubyObject3) ? "" : MiniSSL.asStringValue(iRubyObject3, () -> string);
        TrustManagerFactory trustManagerFactory = trustManagerFactoryMap.get(string2);
        if (keyManagerFactory == null) {
            throw new KeyStoreException("Could not find KeyManagerFactory for keystore: " + string + " truststore: " + string2);
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), this.getTrustManagers(trustManagerFactory), null);
        this.closed = false;
        this.handshake = false;
        this.engine = sSLContext.createSSLEngine();
        IRubyObject iRubyObject4 = iRubyObject.callMethod(threadContext, "protocols");
        if (iRubyObject4.isNil()) {
            stringArray = iRubyObject.callMethod(threadContext, "no_tlsv1").isTrue() ? new String[]{"TLSv1.1", "TLSv1.2", "TLSv1.3"} : new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
            if (iRubyObject.callMethod(threadContext, "no_tlsv1_1").isTrue()) {
                stringArray = new String[]{"TLSv1.2", "TLSv1.3"};
            }
        } else if (iRubyObject4 instanceof RubyArray) {
            stringArray = (String[])((RubyArray)iRubyObject4).toArray((Object[])new String[0]);
        } else {
            throw threadContext.runtime.newTypeError(iRubyObject4, threadContext.runtime.getArray());
        }
        this.engine.setEnabledProtocols(stringArray);
        this.engine.setUseClientMode(false);
        long l = iRubyObject.callMethod(threadContext, "verify_mode").convertToInteger("to_i").getLongValue();
        if ((l & 1L) != 0L) {
            this.engine.setWantClientAuth(true);
        }
        if ((l & 2L) != 0L) {
            this.engine.setNeedClientAuth(true);
        }
        if ((iRubyObject2 = iRubyObject.callMethod(threadContext, "cipher_suites")) instanceof RubyArray) {
            this.engine.setEnabledCipherSuites((String[])((RubyArray)iRubyObject2).toArray((Object[])new String[0]));
        } else if (!iRubyObject2.isNil()) {
            throw threadContext.runtime.newTypeError(iRubyObject2, threadContext.runtime.getArray());
        }
        SSLSession sSLSession = this.engine.getSession();
        this.inboundNetData = new MiniSSLBuffer(sSLSession.getPacketBufferSize());
        this.outboundAppData = new MiniSSLBuffer(sSLSession.getApplicationBufferSize());
        this.outboundAppData.flip();
        this.outboundNetData = new MiniSSLBuffer(sSLSession.getPacketBufferSize());
        return this;
    }

    private TrustManager[] getTrustManagers(TrustManagerFactory trustManagerFactory) {
        if (trustManagerFactory == null) {
            return null;
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray != null) {
            for (int i = 0; i < trustManagerArray.length; ++i) {
                TrustManager trustManager = trustManagerArray[i];
                if (!(trustManager instanceof X509TrustManager)) continue;
                trustManagerArray[i] = new TrustManagerWrapper((X509TrustManager)trustManager);
            }
        }
        return trustManagerArray;
    }

    @JRubyMethod
    public IRubyObject inject(IRubyObject iRubyObject) {
        ByteList byteList = iRubyObject.convertToString().getByteList();
        this.inboundNetData.put(byteList.unsafeBytes(), byteList.getBegin(), byteList.getRealSize());
        return this;
    }

    private SSLEngineResult doOp(SSLOperation sSLOperation, MiniSSLBuffer miniSSLBuffer, MiniSSLBuffer miniSSLBuffer2) throws SSLException {
        SSLEngineResult sSLEngineResult = null;
        boolean bl = true;
        while (bl) {
            switch (sSLOperation) {
                case WRAP: {
                    sSLEngineResult = this.engine.wrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                case UNWRAP: {
                    sSLEngineResult = this.engine.unwrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown SSLOperation: " + (Object)((Object)sSLOperation)));
                }
            }
            switch (sSLEngineResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    int n = Math.max(this.engine.getSession().getPacketBufferSize(), this.engine.getSession().getApplicationBufferSize());
                    miniSSLBuffer2.resize(n + miniSSLBuffer2.position());
                    bl = true;
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    bl = false;
                    break;
                }
                case CLOSED: {
                    this.closed = true;
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
            this.handshake = true;
        }
        return sSLEngineResult;
    }

    @JRubyMethod
    public IRubyObject read() {
        try {
            Object object;
            this.inboundNetData.flip();
            if (!this.inboundNetData.hasRemaining()) {
                return this.getRuntime().getNil();
            }
            MiniSSLBuffer miniSSLBuffer = new MiniSSLBuffer(this.engine.getSession().getApplicationBufferSize());
            this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            boolean bl = false;
            block7: while (!bl) {
                switch (handshakeStatus) {
                    case NEED_WRAP: {
                        object = this.doOp(SSLOperation.WRAP, miniSSLBuffer, this.outboundNetData);
                        handshakeStatus = ((SSLEngineResult)object).getHandshakeStatus();
                        continue block7;
                    }
                    case NEED_UNWRAP: {
                        object = this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
                        if (((SSLEngineResult)object).getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            bl = true;
                        }
                        handshakeStatus = ((SSLEngineResult)object).getHandshakeStatus();
                        continue block7;
                    }
                    case NEED_TASK: {
                        Runnable runnable;
                        while ((runnable = this.engine.getDelegatedTask()) != null) {
                            runnable.run();
                        }
                        handshakeStatus = this.engine.getHandshakeStatus();
                        continue block7;
                    }
                }
                bl = true;
            }
            if (this.inboundNetData.hasRemaining()) {
                this.inboundNetData.compact();
            } else {
                this.inboundNetData.clear();
            }
            object = miniSSLBuffer.asByteList();
            if (object == null) {
                return this.getRuntime().getNil();
            }
            return RubyString.newString((Ruby)this.getRuntime(), (ByteList)object);
        }
        catch (SSLException sSLException) {
            throw MiniSSL.newSSLError(this.getRuntime(), sSLException);
        }
    }

    @JRubyMethod
    public IRubyObject write(IRubyObject iRubyObject) {
        byte[] byArray = iRubyObject.convertToString().getBytes();
        this.outboundAppData = new MiniSSLBuffer(byArray);
        return this.getRuntime().newFixnum(byArray.length);
    }

    @JRubyMethod
    public IRubyObject extract(ThreadContext threadContext) {
        try {
            ByteList byteList = this.outboundNetData.asByteList();
            if (byteList != null) {
                return RubyString.newString((Ruby)threadContext.runtime, (ByteList)byteList);
            }
            if (!this.outboundAppData.hasRemaining()) {
                return threadContext.nil;
            }
            this.outboundNetData.clear();
            this.doOp(SSLOperation.WRAP, this.outboundAppData, this.outboundNetData);
            byteList = this.outboundNetData.asByteList();
            if (byteList == null) {
                return threadContext.nil;
            }
            return RubyString.newString((Ruby)threadContext.runtime, (ByteList)byteList);
        }
        catch (SSLException sSLException) {
            throw MiniSSL.newSSLError(this.getRuntime(), sSLException);
        }
    }

    @JRubyMethod
    public IRubyObject peercert(ThreadContext threadContext) throws CertificateEncodingException {
        Certificate certificate;
        try {
            certificate = this.engine.getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            certificate = this.lastCheckedCert0;
        }
        return certificate == null ? threadContext.nil : JavaEmbedUtils.javaToRuby((Ruby)threadContext.runtime, (Object)certificate.getEncoded());
    }

    @JRubyMethod(name={"init?"})
    public IRubyObject isInit(ThreadContext threadContext) {
        return this.handshake ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    @JRubyMethod
    public IRubyObject shutdown() {
        if (this.closed || this.engine.isInboundDone() && this.engine.isOutboundDone()) {
            if (this.engine.isOutboundDone()) {
                this.engine.closeOutbound();
            }
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private static RubyClass getSSLError(Ruby ruby) {
        return (RubyClass)((RubyModule)ruby.getModule("Puma").getConstantAt("MiniSSL")).getConstantAt("SSLError");
    }

    private static RaiseException newSSLError(Ruby ruby, SSLException sSLException) {
        return MiniSSL.newError(ruby, MiniSSL.getSSLError(ruby), sSLException.toString(), sSLException);
    }

    private static RaiseException newError(Ruby ruby, RubyClass rubyClass, String string, Throwable throwable) {
        RaiseException raiseException = new RaiseException(ruby, rubyClass, string, true);
        raiseException.initCause(throwable);
        return raiseException;
    }

    private static class MiniSSLBuffer {
        ByteBuffer buffer;

        private MiniSSLBuffer(int n) {
            this.buffer = ByteBuffer.allocate(n);
        }

        private MiniSSLBuffer(byte[] byArray) {
            this.buffer = ByteBuffer.wrap(byArray);
        }

        public void clear() {
            this.buffer.clear();
        }

        public void compact() {
            this.buffer.compact();
        }

        public void flip() {
            ((Buffer)this.buffer).flip();
        }

        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        public int position() {
            return this.buffer.position();
        }

        public ByteBuffer getRawBuffer() {
            return this.buffer;
        }

        private void put(byte[] byArray, int n, int n2) {
            if (this.buffer.remaining() < n2) {
                this.resize(this.buffer.limit() + n2);
            }
            this.buffer.put(byArray, n, n2);
        }

        public void resize(int n) {
            if (n > this.buffer.capacity()) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                this.flip();
                byteBuffer.put(this.buffer);
                this.buffer = byteBuffer;
            } else {
                this.buffer.limit(n);
            }
        }

        public ByteList asByteList() {
            this.flip();
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                return null;
            }
            byte[] byArray = new byte[this.buffer.limit()];
            this.buffer.get(byArray);
            this.buffer.clear();
            return new ByteList(byArray, false);
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    private class TrustManagerWrapper
    implements X509TrustManager {
        private final X509TrustManager delegate;

        TrustManagerWrapper(X509TrustManager x509TrustManager) {
            this.delegate = x509TrustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            MiniSSL.this.lastCheckedCert0 = x509CertificateArray.length > 0 ? x509CertificateArray[0] : null;
            this.delegate.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.delegate.checkServerTrusted(x509CertificateArray, string);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }
    }

    private static enum SSLOperation {
        WRAP,
        UNWRAP;

    }
}

