/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.discovery;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Filter;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.Output;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.plugins.AliasRegistry;
import org.logstash.plugins.PluginLookup;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public final class PluginRegistry {
    private static final Logger LOGGER = LogManager.getLogger(PluginRegistry.class);
    private final Map<String, Class<Input>> inputs = new HashMap<String, Class<Input>>();
    private final Map<String, Class<Filter>> filters = new HashMap<String, Class<Filter>>();
    private final Map<String, Class<Output>> outputs = new HashMap<String, Class<Output>>();
    private final Map<String, Class<Codec>> codecs = new HashMap<String, Class<Codec>>();
    private static final Object LOCK = new Object();
    private static volatile PluginRegistry INSTANCE;
    private final AliasRegistry aliasRegistry = AliasRegistry.getInstance();

    private PluginRegistry() {
        this.discoverPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginRegistry getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new PluginRegistry();
                }
            }
        }
        return INSTANCE;
    }

    private void discoverPlugins() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"org.logstash.plugins", (ClassLoader[])new ClassLoader[0])).filterInputsBy(input -> input.endsWith(".class"));
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set annotated = reflections.getTypesAnnotatedWith(LogstashPlugin.class);
        block0: for (Class cls : annotated) {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!(annotation instanceof LogstashPlugin)) continue;
                String name = ((LogstashPlugin)annotation).name();
                if (Filter.class.isAssignableFrom(cls)) {
                    this.filters.put(name, cls);
                }
                if (Output.class.isAssignableFrom(cls)) {
                    this.outputs.put(name, cls);
                }
                if (Input.class.isAssignableFrom(cls)) {
                    this.inputs.put(name, cls);
                }
                if (!Codec.class.isAssignableFrom(cls)) continue block0;
                this.codecs.put(name, cls);
                continue block0;
            }
        }
        this.addAliasedPlugins(PluginLookup.PluginType.FILTER, this.filters);
        this.addAliasedPlugins(PluginLookup.PluginType.OUTPUT, this.outputs);
        this.addAliasedPlugins(PluginLookup.PluginType.INPUT, this.inputs);
        this.addAliasedPlugins(PluginLookup.PluginType.CODEC, this.codecs);
    }

    private <T> void addAliasedPlugins(PluginLookup.PluginType type, Map<String, Class<T>> pluginCache) {
        HashMap<String, Class<T>> aliasesToAdd = new HashMap<String, Class<T>>();
        for (Map.Entry<String, Class<T>> entry : pluginCache.entrySet()) {
            String aliasName;
            String realPluginName = entry.getKey();
            Optional<String> alias = this.aliasRegistry.aliasFromOriginal(type, realPluginName);
            if (!alias.isPresent() || pluginCache.containsKey(aliasName = alias.get())) continue;
            aliasesToAdd.put(aliasName, entry.getValue());
            String typeStr = type.name().toLowerCase();
            LOGGER.info("Plugin {}-{} is aliased as {}-{}", (Object)typeStr, (Object)realPluginName, (Object)typeStr, (Object)aliasName);
        }
        for (Map.Entry<String, Class<Object>> entry : aliasesToAdd.entrySet()) {
            pluginCache.put(entry.getKey(), entry.getValue());
        }
    }

    public Class<?> getPluginClass(PluginLookup.PluginType pluginType, String pluginName) {
        switch (pluginType) {
            case FILTER: {
                return this.getFilterClass(pluginName);
            }
            case OUTPUT: {
                return this.getOutputClass(pluginName);
            }
            case INPUT: {
                return this.getInputClass(pluginName);
            }
            case CODEC: {
                return this.getCodecClass(pluginName);
            }
        }
        throw new IllegalStateException("Unknown plugin type: " + pluginType);
    }

    public Class<Input> getInputClass(String name) {
        return this.inputs.get(name);
    }

    public Class<Filter> getFilterClass(String name) {
        return this.filters.get(name);
    }

    public Class<Codec> getCodecClass(String name) {
        return this.codecs.get(name);
    }

    public Class<Output> getOutputClass(String name) {
        return this.outputs.get(name);
    }

    public Codec getCodec(String name, co.elastic.logstash.api.Configuration configuration, Context context) {
        if (name != null && this.codecs.containsKey(name)) {
            return this.instantiateCodec(this.codecs.get(name), configuration, context);
        }
        return null;
    }

    private Codec instantiateCodec(Class clazz, co.elastic.logstash.api.Configuration configuration, Context context) {
        try {
            Constructor constructor = clazz.getConstructor(co.elastic.logstash.api.Configuration.class, Context.class);
            return (Codec)constructor.newInstance(configuration, context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate codec", e);
        }
    }
}

