/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsDynamicCallCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J%\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00072\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r0\u0017H\u0082\bR\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsDynamicCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "isArrayAccessWithMultipleIndices", "", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Z", "isInOperator", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "isRangeOperator", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSpreadOperator", "forAllSpreadArgumentsOf", "call", "callback", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsDynamicCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsDynamicCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsDynamicCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,107:1\n95#1,12:108\n95#1,12:121\n47#2:120\n*S KotlinDebug\n*F\n+ 1 FirJsDynamicCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsDynamicCallChecker\n*L\n55#1:108,12\n87#1:121,12\n69#1:120\n*E\n"})
public final class FirJsDynamicCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJsDynamicCallChecker INSTANCE = new FirJsDynamicCallChecker();

    private FirJsDynamicCallChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference callee = firResolvedNamedReference;
        if (!(callee.getResolvedSymbol().getOrigin() instanceof FirDeclarationOrigin.DynamicScope)) {
            this.checkSpreadOperator(expression2, context, reporter);
            return;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(callee, false, 1, null);
        if (firCallableSymbol == null) {
            throw new IllegalStateException("Resolved call callee without a callable symbol".toString());
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        if (this.isArrayAccessWithMultipleIndices(expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"indexed access with more than one index", (DiagnosticContext)context, null, 16, null);
        } else if (this.isInOperator(expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`in` operation", (DiagnosticContext)context, null, 16, null);
        } else if (this.isRangeOperator(expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)('`' + (String)FirJsDynamicCallCheckerKt.access$getNameToOperator$p().get(symbol2.getName()) + "` operation"), (DiagnosticContext)context, null, 16, null);
        } else if (expression2 instanceof FirComponentCall) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`destructuring declaration", (DiagnosticContext)context, null, 16, null);
        }
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        for (FirExpression argument$iv : ((FirCall)expression2).getArgumentList().getArguments()) {
            if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
            for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                FirExpression it = it$iv;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getSPREAD_OPERATOR_IN_DYNAMIC_CALL(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final boolean isArrayAccessWithMultipleIndices(FirCall $this$isArrayAccessWithMultipleIndices) {
        FirReference firReference = FirExpressionUtilKt.getCalleeReference($this$isArrayAccessWithMultipleIndices);
        FirNamedReference firNamedReference = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (firNamedReference == null) {
            return false;
        }
        FirNamedReference callee = firNamedReference;
        KtSourceElement ktSourceElement = callee.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            return false;
        }
        FirCall $this$arguments$iv = $this$isArrayAccessWithMultipleIndices;
        boolean $i$f$getArguments = false;
        Object object = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        Object object2 = object instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)object : null;
        if (object2 == null || (object2 = ((FirVarargArgumentsExpression)object2).getArguments()) == null) {
            return false;
        }
        Object arguments2 = object2;
        return Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.GET) && arguments2.size() >= 2 || Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.SET) && arguments2.size() >= 3;
    }

    private final boolean isInOperator(FirFunctionCall $this$isInOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isInOperator.getCalleeReference());
        return Intrinsics.areEqual((Object)(firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null), (Object)OperatorNameConventions.CONTAINS) && $this$isInOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final boolean isRangeOperator(FirFunctionCall $this$isRangeOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isRangeOperator.getCalleeReference());
        Name name2 = firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null;
        return (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.RANGE_TO) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.RANGE_UNTIL)) && $this$isRangeOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final void checkSpreadOperator(FirCall expression2, CheckerContext context, DiagnosticReporter reporter) {
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        for (FirExpression argument$iv : expression2.getArgumentList().getArguments()) {
            if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
            for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                FirExpression it = it$iv;
                boolean bl = false;
                if (!(FirTypeUtilsKt.getConeType(it.getTypeRef()) instanceof ConeDynamicType)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"spread operator", (DiagnosticContext)context, null, 16, null);
            }
        }
    }
}

