/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;

public class ResolveExceptionContextualizer {
    private final DomainObjectContext domainObjectContext;
    private final DocumentationRegistry documentationRegistry;

    public ResolveExceptionContextualizer(DomainObjectContext domainObjectContext, DocumentationRegistry documentationRegistry) {
        this.domainObjectContext = domainObjectContext;
        this.documentationRegistry = documentationRegistry;
    }

    public ResolveException contextualize(Throwable e, ResolveContext resolveContext) {
        if (e instanceof ResolveException) {
            return this.contextualize((ResolveException)e, resolveContext.getName());
        }
        ResolveException result = ResolveExceptionContextualizer.maybeContextualize(resolveContext.getDisplayName(), Collections.singletonList(e), resolveContext.getDomainObjectContext(), this.documentationRegistry);
        if (result == null) {
            return new ResolveException(resolveContext.getDisplayName(), e);
        }
        return result;
    }

    public ResolveException contextualize(ResolveException e, String resolveContextName) {
        ResolveException result = ResolveExceptionContextualizer.maybeContextualize(resolveContextName, e.getCauses(), this.domainObjectContext, this.documentationRegistry);
        if (result == null) {
            return e;
        }
        return result;
    }

    @Nullable
    public ResolveException maybeContextualize(Collection<? extends Throwable> causes, ResolveContext resolveContext) {
        return ResolveExceptionContextualizer.maybeContextualize(resolveContext.getDisplayName(), causes, resolveContext.getDomainObjectContext(), this.documentationRegistry);
    }

    @Nullable
    private static ResolveException maybeContextualize(String contextName, Collection<? extends Throwable> causes, DomainObjectContext domainObjectContext, DocumentationRegistry documentationRegistry) {
        try {
            boolean ignoresSettingsRepositories = false;
            if (domainObjectContext instanceof ProjectInternal) {
                ProjectInternal project = (ProjectInternal)domainObjectContext;
                ignoresSettingsRepositories = !project.getRepositories().isEmpty() && !project.getGradle().getSettings().getDependencyResolutionManagement().getRepositories().isEmpty();
            }
            boolean hasModuleNotFound = causes.stream().anyMatch(ModuleVersionNotFoundException.class::isInstance);
            if (ignoresSettingsRepositories && hasModuleNotFound) {
                return new ResolveExceptionWithHints(contextName, causes, "The project declares repositories, effectively ignoring the repositories you have declared in the settings.\nYou can figure out how project repositories are declared by configuring your build to fail on project repositories.\n" + documentationRegistry.getDocumentationRecommendationFor("information", "declaring_repositories", "sub:fail_build_on_project_repositories"));
            }
            return null;
        }
        catch (Throwable e) {
            return new ResolveException(contextName, (Iterable)ImmutableList.builder().addAll(causes).add((Object)e).build());
        }
    }

    public static class ResolveExceptionWithHints
    extends ResolveException
    implements ResolutionProvider {
        private final List<String> resolutions;

        public ResolveExceptionWithHints(String resolveContext, Iterable<? extends Throwable> causes, String resolution) {
            super(resolveContext, causes);
            this.resolutions = ImmutableList.of((Object)resolution);
        }

        public List<String> getResolutions() {
            return this.resolutions;
        }
    }
}

